/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.abilties;

import com.ebicep.warlords.abilties.internal.AbstractAbility;
import com.ebicep.warlords.effects.FireWorkEffectPlayer;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.util.java.Pair;
import com.ebicep.warlords.util.warlords.GameRunnable;
import com.ebicep.warlords.util.warlords.PlayerFilter;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class ShadowStep
extends AbstractAbility {
    protected int totalPlayersHit = 0;
    private int fallDamageNegation = 10;

    public ShadowStep() {
        super("Shadow Step", 466.0f, 598.0f, 12.0f, 20, 15, 175);
    }

    @Override
    public void updateDescription(Player player) {
        this.description = "\u00a77Leap forward, dealing \u00a7c" + this.format(this.minDamageHeal) + " \u00a77- \u00a7c" + this.format(this.maxDamageHeal) + " \u00a77damage to\n\u00a77all enemies close on cast or when landing\n\u00a77on the ground. You take reduced fall damage\n\u00a77while leaping.\n\n\u00a77Shadow Step has reduced range when\n\u00a77holding a Flag.";
    }

    @Override
    public List<Pair<String, String>> getAbilityInfo() {
        ArrayList<Pair<String, String>> info = new ArrayList<Pair<String, String>>();
        info.add(new Pair<String, String>("Times Used", "" + this.timesUsed));
        info.add(new Pair<String, String>("Players Hit", "" + this.totalPlayersHit));
        return info;
    }

    @Override
    public boolean onActivate(final @Nonnull WarlordsPlayer wp, final @Nonnull Player player) {
        final Location playerLoc = wp.getLocation();
        wp.subtractEnergy(this.energyCost);
        Utils.playGlobalSound(playerLoc, "rogue.drainingmiasma.activation", 1.0f, 2.0f);
        Utils.playGlobalSound(playerLoc, Sound.AMBIENCE_THUNDER, 2.0f, 2.0f);
        wp.setFlagPickCooldown(2);
        if (wp.getCarriedFlag() != null) {
            player.setVelocity(playerLoc.getDirection().multiply(1).setY(0.35));
            player.setFallDistance((float)(-this.fallDamageNegation));
        } else {
            player.setVelocity(playerLoc.getDirection().multiply(1.5).setY(0.7));
            player.setFallDistance((float)(-this.fallDamageNegation));
        }
        FireWorkEffectPlayer.playFirework(wp.getLocation(), FireworkEffect.builder().withColor(Color.BLACK).with(FireworkEffect.Type.BALL).build());
        if (wp.onHorse()) {
            wp.removeHorse();
        }
        final ArrayList<WarlordsPlayer> playersHit = new ArrayList<WarlordsPlayer>();
        for (WarlordsPlayer assaultTarget : PlayerFilter.entitiesAround((Entity)player, 5.0, 5.0, 5.0).aliveEnemiesOf(wp)) {
            ++this.totalPlayersHit;
            assaultTarget.addDamageInstance(wp, this.name, this.minDamageHeal, this.maxDamageHeal, this.critChance, this.critMultiplier, false);
            Utils.playGlobalSound(playerLoc, "warrior.revenant.orbsoflife", 2.0f, 1.9f);
            playersHit.add(assaultTarget);
        }
        new GameRunnable(wp.getGame()){
            double y;
            boolean wasOnGround;
            int counter;
            {
                super(game);
                this.y = playerLoc.getY();
                this.wasOnGround = true;
                this.counter = 0;
            }

            @Override
            public void run() {
                ++this.counter;
                if (this.counter == 200 || wp.isDead()) {
                    this.cancel();
                }
                wp.getLocation(playerLoc);
                boolean hitGround = player.isOnGround() || wp.onHorse();
                this.y = playerLoc.getY();
                if (this.wasOnGround && !hitGround) {
                    this.wasOnGround = false;
                }
                if (!this.wasOnGround && hitGround) {
                    this.wasOnGround = true;
                    for (WarlordsPlayer landingTarget : PlayerFilter.entitiesAround((Entity)player, 5.0, 5.0, 5.0).aliveEnemiesOf(wp).excluding(playersHit)) {
                        ++ShadowStep.this.totalPlayersHit;
                        landingTarget.addDamageInstance(wp, ShadowStep.this.name, ShadowStep.this.minDamageHeal, ShadowStep.this.maxDamageHeal, ShadowStep.this.critChance, ShadowStep.this.critMultiplier, false);
                        Utils.playGlobalSound(playerLoc, "warrior.revenant.orbsoflife", 2.0f, 1.9f);
                    }
                    FireWorkEffectPlayer.playFirework(wp.getLocation(), FireworkEffect.builder().withColor(Color.BLACK).with(FireworkEffect.Type.BALL).build());
                    this.cancel();
                }
            }
        }.runTaskTimer(0L, 0L);
        return true;
    }

    public void setFallDamageNegation(int fallDamageNegation) {
        this.fallDamageNegation = fallDamageNegation;
    }
}

