/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.abilties;

import com.ebicep.customentities.CustomFallingBlock;
import com.ebicep.warlords.abilties.TimeWarp;
import com.ebicep.warlords.abilties.internal.AbstractAbility;
import com.ebicep.warlords.events.WarlordsEvents;
import com.ebicep.warlords.game.option.marker.FlagHolder;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.util.java.Pair;
import com.ebicep.warlords.util.warlords.GameRunnable;
import com.ebicep.warlords.util.warlords.PlayerFilter;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class SeismicWave
extends AbstractAbility {
    protected int playersHit = 0;
    protected int carrierHit = 0;
    protected int warpsKnockbacked = 0;
    private float velocity = 1.25f;

    public SeismicWave(String name, float minDamageHeal, float maxDamageHeal, float cooldown, int energyCost, int critChance, int critMultiplier) {
        super(name, minDamageHeal, maxDamageHeal, cooldown, energyCost, critChance, critMultiplier);
    }

    @Override
    public void updateDescription(Player player) {
        this.description = "\u00a77Send a wave of incredible force\n\u00a77forward that deals \u00a7c" + this.format(this.minDamageHeal) + " \u00a77- \u00a7c" + this.format(this.maxDamageHeal) + "\n\u00a77damage to all enemies hit and\nknocks them back slightly.";
    }

    @Override
    public List<Pair<String, String>> getAbilityInfo() {
        ArrayList<Pair<String, String>> info = new ArrayList<Pair<String, String>>();
        info.add(new Pair<String, String>("Times Used", "" + this.timesUsed));
        info.add(new Pair<String, String>("Players Hit", "" + this.playersHit));
        info.add(new Pair<String, String>("Carriers Hit", "" + this.carrierHit));
        info.add(new Pair<String, String>("Warps Knockbacked", "" + this.warpsKnockbacked));
        return info;
    }

    @Override
    public boolean onActivate(final WarlordsPlayer wp, Player player) {
        wp.subtractEnergy(this.energyCost);
        Utils.playGlobalSound(player.getLocation(), "warrior.seismicwave.activation", 2.0f, 1.0f);
        final ArrayList<List<Location>> fallingBlockLocations = new ArrayList<List<Location>>();
        final ArrayList customFallingBlocks = new ArrayList();
        Location location = player.getLocation();
        for (int i = 0; i < 8; ++i) {
            fallingBlockLocations.add(this.getWave(location, i));
        }
        ArrayList<WarlordsPlayer> playersHit = new ArrayList<WarlordsPlayer>();
        for (List list : fallingBlockLocations) {
            for (Location loc : list) {
                for (WarlordsPlayer waveTarget : PlayerFilter.entitiesAroundRectangle(loc, 0.6, 4.0, 0.6).aliveEnemiesOf(wp).excluding(playersHit).closestFirst(wp)) {
                    ++this.playersHit;
                    if (waveTarget.hasFlag()) {
                        ++this.carrierHit;
                    }
                    if (waveTarget.getCooldownManager().hasCooldown(TimeWarp.class) && FlagHolder.playerTryingToPick(waveTarget)) {
                        ++this.warpsKnockbacked;
                    }
                    playersHit.add(waveTarget);
                    Vector v = player.getLocation().toVector().subtract(waveTarget.getLocation().toVector()).normalize().multiply(-this.velocity).setY(0.25);
                    waveTarget.setVelocity(v, false, false);
                    waveTarget.addDamageInstance(wp, this.name, this.minDamageHeal, this.maxDamageHeal, this.critChance, this.critMultiplier, false);
                }
            }
        }
        new GameRunnable(wp.getGame()){

            @Override
            public void run() {
                Iterator iterator = fallingBlockLocations.iterator();
                if (iterator.hasNext()) {
                    List fallingBlockLocation = (List)iterator.next();
                    for (Location location : fallingBlockLocation) {
                        if (location.getWorld().getBlockAt(location.clone().add(0.0, 1.0, 0.0)).getType() != Material.AIR) continue;
                        FallingBlock fallingBlock = SeismicWave.this.addFallingBlock(location);
                        customFallingBlocks.add(new CustomFallingBlock(fallingBlock, wp, SeismicWave.this));
                        WarlordsEvents.addEntityUUID((Entity)fallingBlock);
                    }
                    fallingBlockLocations.remove(fallingBlockLocation);
                }
                for (int i = 0; i < customFallingBlocks.size(); ++i) {
                    CustomFallingBlock cfb = (CustomFallingBlock)customFallingBlocks.get(i);
                    cfb.setTicksLived(cfb.getTicksLived() + 1);
                    if (!(Utils.getDistance(cfb.getFallingBlock().getLocation(), 0.05) <= 0.25) && cfb.getTicksLived() <= 10) continue;
                    cfb.getFallingBlock().remove();
                    customFallingBlocks.remove(i);
                    --i;
                }
                if (fallingBlockLocations.isEmpty() && customFallingBlocks.isEmpty()) {
                    this.cancel();
                }
            }
        }.runTaskTimer(0L, 0L);
        return true;
    }

    private List<Location> getWave(Location center, int distance) {
        ArrayList<Location> locations = new ArrayList<Location>();
        Location location = new Location(center.getWorld(), center.getX(), center.getY(), center.getZ());
        location.setDirection(center.getDirection());
        location.setPitch(0.0f);
        locations.add(location.add(location.getDirection().multiply(distance)));
        locations.add(location.clone().add(Utils.getLeftDirection(location).multiply(1)));
        locations.add(location.clone().add(Utils.getLeftDirection(location).multiply(2)));
        locations.add(location.clone().add(Utils.getRightDirection(location).multiply(1)));
        locations.add(location.clone().add(Utils.getRightDirection(location).multiply(2)));
        return locations;
    }

    private FallingBlock addFallingBlock(Location location) {
        if (location.getWorld().getBlockAt(location).getType() != Material.AIR) {
            location.add(0.0, 1.0, 0.0);
        }
        Location blockToGet = location.clone().add(0.0, -1.0, 0.0);
        if (location.getWorld().getBlockAt(location.clone().add(0.0, -1.0, 0.0)).getType() == Material.AIR) {
            blockToGet.add(0.0, -1.0, 0.0);
            if (location.getWorld().getBlockAt(location.clone().add(0.0, -2.0, 0.0)).getType() == Material.AIR) {
                blockToGet.add(0.0, -1.0, 0.0);
            }
        }
        Material type = location.getWorld().getBlockAt(blockToGet).getType();
        byte data = location.getWorld().getBlockAt(blockToGet).getData();
        if (type == Material.GRASS && (int)(Math.random() * 3.0) == 2) {
            type = Material.DIRT;
            data = 0;
        }
        FallingBlock fallingBlock = location.getWorld().spawnFallingBlock(location, type, data);
        fallingBlock.setVelocity(new Vector(0.0, 0.14, 0.0));
        fallingBlock.setDropItem(false);
        return fallingBlock;
    }

    public float getVelocity() {
        return this.velocity;
    }

    public void setVelocity(float velocity) {
        this.velocity = velocity;
    }
}

