/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.abilties;

import com.ebicep.warlords.abilties.SoulShackle;
import com.ebicep.warlords.abilties.internal.AbstractStrikeBase;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.player.cooldowns.CooldownTypes;
import com.ebicep.warlords.util.java.Pair;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.bukkit.entity.Player;

public class RighteousStrike
extends AbstractStrikeBase {
    protected int silencedTargetStruck = 0;

    public RighteousStrike() {
        super("Righteous Strike", 412.0f, 523.0f, 0.0f, 90, 20, 175);
    }

    @Override
    public void updateDescription(Player player) {
        this.description = "\u00a77Strike the targeted enemy for \u00a7c" + this.format(this.minDamageHeal) + " \u00a77- \u00a7c" + this.format(this.maxDamageHeal) + " \u00a77damage.\n\u00a77Each strike reduces the duration of your struck\n\u00a77target's active ability timers by \u00a760.5 \u00a77seconds.\n\n\u00a77Additionally, if your struck target is silenced,\n\u00a77reduce the cooldown of your Prism Guard by \u00a760.8\n\u00a77seconds and reduce their active ability timers\n\u00a77by \u00a760.8 \u00a77seconds instead.";
    }

    @Override
    public List<Pair<String, String>> getAbilityInfo() {
        ArrayList<Pair<String, String>> info = new ArrayList<Pair<String, String>>();
        info.add(new Pair<String, String>("Times Used", "" + this.timesUsed));
        info.add(new Pair<String, String>("Times Silenced Target Struck", "" + this.silencedTargetStruck));
        return info;
    }

    @Override
    protected void onHit(@Nonnull WarlordsPlayer wp, @Nonnull Player player, @Nonnull WarlordsPlayer nearPlayer) {
        if (nearPlayer.getCooldownManager().hasCooldown(SoulShackle.class)) {
            ++this.silencedTargetStruck;
            nearPlayer.getCooldownManager().subtractTicksOnRegularCooldowns(CooldownTypes.ABILITY, 16);
            wp.getSpec().getBlue().subtractCooldown(0.8f);
            wp.getSpec().getBlue().updateDescription(player);
        } else {
            nearPlayer.getCooldownManager().subtractTicksOnRegularCooldowns(CooldownTypes.ABILITY, 10);
        }
        nearPlayer.addDamageInstance(wp, this.name, this.minDamageHeal, this.maxDamageHeal, this.critChance, this.critMultiplier, false);
    }
}

