/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.abilties;

import com.ebicep.warlords.abilties.internal.AbstractAbility;
import com.ebicep.warlords.effects.EffectUtils;
import com.ebicep.warlords.events.WarlordsDamageHealingEvent;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.player.cooldowns.CooldownTypes;
import com.ebicep.warlords.player.cooldowns.cooldowns.RegularCooldown;
import com.ebicep.warlords.util.java.Pair;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.bukkit.entity.Player;

public class Repentance
extends AbstractAbility {
    private final int duration = 12;
    private float pool = 0.0f;
    private int damageConvertPercent = 10;

    public Repentance() {
        super("Repentance", 0.0f, 0.0f, 31.32f, 20, 0, 0);
    }

    @Override
    public void updateDescription(Player player) {
        this.description = "\u00a77Taking damage empowers your damaging\n\u00a77abilities and melee hits, restoring health\n\u00a77and energy based on \u00a7c10 \u00a77+ \u00a7c" + this.damageConvertPercent + "% \u00a77of the\n\u00a77damage you've recently took. Lasts \u00a76" + 12 + " \u00a77seconds.";
    }

    @Override
    public List<Pair<String, String>> getAbilityInfo() {
        ArrayList<Pair<String, String>> info = new ArrayList<Pair<String, String>>();
        info.add(new Pair<String, String>("Times Used", "" + this.timesUsed));
        return info;
    }

    @Override
    public boolean onActivate(@Nonnull WarlordsPlayer wp, @Nonnull Player player) {
        wp.subtractEnergy(this.energyCost);
        Utils.playGlobalSound(player.getLocation(), "paladin.barrieroflight.impact", 2.0f, 1.35f);
        EffectUtils.playCylinderAnimation(player, 1.0, 255, 255, 255);
        this.pool += 2000.0f;
        wp.getCooldownManager().addCooldown(new RegularCooldown<Repentance>(this.name, "REPE", Repentance.class, new Repentance(), wp, CooldownTypes.ABILITY, cooldownManager -> {}, 240){

            @Override
            public boolean distinct() {
                return true;
            }

            @Override
            public void onDamageFromAttacker(WarlordsDamageHealingEvent event, float currentDamageValue, boolean isCrit) {
                WarlordsPlayer attacker = event.getAttacker();
                int healthToAdd = (int)(Repentance.this.pool * ((float)Repentance.this.damageConvertPercent / 100.0f)) + 10;
                attacker.addHealingInstance(attacker, "Repentance", healthToAdd, healthToAdd, -1, 100, false, false);
                attacker.addEnergy(attacker, "Repentance", (float)((double)healthToAdd * 0.035));
                Repentance.this.pool = (float)((double)Repentance.this.pool * 0.5);
            }
        });
        return true;
    }

    public float getPool() {
        return this.pool;
    }

    public void setPool(float pool) {
        this.pool = pool;
    }

    public int getDamageConvertPercent() {
        return this.damageConvertPercent;
    }

    public void setDamageConvertPercent(int damageConvertPercent) {
        this.damageConvertPercent = damageConvertPercent;
    }

    public void addToPool(float amount) {
        this.pool += amount;
    }

    @Override
    public void runEverySecond() {
        if (this.pool > 0.0f) {
            float newPool = this.pool * 0.8f - 60.0f;
            this.pool = Math.max(newPool, 0.0f);
        }
    }
}

