/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.abilties;

import com.ebicep.warlords.abilties.internal.AbstractAbility;
import com.ebicep.warlords.effects.EffectUtils;
import com.ebicep.warlords.effects.ParticleEffect;
import com.ebicep.warlords.events.WarlordsDamageHealingEvent;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.player.cooldowns.AbstractCooldown;
import com.ebicep.warlords.player.cooldowns.CooldownTypes;
import com.ebicep.warlords.player.cooldowns.cooldowns.RegularCooldown;
import com.ebicep.warlords.util.java.Pair;
import com.ebicep.warlords.util.java.TriConsumer;
import com.ebicep.warlords.util.warlords.PlayerFilter;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.bukkit.ChatColor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class RemedicChains
extends AbstractAbility {
    private final int duration = 8;
    private final int alliesAffected = 3;
    private final float healingMultiplier = 0.125f;
    protected int playersLinked = 0;
    protected int numberOfBrokenLinks = 0;
    private int linkBreakRadius = 15;

    public RemedicChains() {
        super("Remedic Chains", 728.0f, 815.0f, 16.0f, 50, 20, 200);
    }

    @Override
    public void updateDescription(Player player) {
        this.description = "\u00a77Bind yourself to \u00a7e3 \u00a77allies near you, increasing\n\u00a77the damage they deal by \u00a7c12% \u00a77as long as the\n\u00a77link is active. Lasts \u00a768 \u00a77seconds\n\n\u00a77When the link expires you and the allies\n\u00a77are healed for \u00a7a" + this.format(this.minDamageHeal) + " \u00a77- \u00a7a" + this.format(this.maxDamageHeal) + " \u00a77health. Breaking\n\u00a77the link early will only heal the allies\n\u00a77for \u00a7a12.5% \u00a77of the original amount for\neach second they have been linked.\n\n\u00a77The link will break if you are \u00a7e" + this.linkBreakRadius + " \u00a77blocks apart.";
    }

    @Override
    public List<Pair<String, String>> getAbilityInfo() {
        ArrayList<Pair<String, String>> info = new ArrayList<Pair<String, String>>();
        info.add(new Pair<String, String>("Times Used", "" + this.timesUsed));
        info.add(new Pair<String, String>("Players Linked", "" + this.playersLinked));
        info.add(new Pair<String, String>("Times Link Broke", "" + this.numberOfBrokenLinks));
        return info;
    }

    @Override
    public boolean onActivate(@Nonnull WarlordsPlayer wp, @Nonnull Player player) {
        List teammatesNear = PlayerFilter.entitiesAround((Entity)player, 10.0, 10.0, 10.0).aliveTeammatesOfExcludingSelf(wp).closestFirst(wp).limit(3L).stream().collect(Collectors.toList());
        if (teammatesNear.size() >= 1) {
            wp.subtractEnergy(this.energyCost);
            Utils.playGlobalSound(player.getLocation(), "rogue.remedicchains.activation", 2.0f, 0.2f);
            RemedicChains tempRemedicChain = new RemedicChains();
            wp.getCooldownManager().addCooldown(new RegularCooldown<RemedicChains>(this.name, "REMEDIC", RemedicChains.class, tempRemedicChain, wp, CooldownTypes.ABILITY, cooldownManager -> {
                if (wp.isDead()) {
                    return;
                }
                wp.addHealingInstance(wp, this.name, this.minDamageHeal, this.maxDamageHeal, this.critChance, this.critMultiplier, false, false);
            }, 160){

                @Override
                public float modifyDamageBeforeInterveneFromAttacker(WarlordsDamageHealingEvent event, float currentDamageValue) {
                    return currentDamageValue * 1.12f;
                }
            });
            for (WarlordsPlayer chainTarget : teammatesNear) {
                ++this.playersLinked;
                AtomicInteger timeLinked = new AtomicInteger();
                chainTarget.getCooldownManager().addCooldown(new RegularCooldown<RemedicChains>(this.name, "REMEDIC", RemedicChains.class, tempRemedicChain, wp, CooldownTypes.ABILITY, cooldownManager -> {
                    boolean outOfRange = wp.getLocation().distanceSquared(chainTarget.getLocation()) > (double)(this.linkBreakRadius * this.linkBreakRadius);
                    Utils.playGlobalSound(chainTarget.getLocation(), "rogue.remedicchains.impact", 0.1f, 1.4f);
                    ParticleEffect.VILLAGER_HAPPY.display(0.5f, 0.5f, 0.5f, 1.0f, 10, chainTarget.getLocation().add(0.0, 1.0, 0.0), 500.0);
                    if (!outOfRange && chainTarget.isAlive()) {
                        chainTarget.addHealingInstance(wp, this.name, this.minDamageHeal, this.maxDamageHeal, this.critChance, this.critMultiplier, false, false);
                    }
                }, 160, new TriConsumer[]{(cooldown, ticksLeft, counter) -> {
                    boolean outOfRange;
                    boolean bl = outOfRange = wp.getLocation().distanceSquared(chainTarget.getLocation()) > (double)(this.linkBreakRadius * this.linkBreakRadius);
                    if (counter % 20 == 0 && !outOfRange) {
                        timeLinked.getAndIncrement();
                    }
                    if (counter % 8 == 0) {
                        if (wp.getCooldownManager().hasCooldown(tempRemedicChain)) {
                            EffectUtils.playParticleLinkAnimation(wp.getLocation(), chainTarget.getLocation(), 250, 200, 250, 1);
                            if (outOfRange) {
                                ++this.numberOfBrokenLinks;
                                float totalHealingMultiplier = 0.125f * (float)timeLinked.get();
                                chainTarget.addHealingInstance(wp, this.name, this.minDamageHeal * totalHealingMultiplier, this.maxDamageHeal * totalHealingMultiplier, -1, 100, false, false);
                                chainTarget.getCooldownManager().removeCooldown((AbstractCooldown<?>)cooldown);
                            }
                        } else {
                            cooldown.setTicksLeft(0);
                        }
                    }
                }}){

                    @Override
                    public float modifyDamageBeforeInterveneFromAttacker(WarlordsDamageHealingEvent event, float currentDamageValue) {
                        return currentDamageValue * 1.12f;
                    }
                });
                wp.sendMessage(WarlordsPlayer.GIVE_ARROW_GREEN + ChatColor.GRAY + " Your Remedic Chains is now protecting " + ChatColor.YELLOW + chainTarget.getName() + ChatColor.GRAY + "!");
                chainTarget.sendMessage(WarlordsPlayer.RECEIVE_ARROW_GREEN + " " + ChatColor.GRAY + wp.getName() + "'s" + ChatColor.YELLOW + " Remedic Chains" + ChatColor.GRAY + " is now increasing your \u00a7cdamage \u00a77for " + ChatColor.GOLD + 8 + ChatColor.GRAY + " seconds!");
            }
            return true;
        }
        wp.sendMessage(ChatColor.RED + "There are no allies nearby to link!");
        return false;
    }

    public int getLinkBreakRadius() {
        return this.linkBreakRadius;
    }

    public void setLinkBreakRadius(int linkBreakRadius) {
        this.linkBreakRadius = linkBreakRadius;
    }
}

