/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.abilties;

import com.ebicep.warlords.abilties.internal.AbstractAbility;
import com.ebicep.warlords.effects.ParticleEffect;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.util.bukkit.PacketUtils;
import com.ebicep.warlords.util.java.Pair;
import com.ebicep.warlords.util.warlords.GameRunnable;
import com.ebicep.warlords.util.warlords.PlayerFilter;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.util.Vector;

public class RecklessCharge
extends AbstractAbility
implements Listener {
    protected int playersCharged = 0;
    private static final List<UUID> stunnedPlayers = new ArrayList<UUID>();
    private int stunTimeInTicks = 10;

    public RecklessCharge() {
        super("Reckless Charge", 457.0f, 601.0f, 9.32f, 60, 20, 200);
    }

    @Override
    public void updateDescription(Player player) {
        double stunDuration = this.stunTimeInTicks == 10 ? 0.5 : 0.75;
        this.description = "\u00a77Charge forward, dealing \u00a7c" + this.format(this.minDamageHeal) + "\n\u00a77- \u00a7c" + this.format(this.maxDamageHeal) + " \u00a77damage to all enemies\n\u00a77you pass through. Enemies hit are\n\u00a75IMMOBILIZED\u00a77, preventing movement\n\u00a77for \u00a76" + stunDuration + " \u00a77seconds. Charge is reduced\n\u00a77when carrying a flag.";
    }

    @Override
    public List<Pair<String, String>> getAbilityInfo() {
        ArrayList<Pair<String, String>> info = new ArrayList<Pair<String, String>>();
        info.add(new Pair<String, String>("Times Used", "" + this.timesUsed));
        info.add(new Pair<String, String>("Players Charged", "" + this.playersCharged));
        return info;
    }

    @Override
    public boolean onActivate(final WarlordsPlayer wp, Player player) {
        double chargeDistance;
        wp.subtractEnergy(this.energyCost);
        Utils.playGlobalSound(player.getLocation(), "warrior.seismicwave.activation", 2.0f, 1.0f);
        final Location location = player.getLocation();
        location.setPitch(0.0f);
        final Location chargeLocation = location.clone();
        final ArrayList playersHit = new ArrayList();
        boolean inAir = false;
        if (location.getWorld().getBlockAt(location.clone().add(0.0, -1.0, 0.0)).getType() != Material.AIR) {
            inAir = true;
            chargeDistance = 5.0;
        } else {
            chargeDistance = Math.max(Math.min(Utils.getDistance((Entity)player, 0.1) * 5.0, 6.9), 6.0);
        }
        final boolean finalInAir = inAir;
        final double finalChargeDistance = chargeDistance;
        new GameRunnable(wp.getGame()){
            int maxChargeDuration;
            {
                super(game);
                this.maxChargeDuration = 5;
            }

            @Override
            public void run() {
                if (this.maxChargeDuration == 5) {
                    if (finalInAir) {
                        wp.setVelocity(location.getDirection().multiply(2).setY(0.2), true);
                    } else {
                        wp.setVelocity(location.getDirection().multiply(1.5).setY(0.2), true);
                    }
                }
                if (wp.getLocation().distanceSquared(chargeLocation) > finalChargeDistance * finalChargeDistance || wp.getEntity().getVelocity().getX() == 0.0 && wp.getEntity().getVelocity().getZ() == 0.0 || this.maxChargeDuration <= 0) {
                    wp.setVelocity(new Vector(0, 0, 0), true);
                    this.cancel();
                }
                for (int i = 0; i < 4; ++i) {
                    ParticleEffect.REDSTONE.display((ParticleEffect.ParticleColor)new ParticleEffect.OrdinaryColor(255, 0, 0), wp.getLocation().clone().add(Math.random() * 1.5 - 0.75, 0.5 + Math.random() * 2.0 - 1.0, Math.random() * 1.5 - 0.75), 500.0);
                }
                PlayerFilter.entitiesAround(wp, 2.5, 5.0, 2.5).excluding(playersHit).aliveEnemiesOf(wp).forEach((Consumer<? super WarlordsPlayer>)((Consumer<WarlordsPlayer>)enemy -> {
                    ++RecklessCharge.this.playersCharged;
                    playersHit.add(enemy);
                    stunnedPlayers.add(enemy.getUuid());
                    enemy.addDamageInstance(wp, RecklessCharge.this.name, RecklessCharge.this.minDamageHeal, RecklessCharge.this.maxDamageHeal, RecklessCharge.this.critChance, RecklessCharge.this.critMultiplier, false);
                    new GameRunnable(wp.getGame(), (WarlordsPlayer)enemy){
                        final /* synthetic */ WarlordsPlayer val$enemy;
                        {
                            this.val$enemy = warlordsPlayer;
                            super(game);
                        }

                        @Override
                        public void run() {
                            stunnedPlayers.remove(this.val$enemy.getUuid());
                        }
                    }.runTaskLater(RecklessCharge.this.getStunTimeInTicks());
                    if (enemy.getEntity() instanceof Player) {
                        PacketUtils.sendTitle((Player)enemy.getEntity(), "", "\u00a7dIMMOBILIZED", 0, 10, 0);
                    }
                }));
                --this.maxChargeDuration;
            }
        }.runTaskTimer(1L, 0L);
        return true;
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent e) {
        if (stunnedPlayers.contains(e.getPlayer().getUniqueId()) && (e.getFrom().getX() != e.getTo().getX() || e.getFrom().getZ() != e.getTo().getZ()) && !(e instanceof PlayerTeleportEvent)) {
            e.getPlayer().teleport(e.getFrom());
        }
    }

    public int getStunTimeInTicks() {
        return this.stunTimeInTicks;
    }

    public void setStunTimeInTicks(int stunTimeInTicks) {
        this.stunTimeInTicks = stunTimeInTicks;
    }
}

