/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.abilties;

import com.ebicep.warlords.Warlords;
import com.ebicep.warlords.abilties.Consecrate;
import com.ebicep.warlords.abilties.HolyRadianceProtector;
import com.ebicep.warlords.abilties.internal.AbstractStrikeBase;
import com.ebicep.warlords.events.WarlordsDamageHealingEvent;
import com.ebicep.warlords.player.SkillBoosts;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.player.cooldowns.CooldownTypes;
import com.ebicep.warlords.player.cooldowns.cooldowns.DamageHealCompleteCooldown;
import com.ebicep.warlords.util.java.Pair;
import com.ebicep.warlords.util.warlords.PlayerFilter;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import org.bukkit.entity.Player;

public class ProtectorsStrike
extends AbstractStrikeBase {
    private int minConvert = 75;
    private int maxConvert = 100;

    public ProtectorsStrike() {
        super("Protector's Strike", 261.0f, 352.0f, 0.0f, 90, 20, 175);
    }

    @Override
    public void updateDescription(Player player) {
        this.description = "\u00a77Strike the targeted enemy player,\n\u00a77causing \u00a7c261 \u00a77- \u00a7c352 \u00a77damage\n\u00a77and healing two nearby allies for\n\u00a7a" + this.maxConvert + "-" + this.minConvert + "% \u00a77of the damage done. Also\n\u00a77heals yourself by \u00a7a50-75% \u00a77of the\n\u00a77damage done. Based on your current\nhealth.";
    }

    @Override
    public List<Pair<String, String>> getAbilityInfo() {
        ArrayList<Pair<String, String>> info = new ArrayList<Pair<String, String>>();
        info.add(new Pair<String, String>("Times Struck", "" + this.timesUsed));
        return info;
    }

    @Override
    protected void onHit(final @Nonnull WarlordsPlayer wp, @Nonnull Player player, @Nonnull WarlordsPlayer nearPlayer) {
        wp.getCooldownManager().addCooldown(new DamageHealCompleteCooldown<ProtectorsStrike>("Protectors Strike", "", ProtectorsStrike.class, new ProtectorsStrike(), wp, CooldownTypes.ABILITY, cooldownManager -> {}){

            @Override
            public void onDamageFromAttacker(WarlordsDamageHealingEvent event, float currentDamageValue, boolean isCrit) {
                String ability = event.getAbility();
                if (ability.equals("Protector's Strike")) {
                    float healthFraction = Utils.lerp(0.0f, 1.0f, (float)wp.getHealth() / (float)wp.getMaxHealth());
                    if (healthFraction > 1.0f) {
                        healthFraction = 1.0f;
                    }
                    if (healthFraction < 0.0f) {
                        healthFraction = 0.0f;
                    }
                    float allyHealing = 0.75f + healthFraction * 0.25f;
                    float ownHealing = 0.5f + (1.0f - healthFraction) * 0.25f;
                    wp.addHealingInstance(wp, ability, currentDamageValue * ownHealing, currentDamageValue * ownHealing, isCrit ? 100 : -1, 100, false, false);
                    for (WarlordsPlayer ally : PlayerFilter.entitiesAround(wp, 10.0, 10.0, 10.0).aliveTeammatesOfExcludingSelf(wp).sorted(Comparator.comparing(p -> p.getCooldownManager().hasCooldown(HolyRadianceProtector.class) ? 0 : 1).thenComparing(Utils.sortClosestBy(WarlordsPlayer::getLocation, wp.getLocation()))).limit(2L)) {
                        if (Warlords.getPlayerSettings(wp.getUuid()).getSkillBoostForClass() == SkillBoosts.PROTECTOR_STRIKE) {
                            ally.addHealingInstance(wp, ability, currentDamageValue * allyHealing * 1.2f, currentDamageValue * allyHealing * 1.2f, isCrit ? 100 : -1, 100, false, false);
                            continue;
                        }
                        ally.addHealingInstance(wp, ability, currentDamageValue * allyHealing, currentDamageValue * allyHealing, isCrit ? 100 : -1, 100, false, false);
                    }
                }
            }
        });
        if (this.standingOnConsecrate(wp, nearPlayer)) {
            wp.doOnStaticAbility(Consecrate.class, Consecrate::addStrikesBoosted);
            nearPlayer.addDamageInstance(wp, this.name, this.minDamageHeal * 1.15f, this.maxDamageHeal * 1.15f, this.critChance, this.critMultiplier, false);
        } else {
            nearPlayer.addDamageInstance(wp, this.name, this.minDamageHeal, this.maxDamageHeal, this.critChance, this.critMultiplier, false);
        }
    }

    public void setMinConvert(int convertPercent) {
        this.minConvert = convertPercent;
    }

    public void setMaxConvert(int selfConvertPercent) {
        this.maxConvert = selfConvertPercent;
    }
}

