/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.abilties;

import com.ebicep.warlords.abilties.internal.AbstractAbility;
import com.ebicep.warlords.effects.EffectUtils;
import com.ebicep.warlords.effects.ParticleEffect;
import com.ebicep.warlords.effects.circle.CircleEffect;
import com.ebicep.warlords.effects.circle.CircumferenceEffect;
import com.ebicep.warlords.events.WarlordsDamageHealingEvent;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.player.cooldowns.CooldownTypes;
import com.ebicep.warlords.player.cooldowns.cooldowns.RegularCooldown;
import com.ebicep.warlords.util.java.Pair;
import com.ebicep.warlords.util.java.TriConsumer;
import com.ebicep.warlords.util.warlords.GameRunnable;
import com.ebicep.warlords.util.warlords.PlayerFilter;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.bukkit.Sound;
import org.bukkit.entity.Player;

public class PrismGuard
extends AbstractAbility {
    protected int timesProjectilesReduced = 0;
    protected int timesOtherReduced = 0;
    private final int bubbleRadius = 4;
    private final int duration = 4;
    private int bubbleHealing = 600;
    private int projectileDamageReduction = 60;
    private int damageReduction = 25;

    public PrismGuard() {
        super("Prism Guard", 0.0f, 0.0f, 24.0f, 40, -1, 100);
    }

    @Override
    public void updateDescription(Player player) {
        this.description = "\u00a77Create a bubble shield around you that\n\u00a77lasts \u00a764 \u00a77seconds. All projectiles that pass through\n\u00a77the barrier have their damage reduced by \u00a7c" + this.projectileDamageReduction + "%\u00a77.\n\u00a77Additionally, other damage taken by all allies inside\n\u00a77the bubble is reduced by \u00a7c" + this.damageReduction + "%\u00a77.\n\n\u00a77After \u00a76" + 4 + " \u00a77seconds the bubble will burst, healing\n\u00a77you for \u00a7a" + this.bubbleHealing + " \u00a77+ \u00a7a20% \u00a77missing health and\n\u00a77allies for half the amount based on how long\n\u00a77they've been in the bubble.\n";
    }

    @Override
    public List<Pair<String, String>> getAbilityInfo() {
        ArrayList<Pair<String, String>> info = new ArrayList<Pair<String, String>>();
        info.add(new Pair<String, String>("Times Used", "" + this.timesUsed));
        info.add(new Pair<String, String>("Times Projectiles Damage Reduced", "" + this.timesProjectilesReduced));
        info.add(new Pair<String, String>("Times Other Damage Reduced", "" + this.timesOtherReduced));
        return info;
    }

    @Override
    public boolean onActivate(final @Nonnull WarlordsPlayer wp, @Nonnull Player player) {
        wp.subtractEnergy(this.energyCost);
        Utils.playGlobalSound(wp.getLocation(), "mage.timewarp.teleport", 2.0f, 2.0f);
        Utils.playGlobalSound(player.getLocation(), "warrior.intervene.impact", 2.0f, 0.1f);
        EffectUtils.playSphereAnimation(wp.getLocation(), 6.5, 68, 176, 176);
        new GameRunnable(wp.getGame()){

            @Override
            public void run() {
                EffectUtils.playSphereAnimation(wp.getLocation(), 5.0, 65, 185, 185);
                Utils.playGlobalSound(wp.getLocation(), "warrior.intervene.impact", 2.0f, 0.2f);
            }
        }.runTaskLater(3L);
        final HashSet isInsideBubble = new HashSet();
        HashMap timeInBubble = new HashMap();
        PrismGuard tempWideGuard = new PrismGuard();
        wp.getCooldownManager().addCooldown(new RegularCooldown<PrismGuard>("Prism Guard", "GUARD", PrismGuard.class, tempWideGuard, wp, CooldownTypes.ABILITY, cooldownManager -> {
            if (wp.isDead()) {
                return;
            }
            Utils.playGlobalSound(wp.getLocation(), "paladin.holyradiance.activation", 2.0f, 1.4f);
            Utils.playGlobalSound(wp.getLocation(), Sound.AMBIENCE_THUNDER, 2.0f, 1.5f);
            new CircleEffect(wp.getGame(), wp.getTeam(), wp.getLocation(), 4.0, new CircumferenceEffect(ParticleEffect.SPELL).particlesPerCircumference(2.0)).playEffects();
            float healingValue = (float)this.bubbleHealing + (float)(wp.getMaxHealth() - wp.getHealth()) * 0.2f;
            wp.addHealingInstance(wp, this.name, healingValue, healingValue, -1, 100, false, false);
            for (Map.Entry entry : timeInBubble.entrySet()) {
                float teammateHealingValue = (float)this.bubbleHealing / 8.0f + (float)(((WarlordsPlayer)entry.getKey()).getMaxHealth() - ((WarlordsPlayer)entry.getKey()).getHealth()) * 0.05f;
                int timeInSeconds = (Integer)entry.getValue() * 3 / 20;
                float totalHealing = (float)timeInSeconds * teammateHealingValue;
                ((WarlordsPlayer)entry.getKey()).addHealingInstance(wp, this.name, totalHealing, totalHealing, -1, 100, false, false);
            }
        }, 80, new TriConsumer[]{(cooldown, ticksLeft, counter) -> {
            if (counter < 5) {
                return;
            }
            if (counter % 3 == 0) {
                EffectUtils.playSphereAnimation(wp.getLocation(), 4.0, 190, 190, 190);
                Utils.playGlobalSound(wp.getLocation(), Sound.CREEPER_DEATH, 2.0f, 2.0f);
                isInsideBubble.clear();
                for (WarlordsPlayer enemyInsideBubble : PlayerFilter.entitiesAround(wp, 4.0, 4.0, 4.0).aliveEnemiesOf(wp)) {
                    isInsideBubble.add(enemyInsideBubble);
                }
                for (WarlordsPlayer bubblePlayer : PlayerFilter.entitiesAround(wp, 4.0, 4.0, 4.0).aliveTeammatesOfExcludingSelf(wp)) {
                    bubblePlayer.getCooldownManager().removeCooldown(PrismGuard.class);
                    bubblePlayer.getCooldownManager().addCooldown(new RegularCooldown<PrismGuard>("Prism Guard", "GUARD", PrismGuard.class, tempWideGuard, wp, CooldownTypes.ABILITY, cooldownManager -> {}, 20){

                        @Override
                        public float modifyDamageAfterInterveneFromSelf(WarlordsDamageHealingEvent event, float currentDamageValue) {
                            String ability = event.getAbility();
                            if (PrismGuard.this.isProjectile(ability)) {
                                if (isInsideBubble.contains(event.getAttacker())) {
                                    return currentDamageValue;
                                }
                                ++PrismGuard.this.timesProjectilesReduced;
                                return currentDamageValue * (float)(100 - PrismGuard.this.projectileDamageReduction) / 100.0f;
                            }
                            ++PrismGuard.this.timesOtherReduced;
                            return currentDamageValue * (float)(100 - PrismGuard.this.damageReduction) / 100.0f;
                        }
                    });
                    timeInBubble.compute(bubblePlayer, (k, v) -> v == null ? 1 : v + 1);
                }
            }
        }}){

            @Override
            public float modifyDamageAfterInterveneFromSelf(WarlordsDamageHealingEvent event, float currentDamageValue) {
                String ability = event.getAbility();
                if (PrismGuard.this.isProjectile(ability)) {
                    if (isInsideBubble.contains(event.getAttacker())) {
                        return currentDamageValue;
                    }
                    ++PrismGuard.this.timesProjectilesReduced;
                    return currentDamageValue * (float)(100 - PrismGuard.this.projectileDamageReduction) / 100.0f;
                }
                ++PrismGuard.this.timesOtherReduced;
                return currentDamageValue * (float)(100 - PrismGuard.this.damageReduction) / 100.0f;
            }
        });
        return true;
    }

    private boolean isProjectile(String ability) {
        return ability.equals("Fireball") || ability.equals("Frostbolt") || ability.equals("Water Bolt") || ability.equals("Lightning Bolt") || ability.equals("Flame Burst") || ability.equals("Fallen Souls") || ability.equals("Soothing Elixir");
    }

    public int getProjectileDamageReduction() {
        return this.projectileDamageReduction;
    }

    public void setProjectileDamageReduction(int projectileDamageReduction) {
        this.projectileDamageReduction = projectileDamageReduction;
    }

    public int getDamageReduction() {
        return this.damageReduction;
    }

    public void setDamageReduction(int damageReduction) {
        this.damageReduction = damageReduction;
    }

    public int getBubbleHealing() {
        return this.bubbleHealing;
    }

    public void setBubbleHealing(int bubbleHealing) {
        this.bubbleHealing = bubbleHealing;
    }
}

