/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.abilties;

import com.ebicep.warlords.abilties.internal.AbstractAbility;
import com.ebicep.warlords.effects.ParticleEffect;
import com.ebicep.warlords.events.WarlordsDamageHealingEvent;
import com.ebicep.warlords.game.option.marker.FlagHolder;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.player.cooldowns.CooldownTypes;
import com.ebicep.warlords.player.cooldowns.cooldowns.RegularCooldown;
import com.ebicep.warlords.util.java.Pair;
import com.ebicep.warlords.util.java.TriConsumer;
import com.ebicep.warlords.util.warlords.GameRunnable;
import com.ebicep.warlords.util.warlords.PlayerFilter;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.bukkit.ChatColor;
import org.bukkit.Sound;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class OrderOfEviscerate
extends AbstractAbility {
    protected int numberOfFullResets = 0;
    protected int numberOfHalfResets = 0;
    protected int numberOfBackstabs = 0;
    private int duration = 8;
    private float damageThreshold = 0.0f;
    private WarlordsPlayer markedPlayer;

    public OrderOfEviscerate() {
        super("Order of Eviscerate", 0.0f, 0.0f, 50.0f, 60, -1, 100);
    }

    @Override
    public void updateDescription(Player player) {
        this.description = "\u00a77Cloak yourself for \u00a76" + this.duration + " \u00a77seconds, granting\n\u00a77you \u00a7e40% \u00a77movement speed and making you \u00a7einvisible\n\u00a77to the enemy for the duration. However, taking up to\n\u00a7c600 \u00a77fall damage or any type of ability damage will\n\u00a77end your invisibility.\n\n\u00a77All your attacks against an enemy will mark them vulnerable.\n\u00a77Vulnerable enemies take \u00a7c20% \u00a77more damage. Additionally,\n\u00a77enemies hit from behind take an additional \u00a7c10% \u00a77more damage.\n\n\u00a77Successfully killing your mark will \u00a7ereset \u00a77both your\n\u00a77Shadow Step and Order of Eviscerate's cooldown\n\u00a77and refund the energy cost. Assisting in killing your\n\u00a77mark will only refund half the cooldown.";
    }

    @Override
    public List<Pair<String, String>> getAbilityInfo() {
        ArrayList<Pair<String, String>> info = new ArrayList<Pair<String, String>>();
        info.add(new Pair<String, String>("Times Used", "" + this.timesUsed));
        info.add(new Pair<String, String>("Number of Full Resets", "" + this.numberOfFullResets));
        info.add(new Pair<String, String>("Number of Half Resets", "" + this.numberOfHalfResets));
        info.add(new Pair<String, String>("Number of Backstabs", "" + this.numberOfBackstabs));
        return info;
    }

    @Override
    public boolean onActivate(final @Nonnull WarlordsPlayer wp, @Nonnull Player player) {
        wp.subtractEnergy(this.energyCost);
        Utils.playGlobalSound(player.getLocation(), Sound.GHAST_FIREBALL, 1.5f, 0.7f);
        Runnable cancelSpeed = wp.getSpeed().addSpeedModifier("Order of Eviscerate", 40, this.duration * 20, "BASE");
        wp.getCooldownManager().removeCooldown(OrderOfEviscerate.class);
        wp.getCooldownManager().addCooldown(new RegularCooldown<OrderOfEviscerate>("Order of Eviscerate", "ORDER", OrderOfEviscerate.class, new OrderOfEviscerate(), wp, CooldownTypes.ABILITY, cooldownManager -> {
            cancelSpeed.run();
            OrderOfEviscerate.removeCloak(wp, true);
        }, this.duration * 20, new TriConsumer[]{(cooldown, ticksLeft, counter) -> {
            Utils.playGlobalSound(wp.getLocation(), Sound.AMBIENCE_CAVE, 0.4f, 2.0f);
            ParticleEffect.SMOKE_NORMAL.display(0.0f, 0.2f, 0.0f, 0.05f, 4, wp.getLocation(), 500.0);
            if (counter % 10 == 0) {
                ParticleEffect.FOOTSTEP.display(0.0f, 0.0f, 0.0f, 1.0f, 1, wp.getLocation().add(0.0, 0.1, 0.0), 500.0);
            }
        }}){

            @Override
            public void doBeforeReductionFromAttacker(WarlordsDamageHealingEvent event) {
                WarlordsPlayer victim = event.getPlayer();
                if (victim != wp) {
                    if (!Objects.equals(((OrderOfEviscerate)this.getCooldownObject()).getMarkedPlayer(), victim)) {
                        wp.sendMessage(WarlordsPlayer.GIVE_ARROW_GREEN + ChatColor.GRAY + " You have marked \u00a7e" + victim.getName());
                    }
                    ((OrderOfEviscerate)this.getCooldownObject()).setMarkedPlayer(victim);
                }
            }

            @Override
            public float modifyDamageBeforeInterveneFromAttacker(WarlordsDamageHealingEvent event, float currentDamageValue) {
                if (Objects.equals(((OrderOfEviscerate)this.getCooldownObject()).getMarkedPlayer(), event.getPlayer()) && !Utils.isLineOfSightAssassin(event.getPlayer().getEntity(), event.getAttacker().getEntity())) {
                    ++OrderOfEviscerate.this.numberOfBackstabs;
                    return currentDamageValue * 1.3f;
                }
                return currentDamageValue * 1.2f;
            }

            @Override
            public void onDamageFromSelf(WarlordsDamageHealingEvent event, float currentDamageValue, boolean isCrit) {
                OrderOfEviscerate orderOfEviscerate = (OrderOfEviscerate)this.getCooldownObject();
                orderOfEviscerate.addAndCheckDamageThreshold(currentDamageValue, wp);
            }

            @Override
            public void onDeathFromEnemies(WarlordsDamageHealingEvent event, float currentDamageValue, boolean isCrit, boolean isKiller) {
                if (!Objects.equals(event.getPlayer(), ((OrderOfEviscerate)this.getCooldownObject()).getMarkedPlayer())) {
                    return;
                }
                this.setTicksLeft(0);
                if (isKiller) {
                    ++OrderOfEviscerate.this.numberOfFullResets;
                    new GameRunnable(wp.getGame()){

                        @Override
                        public void run() {
                            wp.sendMessage(WarlordsPlayer.GIVE_ARROW_GREEN + ChatColor.GRAY + " You killed your mark," + ChatColor.YELLOW + " your cooldowns have been reset" + ChatColor.GRAY + "!");
                            wp.getSpec().getPurple().setCurrentCooldown(0.0f);
                            wp.getSpec().getOrange().setCurrentCooldown(0.0f);
                            wp.updatePurpleItem();
                            wp.updateOrangeItem();
                            wp.addEnergy(wp, name, OrderOfEviscerate.this.energyCost);
                        }
                    }.runTaskLater(2L);
                } else {
                    ++OrderOfEviscerate.this.numberOfHalfResets;
                    new GameRunnable(wp.getGame()){

                        @Override
                        public void run() {
                            wp.sendMessage(WarlordsPlayer.GIVE_ARROW_GREEN + ChatColor.GRAY + " You assisted in killing your mark," + ChatColor.YELLOW + " your cooldowns have been reduced by half" + ChatColor.GRAY + "!");
                            wp.getSpec().getPurple().setCurrentCooldown(wp.getSpec().getPurple().getCurrentCooldown() / 2.0f);
                            wp.getSpec().getOrange().setCurrentCooldown(wp.getSpec().getOrange().getCurrentCooldown() / 2.0f);
                            wp.updatePurpleItem();
                            wp.updateOrangeItem();
                            wp.addEnergy(wp, name, (float)OrderOfEviscerate.this.energyCost / 2.0f);
                        }
                    }.runTaskLater(2L);
                }
                wp.playSound(wp.getLocation(), Sound.AMBIENCE_THUNDER, 1.0f, 2.0f);
            }
        });
        if (!FlagHolder.isPlayerHolderFlag(wp)) {
            wp.getCooldownManager().removeCooldownByName("Cloaked");
            wp.getCooldownManager().addRegularCooldown("Cloaked", "INVIS", OrderOfEviscerate.class, null, wp, CooldownTypes.BUFF, cooldownManager -> {
                wp.getEntity().removePotionEffect(PotionEffectType.INVISIBILITY);
                LivingEntity wpEntity = wp.getEntity();
                if (wpEntity instanceof Player) {
                    PlayerFilter.playingGame(wp.getGame()).enemiesOf(wp).stream().map(WarlordsPlayer::getEntity).filter(Player.class::isInstance).map(Player.class::cast).forEach(enemyPlayer -> enemyPlayer.showPlayer((Player)wpEntity));
                }
            }, this.duration * 20, (cooldown, ticksLeft, counter) -> {
                if (counter % 5 == 0) {
                    wp.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, ticksLeft.intValue(), 0, true, false));
                    LivingEntity wpEntity = wp.getEntity();
                    if (wpEntity instanceof Player) {
                        ((Player)wpEntity).getInventory().setArmorContents(new ItemStack[]{null, null, null, null});
                        PlayerFilter.playingGame(wp.getGame()).enemiesOf(wp).stream().map(WarlordsPlayer::getEntity).filter(Player.class::isInstance).map(Player.class::cast).forEach(enemyPlayer -> enemyPlayer.hidePlayer((Player)wpEntity));
                    }
                }
            });
        }
        return true;
    }

    public void addAndCheckDamageThreshold(float damageValue, WarlordsPlayer warlordsPlayer) {
        this.addToDamageThreshold(damageValue);
        if (this.getDamageThreshold() >= 600.0f) {
            OrderOfEviscerate.removeCloak(warlordsPlayer, false);
        }
    }

    public static void removeCloak(WarlordsPlayer warlordsPlayer, boolean forceRemove) {
        if (warlordsPlayer.getCooldownManager().hasCooldownFromName("Cloaked") || forceRemove) {
            warlordsPlayer.getCooldownManager().removeCooldownByName("Cloaked");
            warlordsPlayer.getEntity().removePotionEffect(PotionEffectType.INVISIBILITY);
            warlordsPlayer.updateArmor();
        }
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public WarlordsPlayer getMarkedPlayer() {
        return this.markedPlayer;
    }

    public void setMarkedPlayer(WarlordsPlayer markedPlayer) {
        this.markedPlayer = markedPlayer;
    }

    public float getDamageThreshold() {
        return this.damageThreshold;
    }

    public void addToDamageThreshold(float damageThreshold) {
        this.damageThreshold += damageThreshold;
    }
}

