/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.abilties;

import com.ebicep.warlords.abilties.internal.AbstractAbility;
import com.ebicep.warlords.effects.ParticleEffect;
import com.ebicep.warlords.events.WarlordsDamageHealingEvent;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.player.cooldowns.CooldownFilter;
import com.ebicep.warlords.player.cooldowns.CooldownTypes;
import com.ebicep.warlords.player.cooldowns.cooldowns.PersistentCooldown;
import com.ebicep.warlords.util.bukkit.LocationBuilder;
import com.ebicep.warlords.util.java.Pair;
import com.ebicep.warlords.util.warlords.GameRunnable;
import com.ebicep.warlords.util.warlords.PlayerFilter;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.server.v1_8_R3.EntityExperienceOrb;
import net.minecraft.server.v1_8_R3.EntityHuman;
import net.minecraft.server.v1_8_R3.Packet;
import net.minecraft.server.v1_8_R3.PacketPlayOutEntityDestroy;
import net.minecraft.server.v1_8_R3.World;
import net.minecraft.server.v1_8_R3.WorldServer;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.craftbukkit.v1_8_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftPlayer;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class OrbsOfLife
extends AbstractAbility {
    protected int orbsProduced = 0;
    public static final double SPAWN_RADIUS = 1.15;
    public static float ORB_HEALING = 225.0f;
    private final List<Orb> spawnedOrbs = new ArrayList<Orb>();
    private final int duration = 14;
    private final int floatingOrbRadius = 20;

    public OrbsOfLife() {
        super("Orbs of Life", ORB_HEALING, ORB_HEALING, 19.57f, 20, 0, 0);
    }

    @Override
    public void updateDescription(Player player) {
        this.description = "\u00a77Spawn \u00a7e2 \u00a77initial orbs on cast.\n\n\u00a77Striking and hitting enemies with abilities\n\u00a77causes them to drop an orb of life that lasts \u00a768\n\u00a77\u00a77seconds, restoring \u00a7a" + this.format(this.maxDamageHeal) + " \u00a77health to the ally that\n\u00a77picks it up. Other nearby allies recover \u00a7a" + this.format(this.minDamageHeal) + "\n\u00a77health. After 1.5 seconds the healing will increase\n\u00a77by \u00a7a40% \u00a77over 6.5 seconds. Lasts \u00a76" + 14 + " \u00a77seconds.\n\n\u00a77You may SNEAK to make the orbs levitate\n\u00a77towards you or the nearest ally in\n\u00a77a \u00a7e" + 20 + " \u00a77block radius.";
    }

    @Override
    public List<Pair<String, String>> getAbilityInfo() {
        ArrayList<Pair<String, String>> info = new ArrayList<Pair<String, String>>();
        info.add(new Pair<String, String>("Times Used", "" + this.timesUsed));
        info.add(new Pair<String, String>("Orbs Produced", "" + this.orbsProduced));
        return info;
    }

    @Override
    public boolean onActivate(final WarlordsPlayer wp, Player player) {
        wp.subtractEnergy(this.energyCost);
        Utils.playGlobalSound(player.getLocation(), "warrior.revenant.orbsoflife", 2.0f, 1.0f);
        final OrbsOfLife tempOrbsOfLight = new OrbsOfLife();
        PersistentCooldown<OrbsOfLife> orbsOfLifeCooldown = new PersistentCooldown<OrbsOfLife>(this.name, "ORBS", OrbsOfLife.class, tempOrbsOfLight, wp, CooldownTypes.ABILITY, cooldownManager -> {}, 280, orbsOfLife -> orbsOfLife.getSpawnedOrbs().isEmpty()){

            @Override
            public void onInterveneFromAttacker(WarlordsDamageHealingEvent event, float currentDamageValue) {
                OrbsOfLife.this.spawnOrbs(wp, event.getPlayer(), event.getAbility(), this);
                if (event.getAbility().equals("Crippling Strike")) {
                    OrbsOfLife.this.spawnOrbs(wp, event.getPlayer(), event.getAbility(), this);
                }
            }

            @Override
            public void onShieldFromAttacker(WarlordsDamageHealingEvent event, float currentDamageValue, boolean isCrit) {
                OrbsOfLife.this.spawnOrbs(wp, event.getPlayer(), event.getAbility(), this);
                if (event.getAbility().equals("Crippling Strike")) {
                    OrbsOfLife.this.spawnOrbs(wp, event.getPlayer(), event.getAbility(), this);
                }
            }

            @Override
            public void onDamageFromAttacker(WarlordsDamageHealingEvent event, float currentDamageValue, boolean isCrit) {
                OrbsOfLife.this.spawnOrbs(wp, event.getPlayer(), event.getAbility(), this);
                if (event.getAbility().equals("Crippling Strike")) {
                    OrbsOfLife.this.spawnOrbs(wp, event.getPlayer(), event.getAbility(), this);
                }
            }
        };
        wp.getCooldownManager().addCooldown(orbsOfLifeCooldown);
        tempOrbsOfLight.getSpawnedOrbs().add(new Orb((World)((CraftWorld)player.getLocation().getWorld()).getHandle(), this.generateSpawnLocation(player.getLocation()), wp));
        tempOrbsOfLight.getSpawnedOrbs().add(new Orb((World)((CraftWorld)player.getLocation().getWorld()).getHandle(), this.generateSpawnLocation(player.getLocation()), wp));
        this.addSecondaryAbility(() -> {
            if (wp.isAlive()) {
                Utils.playGlobalSound(wp.getLocation(), Sound.LEVEL_UP, 0.08f, 0.7f);
                ParticleEffect.ENCHANTMENT_TABLE.display(0.8f, 0.0f, 0.8f, 0.2f, 10, wp.getLocation().add(0.0, 1.5, 0.0), 500.0);
                tempOrbsOfLight.getSpawnedOrbs().forEach(orb -> orb.setPlayerToMoveTowards(PlayerFilter.entitiesAround(((Orb)orb).armorStand.getLocation(), 20.0, 20.0, 20.0).aliveTeammatesOf(wp).closestFirst(orb.getArmorStand().getLocation()).findFirstOrNull()));
                new GameRunnable(wp.getGame()){

                    @Override
                    public void run() {
                        tempOrbsOfLight.getSpawnedOrbs().stream().filter(orb -> orb.getPlayerToMoveTowards() != null).forEach(targetOrb -> {
                            WarlordsPlayer target = targetOrb.getPlayerToMoveTowards();
                            ArmorStand orbArmorStand = targetOrb.getArmorStand();
                            Location orbLocation = orbArmorStand.getLocation();
                            Entity orb = orbArmorStand.getPassenger();
                            orbArmorStand.eject();
                            orbArmorStand.teleport(new LocationBuilder(orbLocation.clone()).add(target.getLocation().toVector().subtract(orbLocation.toVector()).normalize().multiply(1)).get());
                            orbArmorStand.setPassenger(orb);
                            ParticleEffect.VILLAGER_HAPPY.display(0.0f, 0.0f, 0.0f, 0.0f, 1, orbArmorStand.getLocation().add(0.0, 1.65, 0.0), 500.0);
                        });
                        if (tempOrbsOfLight.getSpawnedOrbs().stream().noneMatch(orb -> orb.getPlayerToMoveTowards() != null)) {
                            this.cancel();
                        }
                    }
                }.runTaskTimer(0L, 1L);
                wp.sendMessage(WarlordsPlayer.GIVE_ARROW_GREEN + ChatColor.GRAY + " Your current " + ChatColor.GREEN + this.name + ChatColor.GRAY + " will now levitate towards you or a teammate!");
            }
        }, true, secondaryAbility -> wp.isDead() || !wp.getCooldownManager().hasCooldown(orbsOfLifeCooldown) || orbsOfLifeCooldown.isHidden());
        return true;
    }

    public void add2OrbsProduced() {
        this.orbsProduced += 2;
    }

    public void spawnOrbs(WarlordsPlayer owner, WarlordsPlayer victim, String ability, PersistentCooldown<OrbsOfLife> cooldown) {
        if (ability.isEmpty() || ability.equals("Intervene")) {
            return;
        }
        if (cooldown.isHidden()) {
            return;
        }
        owner.doOnStaticAbility(OrbsOfLife.class, OrbsOfLife::add2OrbsProduced);
        OrbsOfLife orbsOfLife = (OrbsOfLife)cooldown.getCooldownObject();
        Location location = victim.getLocation();
        Location spawnLocation = orbsOfLife.generateSpawnLocation(location);
        Orb orb = new Orb((World)((CraftWorld)location.getWorld()).getHandle(), spawnLocation, cooldown.getFrom());
        orbsOfLife.getSpawnedOrbs().add(orb);
    }

    public Location generateSpawnLocation(Location location) {
        Location spawnLocation;
        int counter = 0;
        Random rand = new Random();
        do {
            double angle = rand.nextDouble() * 360.0;
            double x = 1.15 * Math.cos(angle) + (rand.nextDouble() - 0.5);
            double z = 1.15 * Math.sin(angle) + (rand.nextDouble() - 0.5);
            spawnLocation = location.clone().add(x, 0.0, z);
        } while (++counter < 50 && (this.orbsInsideBlock(spawnLocation) || this.nearLocation(spawnLocation)));
        return spawnLocation;
    }

    public boolean orbsInsideBlock(Location location) {
        return location.getBlock().getType() != Material.AIR;
    }

    public boolean nearLocation(Location location) {
        for (Orb orb : this.spawnedOrbs) {
            double distance = orb.getArmorStand().getLocation().distanceSquared(location);
            if (!(distance < 1.0)) continue;
            return true;
        }
        return false;
    }

    public List<Orb> getSpawnedOrbs() {
        return this.spawnedOrbs;
    }

    public static class Orb
    extends EntityExperienceOrb {
        private final ArmorStand armorStand;
        private final WarlordsPlayer owner;
        private int ticksLived = 0;
        private WarlordsPlayer playerToMoveTowards = null;

        public Orb(World world, Location location, WarlordsPlayer owner) {
            super(world, location.getX(), location.getY() + 2.0, location.getZ(), 2500);
            this.owner = owner;
            ArmorStand orbStand = (ArmorStand)location.getWorld().spawnEntity(location.clone().add(0.0, 1.5, 0.0), EntityType.ARMOR_STAND);
            orbStand.setVisible(false);
            orbStand.setGravity(true);
            orbStand.setPassenger((Entity)this.spawn(location).getBukkitEntity());
            for (WarlordsPlayer player : PlayerFilter.playingGame(owner.getGame()).enemiesOf(owner)) {
                if (!(player.getEntity() instanceof Player)) continue;
                ((CraftPlayer)player.getEntity()).getHandle().playerConnection.sendPacket((Packet)new PacketPlayOutEntityDestroy(new int[]{this.getId()}));
            }
            this.armorStand = orbStand;
            new GameRunnable(owner.getGame()){

                @Override
                public void run() {
                    if (!armorStand.isValid()) {
                        this.cancel();
                    } else {
                        ticksLived++;
                    }
                }
            }.runTaskTimer(30L, 0L);
        }

        public String toString() {
            return "Orb{owner=" + this.owner + ", ticksLived=" + this.ticksLived + ", playerToMoveTowards=" + this.playerToMoveTowards + '}';
        }

        public void d(EntityHuman entityHuman) {
        }

        public Orb spawn(Location loc) {
            WorldServer w = ((CraftWorld)loc.getWorld()).getHandle();
            this.setPosition(loc.getX(), loc.getY(), loc.getZ());
            w.addEntity((net.minecraft.server.v1_8_R3.Entity)this, CreatureSpawnEvent.SpawnReason.CUSTOM);
            return this;
        }

        public void remove() {
            this.armorStand.remove();
            this.getBukkitEntity().remove();
            new CooldownFilter<PersistentCooldown>(this.owner, PersistentCooldown.class).filterCooldownClassAndMapToObjectsOfClass(OrbsOfLife.class).forEachOrdered(orbsOfLife -> orbsOfLife.getSpawnedOrbs().remove((Object)this));
        }

        public ArmorStand getArmorStand() {
            return this.armorStand;
        }

        public WarlordsPlayer getOwner() {
            return this.owner;
        }

        public int getTicksLived() {
            return this.ticksLived;
        }

        public WarlordsPlayer getPlayerToMoveTowards() {
            return this.playerToMoveTowards;
        }

        public void setPlayerToMoveTowards(WarlordsPlayer playerToMoveTowards) {
            this.playerToMoveTowards = playerToMoveTowards;
        }
    }
}

