/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.abilties;

import com.ebicep.warlords.abilties.CapacitorTotem;
import com.ebicep.warlords.abilties.internal.AbstractAbility;
import com.ebicep.warlords.abilties.internal.AbstractTotemBase;
import com.ebicep.warlords.effects.FallingBlockWaveEffect;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.util.java.Pair;
import com.ebicep.warlords.util.warlords.PlayerFilter;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class LightningRod
extends AbstractAbility {
    private final int energyRestore = 160;
    private final int knockbackRadius = 5;

    public LightningRod() {
        super("Lightning Rod", 0.0f, 0.0f, 31.32f, 0, -1, 0);
    }

    @Override
    public void updateDescription(Player player) {
        this.description = "\u00a77Call down an energizing bolt of lightning\n\u00a77upon yourself, restoring \u00a7a30% \u00a77health and\n\u00a7e160 \u00a77energy and knock all nearby enemies\n\u00a77in a \u00a7e5 \u00a77block radius back.";
    }

    @Override
    public List<Pair<String, String>> getAbilityInfo() {
        ArrayList<Pair<String, String>> info = new ArrayList<Pair<String, String>>();
        info.add(new Pair<String, String>("Times Used", "" + this.timesUsed));
        return info;
    }

    @Override
    public boolean onActivate(WarlordsPlayer wp, Player player) {
        wp.addEnergy(wp, this.name, 160.0f);
        Utils.playGlobalSound(player.getLocation(), "shaman.lightningrod.activation", 2.0f, 1.0f);
        new FallingBlockWaveEffect(wp.getLocation(), 5.0, 1.0, Material.RED_ROSE, 5).play();
        player.getWorld().spigot().strikeLightningEffect(wp.getLocation(), true);
        wp.addHealingInstance(wp, this.name, (float)wp.getMaxHealth() * 0.3f, (float)wp.getMaxHealth() * 0.3f, this.critChance, this.critMultiplier, false, false);
        for (WarlordsPlayer knockbackTarget : PlayerFilter.entitiesAround((Entity)player, 5.0, 5.0, 5.0).aliveEnemiesOf(wp)) {
            Location loc = knockbackTarget.getLocation();
            Vector v = player.getLocation().toVector().subtract(loc.toVector()).normalize().multiply(-1.5).setY(0.35);
            knockbackTarget.setVelocity(v, false);
        }
        List<CapacitorTotem> totemDownAndClose = AbstractTotemBase.getTotemsDownAndClose(wp, (Entity)wp.getEntity(), CapacitorTotem.class);
        totemDownAndClose.forEach(capacitorTotem -> {
            ArmorStand totem = capacitorTotem.getTotem();
            Utils.playGlobalSound(totem.getLocation(), "shaman.capacitortotem.pulse", 2.0f, 1.0f);
            player.playSound(player.getLocation(), "shaman.chainlightning.impact", 2.0f, 1.0f);
            capacitorTotem.pulseDamage();
            capacitorTotem.addProc();
        });
        return true;
    }
}

