/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.abilties;

import com.ebicep.warlords.abilties.internal.AbstractPiercingProjectileBase;
import com.ebicep.warlords.effects.ParticleEffect;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.util.bukkit.LocationBuilder;
import com.ebicep.warlords.util.java.Pair;
import com.ebicep.warlords.util.warlords.PlayerFilter;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.EulerAngle;

public class LightningBolt
extends AbstractPiercingProjectileBase {
    public LightningBolt() {
        super("Lightning Bolt", 228.0f, 385.0f, 0.0f, 60, 20, 200, 2.5, 60.0, false);
    }

    @Override
    public void updateDescription(Player player) {
        this.description = "\u00a77Hurl a fast, piercing bolt of lightning that\n\u00a77deals \u00a7c" + this.format(this.minDamageHeal) + " \u00a77- \u00a7c" + this.format(this.maxDamageHeal) + " \u00a77damage to all enemies it\n\u00a77passes through. Each target hit reduces the\n\u00a77cooldown of Chain Lightning by \u00a762 \u00a77seconds.\n\n\u00a77Has a maximum range of \u00a7e60 \u00a77blocks.";
    }

    @Override
    public List<Pair<String, String>> getAbilityInfo() {
        ArrayList<Pair<String, String>> info = new ArrayList<Pair<String, String>>();
        info.add(new Pair<String, String>("Shots Fired", "" + this.timesUsed));
        info.add(new Pair<String, String>("Players Hit", "" + this.playersHit));
        info.add(new Pair<String, String>("Dismounts", "" + this.numberOfDismounts));
        return info;
    }

    @Override
    protected String getActivationSound() {
        return "shaman.lightningbolt.activation";
    }

    @Override
    protected float getSoundPitch() {
        return 1.0f;
    }

    @Override
    protected float getSoundVolume() {
        return 2.0f;
    }

    @Override
    protected boolean shouldEndProjectileOnHit(AbstractPiercingProjectileBase.InternalProjectile projectile, Block block) {
        return true;
    }

    @Override
    protected boolean shouldEndProjectileOnHit(AbstractPiercingProjectileBase.InternalProjectile projectile, WarlordsPlayer wp) {
        return false;
    }

    @Override
    protected void onNonCancellingHit(AbstractPiercingProjectileBase.InternalProjectile projectile, WarlordsPlayer hit, Location impactLocation) {
        WarlordsPlayer wp = projectile.getShooter();
        if (!projectile.getHit().contains(hit)) {
            projectile.getHit().add(hit);
            ++this.playersHit;
            if (hit.onHorse()) {
                ++this.numberOfDismounts;
            }
            Utils.playGlobalSound(impactLocation, "shaman.lightningbolt.impact", 2.0f, 1.0f);
            hit.addDamageInstance(wp, this.name, this.minDamageHeal, this.maxDamageHeal, this.critChance, this.critMultiplier, false);
            wp.getSpec().getRed().subtractCooldown(2.0f);
            if (wp.getEntity() instanceof Player) {
                wp.updateRedItem((Player)wp.getEntity());
            }
        }
    }

    @Override
    protected int onHit(AbstractPiercingProjectileBase.InternalProjectile projectile, WarlordsPlayer hit) {
        WarlordsPlayer wp = projectile.getShooter();
        Location currentLocation = projectile.getCurrentLocation();
        Utils.playGlobalSound(currentLocation, "shaman.lightningbolt.impact", 2.0f, 1.0f);
        ParticleEffect.EXPLOSION_LARGE.display(0.0f, 0.0f, 0.0f, 0.0f, 1, currentLocation, 500.0);
        int playersHit = 0;
        for (WarlordsPlayer enemy : PlayerFilter.entitiesAround(currentLocation, 3.0, 3.0, 3.0).aliveEnemiesOf(wp).excluding(projectile.getHit())) {
            ++playersHit;
            if (enemy.onHorse()) {
                ++this.numberOfDismounts;
            }
            Utils.playGlobalSound(enemy.getLocation(), "shaman.lightningbolt.impact", 2.0f, 1.0f);
            enemy.addDamageInstance(wp, this.name, this.minDamageHeal, this.maxDamageHeal, this.critChance, this.critMultiplier, false);
            wp.getSpec().getRed().subtractCooldown(2.0f);
            if (!(wp.getEntity() instanceof Player)) continue;
            wp.updateRedItem((Player)wp.getEntity());
        }
        return playersHit;
    }

    @Override
    protected Location getProjectileStartingLocation(WarlordsPlayer shooter, Location startingLocation) {
        return new LocationBuilder(startingLocation.clone()).addY(-0.1).get();
    }

    @Override
    protected void onSpawn(AbstractPiercingProjectileBase.InternalProjectile projectile) {
        super.onSpawn(projectile);
        final ArmorStand armorStand = (ArmorStand)projectile.getWorld().spawn(projectile.getStartingLocation().clone().add(0.0, -1.7, 0.0), ArmorStand.class);
        armorStand.setGravity(false);
        armorStand.setVisible(false);
        armorStand.setMarker(true);
        armorStand.setHelmet(new ItemStack(Material.SAPLING, 1, 3));
        armorStand.setHeadPose(new EulerAngle(-Math.atan2(projectile.getSpeed().getY(), Math.sqrt(Math.pow(projectile.getSpeed().getX(), 2.0) + Math.pow(projectile.getSpeed().getZ(), 2.0))), 0.0, 0.0));
        projectile.addTask(new AbstractPiercingProjectileBase.InternalProjectileTask(){

            @Override
            public void run(AbstractPiercingProjectileBase.InternalProjectile projectile) {
                armorStand.teleport(projectile.getCurrentLocation().clone().add(0.0, -1.7, 0.0), PlayerTeleportEvent.TeleportCause.PLUGIN);
            }

            @Override
            public void onDestroy(AbstractPiercingProjectileBase.InternalProjectile projectile) {
                armorStand.remove();
            }
        });
    }

    @Override
    protected void playEffect(AbstractPiercingProjectileBase.InternalProjectile projectile) {
        super.playEffect(projectile);
    }

    @Override
    @Deprecated
    protected void playEffect(Location currentLocation, int ticksLived) {
    }
}

