/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.abilties;

import com.ebicep.warlords.abilties.internal.AbstractAbility;
import com.ebicep.warlords.effects.ParticleEffect;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.player.cooldowns.CooldownTypes;
import com.ebicep.warlords.util.java.Pair;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;

public class LightInfusion
extends AbstractAbility {
    private int duration = 3;
    private final int speedBuff = 40;

    public LightInfusion(float cooldown) {
        super("Light Infusion", 0.0f, 0.0f, cooldown, 0, 0, 0);
    }

    @Override
    public void updateDescription(Player player) {
        this.description = "\u00a77You become infused with light,\n\u00a77restoring \u00a7a120 \u00a77energy and\n\u00a77increasing your movement speed by\n\u00a7e40% \u00a77for \u00a76" + this.duration + " \u00a77seconds";
    }

    @Override
    public List<Pair<String, String>> getAbilityInfo() {
        ArrayList<Pair<String, String>> info = new ArrayList<Pair<String, String>>();
        info.add(new Pair<String, String>("Times Used", "" + this.timesUsed));
        return info;
    }

    @Override
    public boolean onActivate(WarlordsPlayer wp, Player player) {
        wp.addEnergy(wp, this.name, 120.0f);
        Utils.playGlobalSound(player.getLocation(), "paladin.infusionoflight.activation", 2.0f, 1.0f);
        Runnable cancelSpeed = wp.getSpeed().addSpeedModifier("Infusion", 40, this.duration * 20, "BASE");
        LightInfusion tempLightInfusion = new LightInfusion(this.cooldown);
        wp.getCooldownManager().addRegularCooldown(this.name, "INF", LightInfusion.class, tempLightInfusion, wp, CooldownTypes.ABILITY, cooldownManager -> cancelSpeed.run(), this.duration * 20, (cooldown, ticksLeft, counter) -> {
            if (counter % 4 == 0) {
                ParticleEffect.SPELL.display(0.3f, 0.1f, 0.3f, 0.2f, 2, wp.getLocation().add(0.0, 1.2, 0.0), 500.0);
            }
        });
        for (int i = 0; i < 10; ++i) {
            ParticleEffect.SPELL.display(1.0f, 0.0f, 1.0f, 0.3f, 3, wp.getLocation().add(0.0, 1.5, 0.0), 500.0);
        }
        return true;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }
}

