/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.abilties;

import com.ebicep.warlords.abilties.internal.AbstractAbility;
import com.ebicep.warlords.effects.EffectUtils;
import com.ebicep.warlords.effects.ParticleEffect;
import com.ebicep.warlords.events.WarlordsDamageHealingEvent;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.player.cooldowns.CooldownTypes;
import com.ebicep.warlords.player.cooldowns.cooldowns.RegularCooldown;
import com.ebicep.warlords.util.bukkit.Matrix4d;
import com.ebicep.warlords.util.java.Pair;
import com.ebicep.warlords.util.warlords.PlayerFilter;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class LastStand
extends AbstractAbility {
    protected int playersLastStanded = 0;
    private final int selfDuration = 12;
    private final int allyDuration = 6;
    private final int radius = 7;
    private int selfDamageReductionPercent = 50;
    private int teammateDamageReductionPercent = 40;

    public LastStand() {
        super("Last Stand", 0.0f, 0.0f, 56.38f, 40, 0, 0);
    }

    public LastStand(int selfDamageReductionPercent, int teammateDamageReductionPercent) {
        super("Last Stand", 0.0f, 0.0f, 56.38f, 40, 0, 0);
        this.selfDamageReductionPercent = selfDamageReductionPercent;
        this.teammateDamageReductionPercent = teammateDamageReductionPercent;
    }

    @Override
    public void updateDescription(Player player) {
        this.description = "\u00a77Enter a defensive stance,\n\u00a77reducing all damage you take by\n\u00a7c" + this.selfDamageReductionPercent + "% \u00a77for \u00a76" + 12 + " \u00a77seconds and also\n\u00a77reduces all damage nearby allies take\n\u00a77by \u00a7c" + this.teammateDamageReductionPercent + "% \u00a77for \u00a76" + 6 + " \u00a77seconds. You are\n\u00a77healed \u00a77for the amount of damage\n\u00a77prevented on allies.\n\n\u00a77Has a maximum range of \u00a7e" + 7 + " \u00a77blocks.";
    }

    @Override
    public List<Pair<String, String>> getAbilityInfo() {
        ArrayList<Pair<String, String>> info = new ArrayList<Pair<String, String>>();
        info.add(new Pair<String, String>("Times Used", "" + this.timesUsed));
        info.add(new Pair<String, String>("Players Last Standed", "" + this.playersLastStanded));
        return info;
    }

    @Override
    public boolean onActivate(final WarlordsPlayer wp, Player player) {
        wp.subtractEnergy(this.energyCost);
        Utils.playGlobalSound(player.getLocation(), "warrior.laststand.activation", 2.0f, 1.0f);
        LastStand tempLastStand = new LastStand(this.selfDamageReductionPercent, this.teammateDamageReductionPercent);
        wp.getCooldownManager().addCooldown(new RegularCooldown<LastStand>(this.name, "LAST", LastStand.class, tempLastStand, wp, CooldownTypes.ABILITY, cooldownManager -> {}, 240){

            @Override
            public float modifyDamageAfterInterveneFromSelf(WarlordsDamageHealingEvent event, float currentDamageValue) {
                return currentDamageValue * LastStand.this.getSelfDamageReduction();
            }
        });
        for (WarlordsPlayer standTarget : PlayerFilter.entitiesAround(wp, 7.0, 7.0, 7.0).aliveTeammatesOfExcludingSelf(wp)) {
            ++this.playersLastStanded;
            EffectUtils.playParticleLinkAnimation(wp.getLocation(), standTarget.getLocation(), ParticleEffect.VILLAGER_HAPPY);
            standTarget.getCooldownManager().addCooldown(new RegularCooldown<LastStand>(this.name, "LAST", LastStand.class, tempLastStand, wp, CooldownTypes.ABILITY, cooldownManager -> {}, 120){

                @Override
                public float modifyDamageAfterInterveneFromSelf(WarlordsDamageHealingEvent event, float currentDamageValue) {
                    return currentDamageValue * LastStand.this.getTeammateDamageReduction();
                }

                @Override
                public void onShieldFromSelf(WarlordsDamageHealingEvent event, float currentDamageValue, boolean isCrit) {
                    wp.addAbsorbed(currentDamageValue);
                    wp.addHealingInstance(wp, this.name, currentDamageValue, currentDamageValue, isCrit ? 100 : -1, 100, false, true);
                }

                @Override
                public void onDamageFromSelf(WarlordsDamageHealingEvent event, float currentDamageValue, boolean isCrit) {
                    wp.addAbsorbed(currentDamageValue);
                    wp.addHealingInstance(wp, this.name, currentDamageValue, currentDamageValue, isCrit ? 100 : -1, 100, false, false);
                }
            });
            wp.sendMessage(WarlordsPlayer.GIVE_ARROW_GREEN + ChatColor.GRAY + " Your Last Stand is now protecting " + ChatColor.YELLOW + standTarget.getName() + ChatColor.GRAY + "!");
            standTarget.sendMessage(WarlordsPlayer.RECEIVE_ARROW_GREEN + ChatColor.GRAY + " " + wp.getName() + "'s " + ChatColor.YELLOW + "Last Stand" + ChatColor.GRAY + " is now protecting you for \u00a76" + 6 + " \u00a77seconds!");
        }
        Location loc = player.getEyeLocation();
        loc.setPitch(0.0f);
        loc.setYaw(0.0f);
        Matrix4d matrix = new Matrix4d();
        for (int i = 0; i < 3; ++i) {
            double distance;
            double width;
            double angle;
            int c;
            loc.setYaw(loc.getYaw() + 120.0f);
            matrix.updateFromLocation(loc);
            for (c = 0; c < 20; ++c) {
                angle = (double)c / 20.0 * Math.PI * 2.0;
                width = 1.2;
                distance = 3.0;
                ParticleEffect.FLAME.display(0.0f, 0.0f, 0.0f, 0.0f, 1, matrix.translateVector(player.getWorld(), distance, Math.sin(angle) * width, Math.cos(angle) * width), 500.0);
            }
            for (c = 0; c < 10; ++c) {
                angle = (double)c / 10.0 * Math.PI * 2.0;
                width = 0.6;
                distance = 3.0;
                ParticleEffect.REDSTONE.display(0.0f, 0.0f, 0.0f, 0.0f, 1, matrix.translateVector(player.getWorld(), distance, Math.sin(angle) * width, Math.cos(angle) * width), 500.0);
            }
        }
        return true;
    }

    public float getSelfDamageReduction() {
        return (float)(100 - this.selfDamageReductionPercent) / 100.0f;
    }

    public void setSelfDamageReductionPercent(int selfDamageReductionPercent) {
        this.selfDamageReductionPercent = selfDamageReductionPercent;
    }

    public float getTeammateDamageReduction() {
        return (float)(100 - this.selfDamageReductionPercent) / 100.0f;
    }

    public void setTeammateDamageReductionPercent(int teammateDamageReductionPercent) {
        this.teammateDamageReductionPercent = teammateDamageReductionPercent;
    }
}

