/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.abilties;

import com.ebicep.warlords.abilties.internal.AbstractStrikeBase;
import com.ebicep.warlords.events.WarlordsDamageHealingEvent;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.player.cooldowns.CooldownTypes;
import com.ebicep.warlords.player.cooldowns.cooldowns.DamageHealCompleteCooldown;
import com.ebicep.warlords.util.java.Pair;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.bukkit.entity.Player;

public class JudgementStrike
extends AbstractStrikeBase {
    int attacksDone = 0;

    public JudgementStrike() {
        super("Judgement Strike", 326.0f, 441.0f, 0.0f, 70, 20, 185);
    }

    @Override
    public void updateDescription(Player player) {
        this.description = "\u00a77Strike the targeted enemy, dealing \u00a7c" + this.format(this.minDamageHeal) + " \u00a77- \u00a7c" + this.format(this.maxDamageHeal) + " \u00a77damage.\n\u00a77Every fourth attack is a \u00a7cguaranteed \u00a77critical strike.\n\u00a77Critical strikes temporarily increase your movement\n\u00a77speed by \u00a7e25% \u00a77for \u00a7e2 \u00a77seconds.";
    }

    @Override
    public List<Pair<String, String>> getAbilityInfo() {
        ArrayList<Pair<String, String>> info = new ArrayList<Pair<String, String>>();
        info.add(new Pair<String, String>("Players Struck", "" + this.timesUsed));
        return info;
    }

    @Override
    protected void onHit(@Nonnull WarlordsPlayer wp, @Nonnull Player player, @Nonnull WarlordsPlayer nearPlayer) {
        ++this.attacksDone;
        int critChance = this.critChance;
        if (this.attacksDone == 4) {
            this.attacksDone = 0;
            critChance = 100;
        }
        wp.getCooldownManager().addCooldown(new DamageHealCompleteCooldown<JudgementStrike>("Judgment Strike", "", JudgementStrike.class, new JudgementStrike(), wp, CooldownTypes.ABILITY, cooldownManager -> {}){

            @Override
            public void onDamageFromAttacker(WarlordsDamageHealingEvent event, float currentDamageValue, boolean isCrit) {
                if (event.getAbility().equals("Judgement Strike") && isCrit) {
                    event.getAttacker().getSpeed().addSpeedModifier("Judgement Speed", 25, 40, "BASE");
                }
            }
        });
        nearPlayer.addDamageInstance(wp, this.name, this.minDamageHeal, this.maxDamageHeal, critChance, this.critMultiplier, false);
    }
}

