/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.abilties;

import com.ebicep.warlords.abilties.internal.AbstractAbility;
import com.ebicep.warlords.effects.EffectUtils;
import com.ebicep.warlords.effects.ParticleEffect;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.player.cooldowns.CooldownTypes;
import com.ebicep.warlords.player.cooldowns.cooldowns.RegularCooldown;
import com.ebicep.warlords.util.java.Pair;
import com.ebicep.warlords.util.warlords.PlayerFilter;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class Intervene
extends AbstractAbility {
    protected int playersIntervened = 0;
    protected int carriersIntervened = 0;
    private final int duration = 5;
    private float damagePrevented = 0.0f;
    private float maxDamagePrevented = 3600.0f;
    private int radius = 10;
    private int breakRadius = 15;
    private WarlordsPlayer caster;
    private WarlordsPlayer target;

    public Intervene() {
        super("Intervene", 0.0f, 0.0f, 14.09f, 20, 0, 0);
    }

    public Intervene(float maxDamagePrevented, WarlordsPlayer caster, WarlordsPlayer target) {
        super("Intervene", 0.0f, 0.0f, 14.09f, 20, 0, 0);
        this.maxDamagePrevented = maxDamagePrevented;
        this.caster = caster;
        this.target = target;
    }

    @Override
    public void updateDescription(Player player) {
        this.description = "\u00a77Protect the target ally, reducing\n\u00a77the damage they take by \u00a7e100%\n\u00a77and redirecting \u00a7e50% \u00a77of the damage\n\u00a77they would have taken back to you.\n\u00a77You can protect the target for a maximum\n\u00a77of \u00a7c" + this.format(this.maxDamagePrevented) + " \u00a77damage. You must remain within\n\u00a7e" + this.breakRadius + " \u00a77blocks of each other. Lasts \u00a76" + 5 + " \u00a77seconds.\n\n\u00a77Has an initial cast range of \u00a7e" + this.radius + " \u00a77blocks.";
    }

    @Override
    public List<Pair<String, String>> getAbilityInfo() {
        ArrayList<Pair<String, String>> info = new ArrayList<Pair<String, String>>();
        info.add(new Pair<String, String>("Times Used", "" + this.timesUsed));
        info.add(new Pair<String, String>("Players Intervened", "" + this.playersIntervened));
        info.add(new Pair<String, String>("Carriers Intervened", "" + this.carriersIntervened));
        return info;
    }

    @Override
    public boolean onActivate(@Nonnull WarlordsPlayer wp, @Nonnull Player player) {
        this.setDamagePrevented(0.0f);
        Iterator<WarlordsPlayer> iterator = PlayerFilter.entitiesAround(wp, (double)this.radius, (double)this.radius, (double)this.radius).aliveTeammatesOfExcludingSelf(wp).requireLineOfSightIntervene(wp).lookingAtFirst(wp).limit(1L).iterator();
        if (iterator.hasNext()) {
            WarlordsPlayer veneTarget = iterator.next();
            ++this.playersIntervened;
            if (veneTarget.hasFlag()) {
                ++this.carriersIntervened;
            }
            wp.subtractEnergy(this.energyCost);
            Utils.playGlobalSound(wp.getLocation(), "warrior.intervene.impact", 1.0f, 1.0f);
            EffectUtils.playParticleLinkAnimation(wp.getLocation(), veneTarget.getLocation(), ParticleEffect.VILLAGER_HAPPY);
            Intervene tempIntervene = new Intervene(this.maxDamagePrevented, wp, veneTarget);
            wp.getCooldownManager().getCooldowns().removeIf(cd2 -> cd2.getCooldownClass() == Intervene.class && veneTarget.getCooldownManager().hasCooldown(cd2.getCooldownObject()));
            veneTarget.getCooldownManager().getCooldowns().removeIf(cd2 -> {
                if (cd2.getCooldownClass() == Intervene.class) {
                    cd2.getFrom().sendMessage(WarlordsPlayer.RECEIVE_ARROW_RED + " " + ChatColor.GRAY + cd2.getFrom().getName() + "'s " + ChatColor.YELLOW + "Intervene " + ChatColor.GRAY + "has expired!");
                    veneTarget.sendMessage(WarlordsPlayer.RECEIVE_ARROW_RED + " " + ChatColor.GRAY + cd2.getFrom().getName() + "'s " + ChatColor.YELLOW + "Intervene " + ChatColor.GRAY + "has expired!");
                    return true;
                }
                return false;
            });
            wp.sendMessage(WarlordsPlayer.GIVE_ARROW_GREEN + "\u00a77 You are now protecting " + veneTarget.getName() + " with your \u00a7eIntervene!");
            veneTarget.sendMessage(WarlordsPlayer.GIVE_ARROW_GREEN + "\u00a77 " + wp.getName() + " is shielding you with their " + ChatColor.YELLOW + "Intervene" + ChatColor.GRAY + "!");
            RegularCooldown<Intervene> interveneCooldownVeneTarget = new RegularCooldown<Intervene>(this.name, "VENE", Intervene.class, tempIntervene, wp, CooldownTypes.ABILITY, cooldownManager -> veneTarget.sendMessage(WarlordsPlayer.RECEIVE_ARROW_RED + " " + ChatColor.GRAY + wp.getName() + "'s " + ChatColor.YELLOW + "Intervene " + ChatColor.GRAY + "has expired!"), 100, (cooldown, ticksLeft, counter) -> {
                if (counter % 20 == 0 && ticksLeft > 0) {
                    int timeLeft = Math.round((float)ticksLeft.intValue() / 20.0f);
                    if (timeLeft == 1) {
                        veneTarget.sendMessage(WarlordsPlayer.GIVE_ARROW_GREEN + " " + ChatColor.GRAY + wp.getName() + "'s \u00a7eIntervene \u00a77will expire in \u00a76" + timeLeft + "\u00a77 second!");
                    } else {
                        veneTarget.sendMessage(WarlordsPlayer.GIVE_ARROW_GREEN + " " + ChatColor.GRAY + wp.getName() + "'s \u00a7eIntervene \u00a77will expire in \u00a76" + timeLeft + "\u00a77 seconds!");
                    }
                }
            });
            RegularCooldown<Intervene> interveneCooldownWp = new RegularCooldown<Intervene>(this.name, "VENE", Intervene.class, tempIntervene, wp, CooldownTypes.ABILITY, cooldownManager -> wp.sendMessage(WarlordsPlayer.RECEIVE_ARROW_RED + " " + ChatColor.GRAY + wp.getName() + "'s " + ChatColor.YELLOW + "Intervene " + ChatColor.GRAY + "has expired!"), 100, (cooldown, ticksLeft, counter) -> {
                if (wp.isDead() || veneTarget.getLocation().distanceSquared(wp.getLocation()) > (double)(this.breakRadius * this.breakRadius)) {
                    cooldown.setTicksLeft(0);
                    interveneCooldownVeneTarget.setTicksLeft(0);
                }
            });
            wp.getCooldownManager().addCooldown(interveneCooldownWp);
            veneTarget.getCooldownManager().addCooldown(interveneCooldownVeneTarget);
            wp.getSpec().getBlue().setCurrentCooldown((float)((double)this.cooldown * wp.getCooldownModifier()));
            wp.updateBlueItem();
            return true;
        }
        return false;
    }

    public float getDamagePrevented() {
        return this.damagePrevented;
    }

    public void setDamagePrevented(float damagePrevented) {
        this.damagePrevented = damagePrevented;
    }

    public void addDamagePrevented(float amount) {
        this.damagePrevented += amount;
    }

    public int getBreakRadius() {
        return this.breakRadius;
    }

    public void setBreakRadius(int breakRadius) {
        this.breakRadius = breakRadius;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public float getMaxDamagePrevented() {
        return this.maxDamagePrevented;
    }

    public void setMaxDamagePrevented(float maxDamagePrevented) {
        this.maxDamagePrevented = maxDamagePrevented;
    }

    public WarlordsPlayer getCaster() {
        return this.caster;
    }

    public WarlordsPlayer getTarget() {
        return this.target;
    }
}

