/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.abilties;

import com.ebicep.warlords.abilties.internal.AbstractAbility;
import com.ebicep.warlords.effects.ParticleEffect;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.player.cooldowns.CooldownTypes;
import com.ebicep.warlords.util.java.Pair;
import com.ebicep.warlords.util.java.TriConsumer;
import com.ebicep.warlords.util.warlords.PlayerFilter;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class InspiringPresence
extends AbstractAbility {
    protected int playersHit = 0;
    private int duration = 12;
    private final int speedBuff = 30;
    private final int radius = 10;
    private List<WarlordsPlayer> playersEffected = new ArrayList<WarlordsPlayer>();

    public InspiringPresence() {
        super("Inspiring Presence", 0.0f, 0.0f, 70.47f, 0, 0, 0);
    }

    @Override
    public void updateDescription(Player player) {
        this.description = "\u00a77Your presence on the battlefield\n\u00a77inspires your allies, increasing\n\u00a77their energy regeneration by \u00a7e10\n\u00a77per second and their movement\n\u00a77by \u00a7e30% \u00a77for \u00a76" + this.duration + " \u00a77seconds.\n\n\u00a77Has a maximum range of \u00a7e" + 10 + " \u00a77blocks.";
    }

    @Override
    public List<Pair<String, String>> getAbilityInfo() {
        ArrayList<Pair<String, String>> info = new ArrayList<Pair<String, String>>();
        info.add(new Pair<String, String>("Times Used", "" + this.timesUsed));
        info.add(new Pair<String, String>("Players Hit", "" + this.playersHit));
        return info;
    }

    @Override
    public boolean onActivate(WarlordsPlayer wp, Player player) {
        Utils.playGlobalSound(player.getLocation(), "paladin.inspiringpresence.activation", 2.0f, 1.0f);
        Runnable cancelSpeed = wp.getSpeed().addSpeedModifier("Inspiring Presence", 30, this.duration * 20, "BASE");
        InspiringPresence tempPresence = new InspiringPresence();
        wp.getCooldownManager().addRegularCooldown(this.name, "PRES", InspiringPresence.class, tempPresence, wp, CooldownTypes.ABILITY, cooldownManager -> cancelSpeed.run(), this.duration * 20, (cooldown, ticksLeft, counter) -> {
            if (counter % 4 == 0) {
                Location location = wp.getLocation();
                location.add(0.0, 1.5, 0.0);
                ParticleEffect.SMOKE_NORMAL.display(0.3f, 0.3f, 0.3f, 0.02f, 1, location, 500.0);
                ParticleEffect.SPELL.display(0.3f, 0.3f, 0.3f, 0.5f, 2, location, 500.0);
            }
        });
        for (WarlordsPlayer presenceTarget : PlayerFilter.entitiesAround(wp, 10.0, 10.0, 10.0).aliveTeammatesOfExcludingSelf(wp)) {
            ++this.playersHit;
            tempPresence.getPlayersEffected().add(presenceTarget);
            wp.sendMessage(WarlordsPlayer.GIVE_ARROW_GREEN + ChatColor.GRAY + " Your Inspiring Presence inspired " + ChatColor.YELLOW + presenceTarget.getName() + ChatColor.GRAY + "!");
            Runnable cancelAllySpeed = presenceTarget.getSpeed().addSpeedModifier("Inspiring Presence", 30, this.duration * 20, "BASE");
            presenceTarget.getCooldownManager().addRegularCooldown(this.name, "PRES", InspiringPresence.class, tempPresence, wp, CooldownTypes.ABILITY, cooldownManager -> cancelAllySpeed.run(), this.duration * 20, new TriConsumer[0]);
        }
        return true;
    }

    public float getDuration() {
        return this.duration;
    }

    public void decrementDuration() {
        this.duration = (int)((double)this.duration - 0.05);
    }

    public List<WarlordsPlayer> getPlayersEffected() {
        return this.playersEffected;
    }
}

