/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.abilties;

import com.ebicep.warlords.abilties.internal.AbstractAbility;
import com.ebicep.warlords.effects.ParticleEffect;
import com.ebicep.warlords.events.WarlordsDamageHealingEvent;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.player.cooldowns.CooldownTypes;
import com.ebicep.warlords.player.cooldowns.cooldowns.RegularCooldown;
import com.ebicep.warlords.util.java.Pair;
import com.ebicep.warlords.util.java.TriConsumer;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class Inferno
extends AbstractAbility {
    protected int hitsAmplified = 0;
    private final int duration = 18;
    private int critChanceIncrease = 30;
    private int critMultiplierIncrease = 30;

    public Inferno() {
        super("Inferno", 0.0f, 0.0f, 46.98f, 0, 0, 0);
    }

    @Override
    public void updateDescription(Player player) {
        this.description = "\u00a77Combust into a molten inferno,\n\u00a77increasing your Crit Chance by \u00a7c" + this.critChanceIncrease + "%\n\u00a77and your Crit Multiplier by \u00a7c" + this.critMultiplierIncrease + "%\u00a77. Lasts\n\u00a76" + 18 + " \u00a77seconds.";
    }

    @Override
    public List<Pair<String, String>> getAbilityInfo() {
        ArrayList<Pair<String, String>> info = new ArrayList<Pair<String, String>>();
        info.add(new Pair<String, String>("Times Used", "" + this.timesUsed));
        info.add(new Pair<String, String>("Hits Amplified", "" + this.hitsAmplified));
        return info;
    }

    @Override
    public boolean onActivate(WarlordsPlayer wp, Player player) {
        Utils.playGlobalSound(player.getLocation(), "mage.inferno.activation", 2.0f, 1.0f);
        Inferno tempInferno = new Inferno();
        wp.getCooldownManager().addCooldown(new RegularCooldown<Inferno>(this.name, "INFR", Inferno.class, tempInferno, wp, CooldownTypes.ABILITY, cooldownManager -> {}, 360, new TriConsumer[]{(cooldown, ticksLeft, counter) -> {
            if (counter % 3 == 0) {
                Location location = wp.getLocation().add(0.0, 1.2, 0.0);
                ParticleEffect.DRIP_LAVA.display(0.5f, 0.3f, 0.5f, 0.4f, 1, location, 500.0);
                ParticleEffect.FLAME.display(0.5f, 0.3f, 0.5f, 1.0E-4f, 1, location, 500.0);
                ParticleEffect.CRIT.display(0.5f, 0.3f, 0.5f, 1.0E-4f, 1, location, 500.0);
            }
        }}){

            @Override
            public boolean distinct() {
                return true;
            }

            @Override
            public int addCritChanceFromAttacker(WarlordsDamageHealingEvent event, int currentCritChance) {
                if (event.getAbility().isEmpty() || event.getAbility().equals("Time Warp")) {
                    return currentCritChance;
                }
                ++Inferno.this.hitsAmplified;
                return currentCritChance + Inferno.this.critChanceIncrease;
            }

            @Override
            public int addCritMultiplierFromAttacker(WarlordsDamageHealingEvent event, int currentCritMultiplier) {
                if (event.getAbility().isEmpty() || event.getAbility().equals("Time Warp")) {
                    return currentCritMultiplier;
                }
                return currentCritMultiplier + Inferno.this.critMultiplierIncrease;
            }
        });
        return true;
    }

    public int getHitsAmplified() {
        return this.hitsAmplified;
    }

    public int getCritChanceIncrease() {
        return this.critChanceIncrease;
    }

    public int getCritMultiplierIncrease() {
        return this.critMultiplierIncrease;
    }

    public void setCritChanceIncrease(int critChanceIncrease) {
        this.critChanceIncrease = critChanceIncrease;
    }

    public void setCritMultiplierIncrease(int critMultiplierIncrease) {
        this.critMultiplierIncrease = critMultiplierIncrease;
    }
}

