/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.abilties;

import com.ebicep.warlords.abilties.internal.AbstractAbility;
import com.ebicep.warlords.effects.FireWorkEffectPlayer;
import com.ebicep.warlords.effects.ParticleEffect;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.util.java.Pair;
import com.ebicep.warlords.util.warlords.GameRunnable;
import com.ebicep.warlords.util.warlords.PlayerFilter;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class IncendiaryCurse
extends AbstractAbility {
    protected int playersHit = 0;
    private static final double SPEED = 0.25;
    private static final double GRAVITY = -0.008;
    private static final float HITBOX = 5.0f;
    private int blindDurationInTicks = 40;

    public IncendiaryCurse() {
        super("Incendiary Curse", 408.0f, 552.0f, 8.0f, 60, 25, 175);
    }

    @Override
    public void updateDescription(Player player) {
        double blindDuration = this.blindDurationInTicks == 40 ? 1.5 : 3.0;
        this.description = "\u00a77Ignite the targeted area with a cross flame,\n\u00a77dealing \u00a7c" + this.format(this.minDamageHeal) + " \u00a77- \u00a7c" + this.format(this.maxDamageHeal) + " \u00a77damage. Enemies\n\u00a77hit are blinded for \u00a76" + this.format(blindDuration) + " \u00a77seconds.";
    }

    @Override
    public List<Pair<String, String>> getAbilityInfo() {
        ArrayList<Pair<String, String>> info = new ArrayList<Pair<String, String>>();
        info.add(new Pair<String, String>("Times Used", "" + this.timesUsed));
        info.add(new Pair<String, String>("Players Hit", "" + this.playersHit));
        return info;
    }

    @Override
    public boolean onActivate(final WarlordsPlayer wp, Player player) {
        wp.subtractEnergy(this.energyCost);
        Utils.playGlobalSound(player.getLocation(), "mage.frostbolt.activation", 2.0f, 0.7f);
        Location location = player.getLocation();
        final Vector speed = player.getLocation().getDirection().multiply(0.25);
        final ArmorStand stand = (ArmorStand)location.getWorld().spawnEntity(location, EntityType.ARMOR_STAND);
        stand.setHelmet(new ItemStack(Material.FIREBALL));
        stand.setGravity(false);
        stand.setVisible(false);
        new GameRunnable(wp.getGame()){

            @Override
            public void run() {
                this.quarterStep(false);
                this.quarterStep(false);
                this.quarterStep(false);
                this.quarterStep(false);
                this.quarterStep(false);
                this.quarterStep(false);
                this.quarterStep(true);
            }

            private void quarterStep(boolean last) {
                boolean shouldExplode;
                if (!stand.isValid()) {
                    this.cancel();
                    return;
                }
                speed.add(new Vector(0.0, -0.002, 0.0));
                Location newLoc = stand.getLocation();
                newLoc.add(speed);
                stand.teleport(newLoc);
                newLoc.add(0.0, 1.75, 0.0);
                stand.setHeadPose(new EulerAngle(-speed.getY() * 3.0, 0.0, 0.0));
                if (last) {
                    ParticleEffect.FIREWORKS_SPARK.display(0.1f, 0.1f, 0.1f, 0.1f, 4, newLoc.clone().add(0.0, -1.0, 0.0), 500.0);
                }
                if (!newLoc.getBlock().isEmpty() && newLoc.getBlock().getType() != Material.GRASS && newLoc.getBlock().getType() != Material.BARRIER && newLoc.getBlock().getType() != Material.VINE) {
                    shouldExplode = true;
                } else {
                    WarlordsPlayer directHit = PlayerFilter.entitiesAroundRectangle(newLoc, 1.0, 2.0, 1.0).aliveEnemiesOf(wp).findFirstOrNull();
                    boolean bl = shouldExplode = directHit != null;
                }
                if (shouldExplode) {
                    stand.remove();
                    Utils.playGlobalSound(newLoc, Sound.FIRE_IGNITE, 2.0f, 0.1f);
                    FireWorkEffectPlayer.playFirework(newLoc, FireworkEffect.builder().withColor(Color.ORANGE).withColor(Color.RED).with(FireworkEffect.Type.BURST).build());
                    ParticleEffect.SMOKE_NORMAL.display(0.4f, 0.05f, 0.4f, 0.2f, 100, newLoc, 500.0);
                    for (WarlordsPlayer nearEntity : PlayerFilter.entitiesAround(newLoc, 5.0, 5.0, 5.0).aliveEnemiesOf(wp)) {
                        ++IncendiaryCurse.this.playersHit;
                        nearEntity.addDamageInstance(wp, IncendiaryCurse.this.name, IncendiaryCurse.this.minDamageHeal, IncendiaryCurse.this.maxDamageHeal, IncendiaryCurse.this.critChance, IncendiaryCurse.this.critMultiplier, false);
                        nearEntity.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, IncendiaryCurse.this.blindDurationInTicks, 0, true, false));
                        nearEntity.addPotionEffect(new PotionEffect(PotionEffectType.CONFUSION, IncendiaryCurse.this.blindDurationInTicks, 0, true, false));
                    }
                    this.cancel();
                }
            }
        }.runTaskTimer(0L, 1L);
        return true;
    }

    public int getBlindDurationInTicks() {
        return this.blindDurationInTicks;
    }

    public void setBlindDurationInTicks(int blindDurationInTicks) {
        this.blindDurationInTicks = blindDurationInTicks;
    }
}

