/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.abilties;

import com.ebicep.warlords.abilties.internal.AbstractStrikeBase;
import com.ebicep.warlords.events.WarlordsDamageHealingEvent;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.player.cooldowns.CooldownTypes;
import com.ebicep.warlords.player.cooldowns.cooldowns.RegularCooldown;
import com.ebicep.warlords.util.java.Pair;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.bukkit.entity.Player;

public class ImpalingStrike
extends AbstractStrikeBase {
    private int leechDuration = 5;
    private float healingDoneFromEnemyCarrier = 0.0f;

    public ImpalingStrike() {
        super("Impaling Strike", 323.0f, 427.0f, 0.0f, 90, 20, 175);
    }

    @Override
    public void updateDescription(Player player) {
        this.description = "\u00a77Impale an enemy, dealing \u00a7c" + this.format(this.minDamageHeal) + " \u00a77- \u00a7c" + this.format(this.maxDamageHeal) + " \u00a77damage\n\u00a77and afflict them with the \u00a7aLEECH \u00a77effect for \u00a76" + this.leechDuration + " \u00a77seconds.\n\u00a77Whenever an ally (including yourself) deals\n\u00a77damage to a leeched enemy, they heal for \u00a7a15%\n\u00a77of the damage dealt. You heal for \u00a7a25% \u00a77of the\n\u00a77damage you deal to a leeched enemy instead.";
    }

    @Override
    public List<Pair<String, String>> getAbilityInfo() {
        ArrayList<Pair<String, String>> info = new ArrayList<Pair<String, String>>();
        info.add(new Pair<String, String>("Players Struck", "" + this.timesUsed));
        return info;
    }

    @Override
    protected void onHit(final @Nonnull WarlordsPlayer wp, @Nonnull Player player, @Nonnull WarlordsPlayer nearPlayer) {
        nearPlayer.addDamageInstance(wp, this.name, this.minDamageHeal, this.maxDamageHeal, this.critChance, this.critMultiplier, false);
        nearPlayer.getCooldownManager().removeCooldown(ImpalingStrike.class);
        nearPlayer.getCooldownManager().addCooldown(new RegularCooldown<ImpalingStrike>("Leech Debuff", "LCH", ImpalingStrike.class, new ImpalingStrike(), wp, CooldownTypes.DEBUFF, cooldownManager -> {}, this.leechDuration * 20){

            @Override
            public void onDamageFromSelf(WarlordsDamageHealingEvent event, float currentDamageValue, boolean isCrit) {
                float healingMultiplier = event.getAttacker() == wp ? 0.25f : 0.15f;
                event.getAttacker().addHealingInstance(wp, "Leech", currentDamageValue * healingMultiplier, currentDamageValue * healingMultiplier, -1, 100, false, false).ifPresent(warlordsDamageHealingFinalEvent -> {
                    if (event.getPlayer().hasFlag()) {
                        ((ImpalingStrike)this.getCooldownObject()).addHealingDoneFromEnemyCarrier(warlordsDamageHealingFinalEvent.getValue());
                    }
                });
            }
        });
    }

    public int getLeechDuration() {
        return this.leechDuration;
    }

    public void setLeechDuration(int leechDuration) {
        this.leechDuration = leechDuration;
    }

    public float getHealingDoneFromEnemyCarrier() {
        return this.healingDoneFromEnemyCarrier;
    }

    public void addHealingDoneFromEnemyCarrier(float amount) {
        this.healingDoneFromEnemyCarrier += amount;
    }
}

