/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.abilties;

import com.ebicep.warlords.abilties.internal.AbstractAbility;
import com.ebicep.warlords.effects.ParticleEffect;
import com.ebicep.warlords.events.WarlordsDamageHealingEvent;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.player.cooldowns.CooldownTypes;
import com.ebicep.warlords.player.cooldowns.cooldowns.RegularCooldown;
import com.ebicep.warlords.util.java.Pair;
import com.ebicep.warlords.util.java.TriConsumer;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class IceBarrier
extends AbstractAbility {
    private final int duration = 6;
    private int damageReductionPercent = 50;

    public float getDamageReduction() {
        return (float)(100 - this.damageReductionPercent) / 100.0f;
    }

    public IceBarrier() {
        super("Ice Barrier", 0.0f, 0.0f, 46.98f, 0, 0, 0);
    }

    public IceBarrier(int damageReductionPercent) {
        super("Ice Barrier", 0.0f, 0.0f, 46.98f, 0, 0, 0);
        this.damageReductionPercent = damageReductionPercent;
    }

    @Override
    public void updateDescription(Player player) {
        this.description = "\u00a77Surround yourself with a layer of\n\u00a77of cold air, reducing damage taken by\n\u00a7c" + this.damageReductionPercent + "%\u00a77, While active, taking melee\n\u00a77damage reduces the attacker's movement\n\u00a77speed by \u00a7e20% \u00a77for \u00a762 \u00a77seconds. Lasts\n\u00a76" + 6 + " \u00a77seconds.";
    }

    @Override
    public List<Pair<String, String>> getAbilityInfo() {
        ArrayList<Pair<String, String>> info = new ArrayList<Pair<String, String>>();
        info.add(new Pair<String, String>("Times Used", "" + this.timesUsed));
        return info;
    }

    @Override
    public boolean onActivate(WarlordsPlayer wp, Player player) {
        Utils.playGlobalSound(player.getLocation(), "mage.icebarrier.activation", 2.0f, 1.0f);
        IceBarrier tempIceBarrier = new IceBarrier(this.damageReductionPercent);
        wp.getCooldownManager().addCooldown(new RegularCooldown<IceBarrier>(this.name, "ICE", IceBarrier.class, tempIceBarrier, wp, CooldownTypes.ABILITY, cooldownManager -> {}, 120, new TriConsumer[]{(cooldown, ticksLeft, counter) -> {
            if (counter % 5 == 0) {
                Location particleLoc = wp.getLocation().add(0.0, 1.5, 0.0);
                ParticleEffect.CLOUD.display(0.2f, 0.2f, 0.2f, 0.001f, 1, particleLoc, 500.0);
                ParticleEffect.FIREWORKS_SPARK.display(0.3f, 0.2f, 0.3f, 1.0E-4f, 1, particleLoc, 500.0);
            }
        }}){

            @Override
            public float modifyDamageAfterInterveneFromSelf(WarlordsDamageHealingEvent event, float currentDamageValue) {
                float newDamageValue = currentDamageValue * IceBarrier.this.getDamageReduction();
                event.getPlayer().addAbsorbed(Math.abs(currentDamageValue - newDamageValue));
                return newDamageValue;
            }
        });
        return true;
    }

    public int getDamageReductionPercent() {
        return this.damageReductionPercent;
    }

    public void setDamageReductionPercent(int damageReductionPercent) {
        this.damageReductionPercent = damageReductionPercent;
    }
}

