/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.abilties;

import com.ebicep.warlords.Warlords;
import com.ebicep.warlords.abilties.internal.AbstractHolyRadianceBase;
import com.ebicep.warlords.effects.EffectUtils;
import com.ebicep.warlords.effects.ParticleEffect;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.player.cooldowns.CooldownTypes;
import com.ebicep.warlords.util.java.Pair;
import com.ebicep.warlords.util.warlords.PlayerFilter;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class HolyRadianceProtector
extends AbstractHolyRadianceBase {
    private final int markRadius = 15;
    private int markDuration = 6;

    public HolyRadianceProtector(float minDamageHeal, float maxDamageHeal, float cooldown, int energyCost, int critChance, int critMultiplier) {
        super("Holy Radiance", minDamageHeal, maxDamageHeal, cooldown, energyCost, critChance, critMultiplier, 6);
    }

    @Override
    public void updateDescription(Player player) {
        this.description = "\u00a77Radiate with holy energy, healing\n\u00a77yourself and all nearby allies for\n\u00a7a" + this.format(this.minDamageHeal) + " \u00a77- \u00a7a" + this.format(this.maxDamageHeal) + " \u00a77health.\n\n\u00a77You may look at an ally to mark\n\u00a77them for \u00a76" + this.markDuration + " \u00a77seconds. Mark has an\n\u00a77optimal range of \u00a7e" + 15 + " \u00a77blocks. Your marked\n\u00a77ally will emit a second Holy Radiance\n\u00a77for \u00a7a50% \u00a77of the original healing amount\n\u00a77after the mark ends.";
    }

    @Override
    public List<Pair<String, String>> getAbilityInfo() {
        ArrayList<Pair<String, String>> info = new ArrayList<Pair<String, String>>();
        info.add(new Pair<String, String>("Times Used", "" + this.timesUsed));
        info.add(new Pair<String, String>("Players Healed", "" + this.playersHealed));
        info.add(new Pair<String, String>("Players Marked", "" + this.playersMarked));
        return info;
    }

    @Override
    public boolean chain(WarlordsPlayer wp, Player player) {
        for (WarlordsPlayer markTarget : PlayerFilter.entitiesAround((Entity)player, 15.0, 15.0, 15.0).aliveTeammatesOfExcludingSelf(wp).lookingAtFirst(wp).limit(1L)) {
            if (Utils.isLookingAtMark((LivingEntity)player, markTarget.getEntity()) && Utils.hasLineOfSight((LivingEntity)player, markTarget.getEntity())) {
                Utils.playGlobalSound(player.getLocation(), "paladin.consecrate.activation", 2.0f, 0.65f);
                EffectUtils.playParticleLinkAnimation(player.getLocation(), markTarget.getLocation(), 0, 255, 70, 1);
                EffectUtils.playChainAnimation(wp.getLocation(), markTarget.getLocation(), new ItemStack(Material.RED_ROSE), 8);
                HolyRadianceProtector tempMark = new HolyRadianceProtector(this.minDamageHeal, this.maxDamageHeal, this.cooldown, this.energyCost, this.critChance, this.critMultiplier);
                markTarget.getCooldownManager().addRegularCooldown(this.name, "PROT MARK", HolyRadianceProtector.class, tempMark, wp, CooldownTypes.BUFF, cooldownManager -> {
                    if (markTarget.isDead()) {
                        return;
                    }
                    ParticleEffect.SPELL.display(1.0f, 1.0f, 1.0f, 0.06f, 12, markTarget.getLocation(), 500.0);
                    Utils.playGlobalSound(markTarget.getLocation(), "paladin.holyradiance.activation", 2.0f, 0.95f);
                    for (WarlordsPlayer waveTarget : PlayerFilter.entitiesAround(markTarget, 6.0, 6.0, 6.0).aliveTeammatesOf(markTarget)) {
                        wp.getGame().registerGameTask(new AbstractHolyRadianceBase.FlyingArmorStand(this, markTarget.getLocation(), waveTarget, wp, 1.1, this.minDamageHeal * 0.5f, this.maxDamageHeal * 0.5f).runTaskTimer((Plugin)Warlords.getInstance(), 1L, 1L));
                    }
                }, this.markDuration * 20, (cooldown, ticksLeft, counter) -> {
                    if (counter % 10 == 0) {
                        Location playerLoc = markTarget.getLocation();
                        Location particleLoc = playerLoc.clone();
                        for (int i = 0; i < 4; ++i) {
                            for (int j = 0; j < 10; ++j) {
                                double angle = (double)j / 9.0 * Math.PI * 2.0;
                                double width = 1.0;
                                particleLoc.setX(playerLoc.getX() + Math.sin(angle) * width);
                                particleLoc.setY(playerLoc.getY() + (double)i / 6.0);
                                particleLoc.setZ(playerLoc.getZ() + Math.cos(angle) * width);
                                ParticleEffect.REDSTONE.display((ParticleEffect.ParticleColor)new ParticleEffect.OrdinaryColor(0, 255, 70), particleLoc, 500.0);
                            }
                        }
                    }
                });
                wp.sendMessage(WarlordsPlayer.GIVE_ARROW_GREEN + ChatColor.GRAY + " You have marked " + ChatColor.GREEN + markTarget.getName() + ChatColor.GRAY + "!");
                markTarget.sendMessage(WarlordsPlayer.RECEIVE_ARROW_GREEN + ChatColor.GRAY + " You have been granted " + ChatColor.GREEN + "Protector's Mark" + ChatColor.GRAY + " by " + wp.getName() + "!");
                return true;
            }
            player.sendMessage("\u00a7cYour mark was out of range or you did not target a player!");
        }
        return false;
    }

    public void setMarkDuration(int markDuration) {
        this.markDuration = markDuration;
    }
}

