/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.abilties;

import com.ebicep.warlords.abilties.internal.AbstractHolyRadianceBase;
import com.ebicep.warlords.effects.EffectUtils;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.player.cooldowns.CooldownTypes;
import com.ebicep.warlords.util.java.Pair;
import com.ebicep.warlords.util.warlords.PlayerFilter;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class HolyRadianceAvenger
extends AbstractHolyRadianceBase {
    private final int markRadius = 15;
    private int markDuration = 8;

    public HolyRadianceAvenger(float minDamageHeal, float maxDamageHeal, float cooldown, int energyCost, int critChance, int critMultiplier) {
        super("Holy Radiance", minDamageHeal, maxDamageHeal, cooldown, energyCost, critChance, critMultiplier, 6);
    }

    @Override
    public void updateDescription(Player player) {
        this.description = "\u00a77Radiate with holy energy, healing\n\u00a77yourself and all nearby allies for\n\u00a7a" + this.format(this.minDamageHeal) + " \u00a77- \u00a7a" + this.format(this.maxDamageHeal) + " \u00a77health.\n\n\u00a77You may look at an enemy to mark\n\u00a77them for \u00a76" + this.markDuration + " \u00a77seconds. Mark has an\n\u00a77optimal range of \u00a7e" + 15 + " \u00a77blocks. Reducing\n\u00a77their energy per second by\n\u00a7e8 \u00a77for the duration.";
    }

    @Override
    public List<Pair<String, String>> getAbilityInfo() {
        ArrayList<Pair<String, String>> info = new ArrayList<Pair<String, String>>();
        info.add(new Pair<String, String>("Times Used", "" + this.timesUsed));
        info.add(new Pair<String, String>("Players Healed", "" + this.playersHealed));
        info.add(new Pair<String, String>("Players Marked", "" + this.playersMarked));
        return info;
    }

    @Override
    public boolean chain(WarlordsPlayer wp, Player player) {
        for (WarlordsPlayer markTarget : PlayerFilter.entitiesAround((Entity)player, 15.0, 15.0, 15.0).aliveEnemiesOf(wp).lookingAtFirst(wp).limit(1L)) {
            if (Utils.isLookingAtMark((LivingEntity)player, markTarget.getEntity()) && Utils.hasLineOfSight((LivingEntity)player, markTarget.getEntity())) {
                Utils.playGlobalSound(player.getLocation(), "paladin.consecrate.activation", 2.0f, 0.65f);
                EffectUtils.playParticleLinkAnimation(wp.getLocation(), markTarget.getLocation(), 255, 50, 0, 1);
                EffectUtils.playChainAnimation(wp, markTarget, new ItemStack(Material.LEAVES, 1, 2), 8);
                HolyRadianceAvenger tempMark = new HolyRadianceAvenger(this.minDamageHeal, this.maxDamageHeal, this.cooldown, this.energyCost, this.critChance, this.critMultiplier);
                markTarget.getCooldownManager().addRegularCooldown(this.name, "AVE MARK", HolyRadianceAvenger.class, tempMark, wp, CooldownTypes.DEBUFF, cooldownManager -> {}, this.markDuration * 20, (cooldown, ticksLeft, counter) -> {
                    if (counter % 10 == 0) {
                        EffectUtils.playCylinderAnimation(markTarget.getLocation(), 1.0, 250, 25, 25);
                    }
                });
                wp.sendMessage(WarlordsPlayer.GIVE_ARROW_GREEN + ChatColor.GRAY + " You have marked " + ChatColor.GOLD + markTarget.getName() + ChatColor.GRAY + "!");
                markTarget.sendMessage(WarlordsPlayer.RECEIVE_ARROW_RED + ChatColor.GRAY + " You have been cursed with " + ChatColor.GOLD + "Avenger's Mark" + ChatColor.GRAY + " by " + wp.getName() + "!");
                return true;
            }
            player.sendMessage("\u00a7cYour mark was out of range or you did not target a player!");
        }
        return false;
    }
}

