/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.abilties;

import com.ebicep.warlords.Warlords;
import com.ebicep.warlords.abilties.internal.AbstractAbility;
import com.ebicep.warlords.effects.EffectUtils;
import com.ebicep.warlords.effects.ParticleEffect;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.player.cooldowns.CooldownTypes;
import com.ebicep.warlords.util.bukkit.Matrix4d;
import com.ebicep.warlords.util.java.Pair;
import com.ebicep.warlords.util.java.TriConsumer;
import com.ebicep.warlords.util.warlords.PlayerFilter;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class HeartToHeart
extends AbstractAbility {
    protected int timesUsedWithFlag = 0;
    private int radius = 15;
    private int verticalRadius = 15;
    private int vindDuration = 6;
    private float healthRestore = 600.0f;

    public HeartToHeart() {
        super("Heart To Heart", 0.0f, 0.0f, 12.0f, 20, -1, 100);
    }

    @Override
    public void updateDescription(Player player) {
        this.description = "\u00a77Throw a chain towards an ally in a \u00a7e15 \u00a77block\n\u00a77radius, grappling the Vindicator towards the ally.\n\u00a77You and the targeted ally gain \u00a76VIND \u00a77for \u00a76" + this.vindDuration + " \u00a77seconds,\n\u00a77granting immunity to de-buffs. You are healed\n\u00a77for \u00a7a" + this.format(this.healthRestore) + " \u00a77health after reaching your ally.\n\n\u00a77Heart To Heart's range is greatly reduced when\n\u00a77holding a flag.";
    }

    @Override
    public List<Pair<String, String>> getAbilityInfo() {
        ArrayList<Pair<String, String>> info = new ArrayList<Pair<String, String>>();
        info.add(new Pair<String, String>("Times Used", "" + this.timesUsed));
        info.add(new Pair<String, String>("Times Used With Flag", "" + this.timesUsedWithFlag));
        return info;
    }

    @Override
    public boolean onActivate(final @Nonnull WarlordsPlayer wp, final @Nonnull Player player) {
        if (wp.hasFlag()) {
            this.radius = 10;
            this.verticalRadius = 2;
        } else {
            wp.setFlagPickCooldown(2);
            this.radius = 15;
            this.verticalRadius = 15;
        }
        Iterator<WarlordsPlayer> iterator = PlayerFilter.entitiesAround(wp, (double)this.radius, (double)this.verticalRadius, (double)this.radius).aliveTeammatesOfExcludingSelf(wp).requireLineOfSight(wp).lookingAtFirst(wp).limit(1L).iterator();
        if (iterator.hasNext()) {
            final WarlordsPlayer heartTarget = iterator.next();
            if (wp.hasFlag()) {
                ++this.timesUsedWithFlag;
            }
            wp.subtractEnergy(this.energyCost);
            Utils.playGlobalSound(player.getLocation(), "rogue.hearttoheart.activation", 2.0f, 1.0f);
            Utils.playGlobalSound(player.getLocation(), "rogue.hearttoheart.activation.alt", 2.0f, 1.2f);
            HeartToHeart tempHeartToHeart = new HeartToHeart();
            wp.getCooldownManager().removeCooldownByName("Vindicate Debuff Immunity");
            wp.getCooldownManager().addRegularCooldown("Vindicate Debuff Immunity", "VIND", HeartToHeart.class, tempHeartToHeart, wp, CooldownTypes.BUFF, cooldownManager -> {}, this.vindDuration * 20, new TriConsumer[0]);
            heartTarget.getCooldownManager().removeCooldownByName("Vindicate Debuff Immunity");
            heartTarget.getCooldownManager().addRegularCooldown("Vindicate Debuff Immunity", "VIND", HeartToHeart.class, tempHeartToHeart, wp, CooldownTypes.BUFF, cooldownManager -> {}, this.vindDuration * 20, new TriConsumer[0]);
            new BukkitRunnable(){
                final Location playerLoc;
                int timer;
                {
                    this.playerLoc = wp.getLocation();
                    this.timer = 0;
                }

                public void run() {
                    ++this.timer;
                    if (this.timer >= 8 || heartTarget.isDead() || wp.isDead()) {
                        this.cancel();
                    }
                    double target = (double)this.timer / 8.0;
                    Location targetLoc = heartTarget.getLocation();
                    Location newLocation = new Location(this.playerLoc.getWorld(), Utils.lerp(this.playerLoc.getX(), targetLoc.getX(), target), Utils.lerp(this.playerLoc.getY(), targetLoc.getY(), target), Utils.lerp(this.playerLoc.getZ(), targetLoc.getZ(), target), targetLoc.getYaw(), targetLoc.getPitch());
                    EffectUtils.playChainAnimation(wp, heartTarget, new ItemStack(Material.LEAVES, 1, 1), this.timer);
                    wp.teleportLocationOnly(newLocation);
                    player.setFallDistance(-5.0f);
                    newLocation.add(0.0, 1.0, 0.0);
                    Matrix4d center = new Matrix4d(newLocation);
                    for (float i = 0.0f; i < 6.0f; i += 1.0f) {
                        double angle = Math.toRadians(i * 90.0f) + (double)this.timer * 0.6;
                        double width = 1.5;
                        ParticleEffect.SPELL_WITCH.display(0.0f, 0.0f, 0.0f, 0.0f, 1, center.translateVector(this.playerLoc.getWorld(), 0.0, Math.sin(angle) * width, Math.cos(angle) * width), 500.0);
                    }
                    if (this.timer >= 8) {
                        wp.setVelocity(this.playerLoc.getDirection().multiply(0.4).setY(0.2), false);
                        wp.addHealingInstance(wp, HeartToHeart.this.name, HeartToHeart.this.healthRestore, HeartToHeart.this.healthRestore, -1, 100, false, false);
                    }
                }
            }.runTaskTimer((Plugin)Warlords.getInstance(), 0L, 1L);
            return true;
        }
        return false;
    }

    public void setVindDuration(int vindDuration) {
        this.vindDuration = vindDuration;
    }

    public float getHealthRestore() {
        return this.healthRestore;
    }

    public void setHealthRestore(float healthRestore) {
        this.healthRestore = healthRestore;
    }
}

