/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.abilties;

import com.ebicep.warlords.abilties.internal.AbstractTotemBase;
import com.ebicep.warlords.effects.FallingBlockWaveEffect;
import com.ebicep.warlords.effects.ParticleEffect;
import com.ebicep.warlords.effects.circle.CircleEffect;
import com.ebicep.warlords.effects.circle.CircumferenceEffect;
import com.ebicep.warlords.events.WarlordsDamageHealingEvent;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.player.cooldowns.CooldownTypes;
import com.ebicep.warlords.player.cooldowns.cooldowns.RegularCooldown;
import com.ebicep.warlords.util.java.Pair;
import com.ebicep.warlords.util.warlords.PlayerFilter;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class HealingTotem
extends AbstractTotemBase {
    protected int playersHealed = 0;
    protected int playersCrippled = 0;
    private final int radius = 7;
    private final int duration = 6;
    private final int crippleDuration = 6;

    public HealingTotem() {
        super("Healing Totem", 191.0f, 224.0f, 62.64f, 60, 25, 175);
    }

    public HealingTotem(ArmorStand totem, WarlordsPlayer owner) {
        super("Healing Totem", 191.0f, 224.0f, 62.64f, 60, 25, 175, totem, owner);
    }

    @Override
    public void updateDescription(Player player) {
        this.description = "\u00a77Place a totem on the ground that\n\u00a77pulses constantly, healing nearby\n\u00a77allies in a \u00a7e7 \u00a77block radius for \u00a7a" + this.format(this.minDamageHeal) + " \u00a77- \u00a7a" + this.format(this.maxDamageHeal) + "\n\u00a77every second. The healing will gradually\n\u00a77increase by \u00a7a35% \u00a77(up to 210%) every\n\u00a77second. Lasts \u00a76" + 6 + " \u00a77seconds.\n\n\u00a77Pressing SHIFT or re-activating the\n ability causes your totem to\n\u00a77pulse with immense force, crippling all\n\u00a77enemies for \u00a76" + 6 + " \u00a77seconds. Crippled enemies\n\u00a77deal \u00a7c25% \u00a77less damage.";
    }

    @Override
    public List<Pair<String, String>> getAbilityInfo() {
        ArrayList<Pair<String, String>> info = new ArrayList<Pair<String, String>>();
        info.add(new Pair<String, String>("Times Used", "" + this.timesUsed));
        info.add(new Pair<String, String>("Players Healed", "" + this.playersHealed));
        info.add(new Pair<String, String>("Players Crippled", "" + this.playersCrippled));
        return info;
    }

    @Override
    protected ItemStack getTotemItemStack() {
        return new ItemStack(Material.RED_ROSE, 1, 7);
    }

    @Override
    protected void playSound(Player player, Location location) {
        Utils.playGlobalSound(location, "shaman.totem.activation", 2.0f, 1.0f);
    }

    @Override
    protected void onActivation(WarlordsPlayer wp, Player player, ArmorStand totemStand) {
        HealingTotem tempHealingTotem = new HealingTotem(totemStand, wp);
        AtomicInteger cooldownCounter = new AtomicInteger();
        RegularCooldown<HealingTotem> healingTotemCooldown = new RegularCooldown<HealingTotem>(this.name, "TOTEM", HealingTotem.class, tempHealingTotem, wp, CooldownTypes.ABILITY, cooldownManager -> {
            totemStand.remove();
            Utils.playGlobalSound(totemStand.getLocation(), Sound.BLAZE_DEATH, 1.2f, 0.7f);
            Utils.playGlobalSound(totemStand.getLocation(), "shaman.heal.impact", 2.0f, 1.0f);
            new FallingBlockWaveEffect(totemStand.getLocation().clone().add(0.0, 1.0, 0.0), 3.0, 0.8, Material.SAPLING, 1).play();
            float healMultiplier = 1.0f + 0.35f * ((float)cooldownCounter.get() / 20.0f + 1.0f);
            PlayerFilter.entitiesAround((Entity)totemStand, 7.0, 7.0, 7.0).aliveTeammatesOf(wp).forEach((Consumer<? super WarlordsPlayer>)((Consumer<WarlordsPlayer>)nearPlayer -> {
                ++this.playersHealed;
                nearPlayer.addHealingInstance(wp, this.name, this.minDamageHeal * healMultiplier, this.maxDamageHeal * healMultiplier, this.critChance, this.critMultiplier, false, false);
            }));
        }, 120, (cooldown, ticksLeft, counter) -> {
            if (counter % 20 == 0) {
                cooldownCounter.set((int)counter);
                Utils.playGlobalSound(totemStand.getLocation(), "shaman.earthlivingweapon.impact", 2.0f, 0.9f);
                ParticleEffect.VILLAGER_HAPPY.display(0.4f, 0.2f, 0.4f, 0.05f, 5, totemStand.getLocation().clone().add(0.0, 1.6, 0.0), 500.0);
                Location totemLoc = totemStand.getLocation();
                totemLoc.add(0.0, 2.0, 0.0);
                Location particleLoc = totemLoc.clone();
                for (int i = 0; i < 1; ++i) {
                    for (int j = 0; j < 12; ++j) {
                        double angle = (double)j / 10.0 * Math.PI * 2.0;
                        double width = 7.0;
                        particleLoc.setX(totemLoc.getX() + Math.sin(angle) * width);
                        particleLoc.setY(totemLoc.getY() + (double)i / 2.0);
                        particleLoc.setZ(totemLoc.getZ() + Math.cos(angle) * width);
                        ParticleEffect.FIREWORKS_SPARK.display(0.0f, 0.0f, 0.0f, 0.0f, 1, particleLoc, 500.0);
                    }
                }
                CircleEffect circle = new CircleEffect(wp.getGame(), wp.getTeam(), totemStand.getLocation().add(0.0, 1.0, 0.0), 7.0, new CircumferenceEffect(ParticleEffect.VILLAGER_HAPPY, ParticleEffect.REDSTONE).particlesPerCircumference(1.5));
                circle.playEffects();
                float healMultiplier = 1.0f + 0.35f * ((float)counter.intValue() / 20.0f);
                PlayerFilter.entitiesAround((Entity)totemStand, 7.0, 7.0, 7.0).aliveTeammatesOf(wp).forEach((Consumer<? super WarlordsPlayer>)((Consumer<WarlordsPlayer>)teammate -> {
                    ++this.playersHealed;
                    teammate.addHealingInstance(wp, this.name, this.minDamageHeal * healMultiplier, this.maxDamageHeal * healMultiplier, this.critChance, this.critMultiplier, false, false);
                }));
            }
        });
        wp.getCooldownManager().addCooldown(healingTotemCooldown);
        this.addSecondaryAbility(() -> {
            Utils.playGlobalSound(totemStand.getLocation(), "paladin.hammeroflight.impact", 1.5f, 0.2f);
            new FallingBlockWaveEffect(totemStand.getLocation().add(0.0, 1.0, 0.0), 7.0, 2.0, Material.SAPLING, 1).play();
            PlayerFilter.entitiesAround(totemStand.getLocation(), 7.0, 7.0, 7.0).aliveEnemiesOf(wp).forEach((Consumer<? super WarlordsPlayer>)((Consumer<WarlordsPlayer>)p -> {
                ++this.playersCrippled;
                wp.sendMessage(WarlordsPlayer.GIVE_ARROW_GREEN + ChatColor.GRAY + " Your Healing Totem has crippled " + ChatColor.YELLOW + p.getName() + ChatColor.GRAY + "!");
                p.getCooldownManager().addCooldown(new RegularCooldown<HealingTotem>("Totem Crippling", "CRIP", HealingTotem.class, tempHealingTotem, wp, CooldownTypes.DEBUFF, cooldownManager -> {}, 120){

                    @Override
                    public float modifyDamageBeforeInterveneFromAttacker(WarlordsDamageHealingEvent event, float currentDamageValue) {
                        return currentDamageValue * 0.75f;
                    }
                });
            }));
        }, false, secondaryAbility -> !wp.getCooldownManager().hasCooldown(healingTotemCooldown) || wp.isDead());
    }
}

