/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.abilties;

import com.ebicep.warlords.abilties.internal.AbstractAbility;
import com.ebicep.warlords.abilties.internal.Overheal;
import com.ebicep.warlords.effects.ParticleEffect;
import com.ebicep.warlords.effects.circle.AreaEffect;
import com.ebicep.warlords.effects.circle.CircleEffect;
import com.ebicep.warlords.effects.circle.CircumferenceEffect;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.player.cooldowns.CooldownTypes;
import com.ebicep.warlords.player.cooldowns.cooldowns.RegularCooldown;
import com.ebicep.warlords.util.java.Pair;
import com.ebicep.warlords.util.java.TriConsumer;
import com.ebicep.warlords.util.warlords.PlayerFilter;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitTask;

public class HealingRain
extends AbstractAbility {
    protected int playersHealed = 0;
    private int duration = 12;
    private int radius = 8;

    public HealingRain() {
        super("Healing Rain", 100.0f, 125.0f, 52.85f, 50, 25, 200);
    }

    @Override
    public List<Pair<String, String>> getAbilityInfo() {
        ArrayList<Pair<String, String>> info = new ArrayList<Pair<String, String>>();
        info.add(new Pair<String, String>("Times Used", "" + this.timesUsed));
        info.add(new Pair<String, String>("Players Healed", "" + this.playersHealed));
        return info;
    }

    @Override
    public void updateDescription(Player player) {
        this.description = "\u00a77Conjure rain at targeted\nlocation that will restore \u00a7a" + this.format(this.minDamageHeal) + "\n\u00a77- \u00a7a" + this.format(this.maxDamageHeal) + " \u00a77health every 0.5 seconds\nto allies. Lasts \u00a76" + this.duration + " \u00a77seconds.\n\nYou may move Healing Rain to your location\nusing your SNEAK key.\n\n\u00a77Healing Rain can overheal allies for up to\n\u00a7a10% \u00a77of their max health as bonus health\n\u00a77for \u00a76" + 15 + " \u00a77seconds.";
    }

    @Override
    public boolean onActivate(WarlordsPlayer wp, Player player) {
        if (player.getTargetBlock((Set)null, 25).getType() == Material.AIR) {
            return false;
        }
        wp.subtractEnergy(this.energyCost);
        wp.getSpec().getOrange().setCurrentCooldown((float)((double)this.cooldown * wp.getCooldownModifier()));
        Location location = player.getTargetBlock((Set)null, 25).getLocation().clone();
        Utils.playGlobalSound(location, "mage.healingrain.impact", 2.0f, 1.0f);
        CircleEffect circleEffect = new CircleEffect(wp.getGame(), wp.getTeam(), location, this.radius, new CircumferenceEffect(ParticleEffect.VILLAGER_HAPPY, ParticleEffect.REDSTONE), new AreaEffect(5.0, ParticleEffect.CLOUD).particlesPerSurface(0.025), new AreaEffect(5.0, ParticleEffect.DRIP_WATER).particlesPerSurface(0.025));
        BukkitTask particleTask = wp.getGame().registerGameTask(circleEffect::playEffects, 0, 1);
        RegularCooldown<HealingRain> healingRainCooldown = new RegularCooldown<HealingRain>(this.name, "RAIN", HealingRain.class, new HealingRain(), wp, CooldownTypes.ABILITY, cooldownManager -> particleTask.cancel(), this.duration * 20, (cooldown, ticksLeft, counter) -> {
            if (counter % 10 == 0) {
                for (WarlordsPlayer teammateInRain : PlayerFilter.entitiesAround(location, (double)this.radius, (double)this.radius, (double)this.radius).aliveTeammatesOf(wp)) {
                    ++this.playersHealed;
                    teammateInRain.addHealingInstance(wp, this.name, this.minDamageHeal, this.maxDamageHeal, this.critChance, this.critMultiplier, false, false);
                    if (teammateInRain == wp) continue;
                    teammateInRain.getCooldownManager().removeCooldownByObject(Overheal.OVERHEAL_MARKER);
                    teammateInRain.getCooldownManager().addRegularCooldown("Overheal", "OVERHEAL", Overheal.class, Overheal.OVERHEAL_MARKER, wp, CooldownTypes.BUFF, cooldownManager -> {}, 300, new TriConsumer[0]);
                }
            }
        });
        wp.getCooldownManager().addCooldown(healingRainCooldown);
        this.addSecondaryAbility(() -> {
            if (wp.isAlive()) {
                wp.playSound(wp.getLocation(), "mage.timewarp.teleport", 2.0f, 1.35f);
                wp.sendMessage(WarlordsPlayer.GIVE_ARROW_GREEN + " \u00a77You moved your \u00a7aHealing Rain \u00a77to your current location.");
                location.setX(wp.getLocation().getX());
                location.setY(wp.getLocation().getY());
                location.setZ(wp.getLocation().getZ());
            }
        }, true, secondaryAbility -> !wp.getCooldownManager().hasCooldown(healingRainCooldown));
        return true;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }
}

