/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.abilties;

import com.ebicep.warlords.abilties.internal.AbstractAbility;
import com.ebicep.warlords.effects.ParticleEffect;
import com.ebicep.warlords.effects.circle.CircleEffect;
import com.ebicep.warlords.effects.circle.CircumferenceEffect;
import com.ebicep.warlords.effects.circle.LineEffect;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.player.cooldowns.CooldownFilter;
import com.ebicep.warlords.player.cooldowns.CooldownTypes;
import com.ebicep.warlords.player.cooldowns.cooldowns.RegularCooldown;
import com.ebicep.warlords.util.java.Pair;
import com.ebicep.warlords.util.warlords.PlayerFilter;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class HammerOfLight
extends AbstractAbility {
    private static final int radius = 6;
    private final int duration = 10;
    protected int playersHealed = 0;
    protected int playersDamaged = 0;
    private boolean isCrownOfLight = false;
    private Location location;

    public HammerOfLight() {
        super("Hammer of Light", 178.0f, 244.0f, 62.64f, 50, 20, 175);
    }

    public HammerOfLight(Location location) {
        super("Hammer of Light", 178.0f, 244.0f, 62.64f, 50, 20, 175);
        this.location = location;
    }

    @Override
    public void updateDescription(Player player) {
        this.description = "\u00a77Throw down a Hammer of Light on\n\u00a77the ground, dealing \u00a7c178 \u00a77- \u00a7c244 \u00a77damage\n\u00a77damage every second to nearby enemies and\n\u00a77healing nearby allies for \u00a7a" + this.format(this.minDamageHeal) + " \u00a77- \u00a7a" + this.format(this.maxDamageHeal) + " \u00a77every second\n\u00a77in a \u00a7e" + 6 + " \u00a77block radius. Your Protector Strike\n\u00a77pierces shields and defenses of enemies\n\u00a77standing on top of the Hammer of Light.\n\u00a77Lasts \u00a76" + 10 + " \u00a77seconds.\n\n\u00a77You may SNEAK to turn your hammer into Crown of Light.\n\u00a77Removing the damage and piercing BUT increasing\n\u00a77the healing \u00a77by \u00a7a50% \u00a77and reducing the\n\u00a77energy cost of your Protector's Strike by\n\u00a7e10 \u00a77energy. You cannot put the Hammer of Light\n\u00a77back down after you converted it.";
    }

    public static boolean isStandingInHammer(WarlordsPlayer owner, WarlordsPlayer standing) {
        return new CooldownFilter<RegularCooldown>(owner, RegularCooldown.class).filterCooldownClassAndMapToObjectsOfClass(HammerOfLight.class).filter(HammerOfLight::isHammer).anyMatch(hammerOfLight -> hammerOfLight.getLocation().distanceSquared(standing.getLocation()) < 36.0);
    }

    public static List<WarlordsPlayer> getStandingInHammer(WarlordsPlayer owner) {
        HashSet playersInHammer = new HashSet();
        new CooldownFilter<RegularCooldown>(owner, RegularCooldown.class).filterCooldownClassAndMapToObjectsOfClass(HammerOfLight.class).filter(HammerOfLight::isHammer).map(HammerOfLight::getLocation).forEach(loc -> {
            for (WarlordsPlayer enemy : PlayerFilter.entitiesAround(loc, 6.0, 4.0, 6.0).enemiesOf(owner).isAlive()) {
                playersInHammer.add(enemy);
            }
        });
        return new ArrayList<WarlordsPlayer>(playersInHammer);
    }

    @Override
    public List<Pair<String, String>> getAbilityInfo() {
        ArrayList<Pair<String, String>> info = new ArrayList<Pair<String, String>>();
        info.add(new Pair<String, String>("Times Used", "" + this.timesUsed));
        info.add(new Pair<String, String>("Players Healed", "" + this.playersHealed));
        info.add(new Pair<String, String>("Players Damaged", "" + this.playersDamaged));
        return info;
    }

    @Override
    public boolean onActivate(WarlordsPlayer wp, Player player) {
        if (player.getTargetBlock((Set)null, 25).getType() == Material.AIR) {
            return false;
        }
        wp.subtractEnergy(this.energyCost);
        wp.getSpec().getOrange().setCurrentCooldown((float)((double)this.cooldown * wp.getCooldownModifier()));
        Utils.playGlobalSound(player.getLocation(), "paladin.hammeroflight.impact", 2.0f, 0.85f);
        Location location = player.getTargetBlock((Set)null, 25).getLocation().clone().add(0.6, 0.0, 0.6).clone();
        if (location.clone().add(0.0, 1.0, 0.0).getBlock().getType() != Material.AIR) {
            if (location.clone().add(1.0, 0.0, 0.0).getBlock().getType() == Material.AIR) {
                location.add(0.6, 0.0, 0.0);
            } else if (location.clone().add(-1.0, 0.0, 0.0).getBlock().getType() == Material.AIR) {
                location.add(-0.6, 0.0, 0.0);
            } else if (location.clone().add(0.0, 0.0, 1.0).getBlock().getType() == Material.AIR) {
                location.add(0.0, 0.0, 0.6);
            } else if (location.clone().add(0.0, 0.0, -1.0).getBlock().getType() == Material.AIR) {
                location.add(0.0, 0.0, -0.6);
            }
        }
        CircleEffect circleEffect = new CircleEffect(wp.getGame(), wp.getTeam(), location, 6.0, new CircumferenceEffect(ParticleEffect.VILLAGER_HAPPY, ParticleEffect.REDSTONE), new LineEffect(location.clone().add(0.0, 2.3, 0.0), ParticleEffect.SPELL));
        BukkitTask particleTask = wp.getGame().registerGameTask(circleEffect::playEffects, 0, 1);
        ArmorStand hammer = this.spawnHammer(location);
        HammerOfLight tempHammerOfLight = new HammerOfLight(location);
        RegularCooldown<HammerOfLight> hammerOfLightCooldown = new RegularCooldown<HammerOfLight>(this.name, "HAMMER", HammerOfLight.class, tempHammerOfLight, wp, CooldownTypes.ABILITY, cooldownManager -> {
            hammer.remove();
            particleTask.cancel();
        }, 200, (cooldown, ticksLeft, counter) -> {
            block3: {
                block4: {
                    if (counter % 20 != 0) break block3;
                    if (!tempHammerOfLight.isCrownOfLight()) break block4;
                    if (!wp.isAlive()) break block3;
                    for (WarlordsPlayer allyTarget : PlayerFilter.entitiesAround(wp.getLocation(), 6.0, 6.0, 6.0).aliveTeammatesOf(wp)) {
                        ++this.playersHealed;
                        allyTarget.addHealingInstance(wp, "Crown of Light", this.minDamageHeal * 1.5f, this.maxDamageHeal * 1.5f, this.critChance, this.critMultiplier, false, false);
                    }
                    break block3;
                }
                for (WarlordsPlayer hammerTarget : PlayerFilter.entitiesAround(location, 6.0, 6.0, 6.0).isAlive()) {
                    if (wp.isTeammate(hammerTarget)) {
                        ++this.playersHealed;
                        hammerTarget.addHealingInstance(wp, this.name, this.minDamageHeal, this.maxDamageHeal, this.critChance, this.critMultiplier, false, false);
                        continue;
                    }
                    ++this.playersDamaged;
                    hammerTarget.addDamageInstance(wp, this.name, 178.0f, 244.0f, this.critChance, this.critMultiplier, false);
                }
            }
        });
        wp.getCooldownManager().addCooldown(hammerOfLightCooldown);
        location.add(0.0, 1.0, 0.0);
        this.addSecondaryAbility(() -> {
            if (wp.isAlive() && wp.getCooldownManager().hasCooldown(hammerOfLightCooldown)) {
                hammer.remove();
                particleTask.cancel();
                Utils.playGlobalSound(wp.getLocation(), "warrior.revenant.orbsoflife", 2.0f, 0.15f);
                Utils.playGlobalSound(wp.getLocation(), "mage.firebreath.activation", 2.0f, 0.25f);
                hammerOfLightCooldown.addTriConsumer((cooldown, ticksLeft, counter) -> {
                    if (counter % 6 == 0) {
                        double angle = 0.0;
                        for (int i = 0; i < 9; ++i) {
                            double x = 0.4 * Math.cos(angle);
                            double z = 0.4 * Math.sin(angle);
                            angle += 40.0;
                            Vector v = new Vector(x, 2.0, z);
                            Location loc = wp.getLocation().clone().add(v);
                            ParticleEffect.SPELL.display(0.0f, 0.0f, 0.0f, 0.0f, 1, loc, 500.0);
                        }
                        new CircleEffect(wp.getGame(), wp.getTeam(), wp.getLocation().add(0.0, 0.75, 0.0), 3.0, new CircumferenceEffect(ParticleEffect.SPELL).particlesPerCircumference(0.5)).playEffects();
                    }
                });
                tempHammerOfLight.setCrownOfLight(true);
                hammerOfLightCooldown.setNameAbbreviation("CROWN");
            }
        }, false, secondaryAbility -> !wp.getCooldownManager().hasCooldown(hammerOfLightCooldown) || wp.isDead());
        return true;
    }

    public ArmorStand spawnHammer(Location location) {
        Location newLocation = location.clone();
        for (int i = 0; i < 10; ++i) {
            if (newLocation.getWorld().getBlockAt(newLocation.clone().add(0.0, -1.0, 0.0)).getType() != Material.AIR) continue;
            newLocation.add(0.0, -1.0, 0.0);
        }
        newLocation.add(0.0, -1.0, 0.0);
        ArmorStand hammer = (ArmorStand)location.getWorld().spawnEntity(newLocation.clone().add(0.25, 1.9, -0.25), EntityType.ARMOR_STAND);
        hammer.setRightArmPose(new EulerAngle(20.25, 0.0, 0.0));
        hammer.setItemInHand(new ItemStack(Material.STRING));
        hammer.setGravity(false);
        hammer.setVisible(false);
        hammer.setMarker(true);
        return hammer;
    }

    public boolean isHammer() {
        return !this.isCrownOfLight;
    }

    public boolean isCrownOfLight() {
        return this.isCrownOfLight;
    }

    public void setCrownOfLight(boolean crownOfLight) {
        this.isCrownOfLight = crownOfLight;
    }

    public Location getLocation() {
        return this.location;
    }
}

