/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.abilties;

import com.ebicep.customentities.CustomFallingBlock;
import com.ebicep.warlords.abilties.TimeWarp;
import com.ebicep.warlords.abilties.internal.AbstractAbility;
import com.ebicep.warlords.events.WarlordsEvents;
import com.ebicep.warlords.game.option.marker.FlagHolder;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.util.java.Pair;
import com.ebicep.warlords.util.warlords.GameRunnable;
import com.ebicep.warlords.util.warlords.PlayerFilter;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class GroundSlam
extends AbstractAbility {
    protected int playersHit = 0;
    protected int carrierHit = 0;
    protected int warpsKnockbacked = 0;

    public GroundSlam(String name, float minDamageHeal, float maxDamageHeal, float cooldown, int energyCost, int critChance, int critMultiplier) {
        super(name, minDamageHeal, maxDamageHeal, cooldown, energyCost, critChance, critMultiplier);
    }

    @Override
    public void updateDescription(Player player) {
        this.description = "\u00a77Slam the ground, creating a shockwave\n\u00a77around you that deals \u00a7c" + this.format(this.minDamageHeal) + " \u00a77- \u00a7c" + this.format(this.maxDamageHeal) + "\n\u00a77damage and knocks enemies back slightly.";
    }

    @Override
    public List<Pair<String, String>> getAbilityInfo() {
        ArrayList<Pair<String, String>> info = new ArrayList<Pair<String, String>>();
        info.add(new Pair<String, String>("Times Used", "" + this.timesUsed));
        return info;
    }

    @Override
    public boolean onActivate(final WarlordsPlayer wp, Player player) {
        wp.subtractEnergy(this.energyCost);
        Utils.playGlobalSound(player.getLocation(), "warrior.groundslam.activation", 2.0f, 1.0f);
        final ArrayList<List<Location>> fallingBlockLocations = new ArrayList<List<Location>>();
        final ArrayList customFallingBlocks = new ArrayList();
        final ArrayList currentPlayersHit = new ArrayList();
        Location location = player.getLocation();
        for (int i = 0; i < 6; ++i) {
            fallingBlockLocations.add(this.getCircle(location, i, i * 6));
        }
        ((List)fallingBlockLocations.get(0)).add(player.getLocation());
        new GameRunnable(wp.getGame()){

            @Override
            public void run() {
                Iterator iterator = fallingBlockLocations.iterator();
                if (iterator.hasNext()) {
                    List fallingBlockLocation = (List)iterator.next();
                    for (Location location : fallingBlockLocation) {
                        if (location.getWorld().getBlockAt(location.clone().add(0.0, 1.0, 0.0)).getType() == Material.AIR) {
                            FallingBlock fallingBlock = GroundSlam.this.addFallingBlock(location.clone());
                            customFallingBlocks.add(new CustomFallingBlock(fallingBlock, wp, GroundSlam.this));
                            WarlordsEvents.addEntityUUID((Entity)fallingBlock);
                        }
                        for (WarlordsPlayer slamTarget : PlayerFilter.entitiesAroundRectangle(location.clone().add(0.0, -0.75, 0.0), 0.75, 4.5, 0.75).aliveEnemiesOf(wp).excluding(currentPlayersHit)) {
                            ++GroundSlam.this.playersHit;
                            if (slamTarget.hasFlag()) {
                                ++GroundSlam.this.carrierHit;
                            }
                            if (slamTarget.getCooldownManager().hasCooldown(TimeWarp.class) && FlagHolder.playerTryingToPick(slamTarget)) {
                                ++GroundSlam.this.warpsKnockbacked;
                            }
                            currentPlayersHit.add(slamTarget);
                            Location loc = slamTarget.getLocation();
                            Vector v = wp.getLocation().toVector().subtract(loc.toVector()).normalize().multiply(-1.25).setY(0.25);
                            slamTarget.setVelocity(v, false, false);
                            slamTarget.addDamageInstance(wp, GroundSlam.this.name, GroundSlam.this.minDamageHeal, GroundSlam.this.maxDamageHeal, GroundSlam.this.critChance, GroundSlam.this.critMultiplier, false);
                        }
                    }
                    fallingBlockLocations.remove(fallingBlockLocation);
                }
                if (fallingBlockLocations.isEmpty()) {
                    this.cancel();
                }
            }
        }.runTaskTimer(0L, 2L);
        new GameRunnable(wp.getGame()){

            @Override
            public void run() {
                for (int i = 0; i < customFallingBlocks.size(); ++i) {
                    CustomFallingBlock customFallingBlock = (CustomFallingBlock)customFallingBlocks.get(i);
                    customFallingBlock.setTicksLived(customFallingBlock.getTicksLived() + 1);
                    if (!(Utils.getDistance(customFallingBlock.getFallingBlock().getLocation(), 0.05) <= 0.25) && customFallingBlock.getTicksLived() <= 10) continue;
                    customFallingBlock.getFallingBlock().remove();
                    customFallingBlocks.remove(i);
                    --i;
                }
                if (fallingBlockLocations.isEmpty() && customFallingBlocks.isEmpty()) {
                    this.cancel();
                }
            }
        }.runTaskTimer(0L, 0L);
        return true;
    }

    private List<Location> getCircle(Location center, float radius, int amount) {
        World world = center.getWorld();
        double increment = Math.PI * 2 / (double)amount;
        ArrayList<Location> locations = new ArrayList<Location>();
        for (int i = 0; i < amount; ++i) {
            float angle = (float)((double)i * increment);
            float x = (float)(center.getX() + (double)radius * Math.cos(angle));
            float z = (float)(center.getZ() + (double)radius * Math.sin(angle));
            Location location = new Location(world, (double)x, center.getY(), (double)z);
            locations.add(location);
        }
        return locations;
    }

    private FallingBlock addFallingBlock(Location location) {
        if (location.getWorld().getBlockAt(location).getType() != Material.AIR) {
            location.add(0.0, 1.0, 0.0);
        }
        Location blockToGet = location.clone().add(0.0, -1.0, 0.0);
        if (location.getWorld().getBlockAt(location.clone().add(0.0, -1.0, 0.0)).getType() == Material.AIR) {
            blockToGet.add(0.0, -1.0, 0.0);
            if (location.getWorld().getBlockAt(location.clone().add(0.0, -2.0, 0.0)).getType() == Material.AIR) {
                blockToGet.add(0.0, -1.0, 0.0);
            }
        }
        Material type = location.getWorld().getBlockAt(blockToGet).getType();
        byte data = location.getWorld().getBlockAt(blockToGet).getData();
        if (type == Material.GRASS && (int)(Math.random() * 3.0) == 2) {
            type = Material.DIRT;
            data = 0;
        }
        FallingBlock fallingBlock = location.getWorld().spawnFallingBlock(location, type, data);
        fallingBlock.setVelocity(new Vector(0.0, 0.14, 0.0));
        fallingBlock.setDropItem(false);
        WarlordsEvents.addEntityUUID((Entity)fallingBlock);
        return fallingBlock;
    }
}

