/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.abilties;

import com.ebicep.warlords.abilties.internal.AbstractAbility;
import com.ebicep.warlords.effects.ParticleEffect;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.util.bukkit.LocationBuilder;
import com.ebicep.warlords.util.bukkit.Matrix4d;
import com.ebicep.warlords.util.java.Pair;
import com.ebicep.warlords.util.warlords.GameRunnable;
import com.ebicep.warlords.util.warlords.PlayerFilter;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class FreezingBreath
extends AbstractAbility {
    private final int slowDuration = 4;
    protected int playersHit = 0;

    public FreezingBreath() {
        super("Freezing Breath", 422.0f, 585.0f, 6.3f, 60, 20, 175);
    }

    @Override
    public List<Pair<String, String>> getAbilityInfo() {
        ArrayList<Pair<String, String>> info = new ArrayList<Pair<String, String>>();
        info.add(new Pair<String, String>("Times Used", "" + this.timesUsed));
        info.add(new Pair<String, String>("Players Hit", "" + this.playersHit));
        return info;
    }

    @Override
    public void updateDescription(Player player) {
        this.description = "\u00a77Breathe cold air in a cone in front\n\u00a77of you, dealing \u00a7c" + this.format(this.minDamageHeal) + " \u00a77- \u00a7c" + this.format(this.maxDamageHeal) + " \u00a77damage\n\u00a77to all enemies hit and slowing them by\n\u00a7e35% \u00a77for \u00a76" + 4 + " \u00a77seconds.";
    }

    @Override
    public boolean onActivate(@Nonnull WarlordsPlayer wp, final @Nonnull Player player) {
        wp.subtractEnergy(this.energyCost);
        Utils.playGlobalSound(player.getLocation(), "mage.freezingbreath.activation", 2.0f, 1.0f);
        final Location playerLoc = new LocationBuilder(player.getLocation()).pitch(0.0f).add(0.0, 1.7, 0.0);
        new GameRunnable(wp.getGame()){
            final Matrix4d center;
            int animationTimer;
            {
                super(game);
                this.center = new Matrix4d(playerLoc);
                this.animationTimer = 0;
            }

            @Override
            public void run() {
                this.playEffect();
                this.playEffect();
            }

            public void playEffect() {
                if (this.animationTimer > 12) {
                    this.cancel();
                }
                ParticleEffect.CLOUD.display(0.0f, 0.0f, 0.0f, 0.6f, 5, this.center.translateVector(player.getWorld(), (double)this.animationTimer / 2.0, 0.0, 0.0), 500.0);
                for (int i = 0; i < 4; ++i) {
                    double angle = Math.toRadians(i * 90) + (double)this.animationTimer * 0.15;
                    double width = (double)this.animationTimer * 0.3;
                    ParticleEffect.FIREWORKS_SPARK.display(0.0f, 0.0f, 0.0f, 0.0f, 1, this.center.translateVector(player.getWorld(), (double)this.animationTimer / 2.0, Math.sin(angle) * width, Math.cos(angle) * width), 500.0);
                }
                ++this.animationTimer;
            }
        }.runTaskTimer(0L, 1L);
        LocationBuilder hitbox = new LocationBuilder(player.getLocation()).pitch(0.0f).backward(1.0f);
        Vector viewDirection = playerLoc.getDirection();
        for (WarlordsPlayer breathTarget : PlayerFilter.entitiesAroundRectangle((Entity)player, 7.5, 10.0, 7.5).aliveEnemiesOf(wp)) {
            ++this.playersHit;
            Vector direction = breathTarget.getLocation().subtract((Location)hitbox).toVector().normalize();
            if (!(viewDirection.dot(direction) > 0.68)) continue;
            breathTarget.addDamageInstance(wp, this.name, this.minDamageHeal, this.maxDamageHeal, this.critChance, this.critMultiplier, false);
            breathTarget.getSpeed().addSpeedModifier("Freezing Breath", -35, 80, new String[0]);
        }
        return true;
    }
}

