/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.abilties;

import com.ebicep.warlords.abilties.internal.AbstractPiercingProjectileBase;
import com.ebicep.warlords.abilties.internal.AbstractProjectileBase;
import com.ebicep.warlords.effects.ParticleEffect;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.util.bukkit.Matrix4d;
import com.ebicep.warlords.util.java.Pair;
import com.ebicep.warlords.util.warlords.PlayerFilter;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Nullable;

public class FlameBurst
extends AbstractProjectileBase {
    private static final float HITBOX = 5.0f;

    public FlameBurst() {
        super("Flame Burst", 557.0f, 753.0f, 9.4f, 60, 25, 185, 1.65, 500.0, false);
    }

    @Override
    public void updateDescription(Player player) {
        this.description = "\u00a77Launch a flame burst that will explode\n\u00a77for \u00a7c" + this.format(this.minDamageHeal) + " \u00a77- \u00a7c" + this.format(this.maxDamageHeal) + " \u00a77damage. The critical\n\u00a77chance increases by \u00a7c1% \u00a77for each\n\u00a77travelled block. Up to 100%.";
    }

    @Override
    public List<Pair<String, String>> getAbilityInfo() {
        ArrayList<Pair<String, String>> info = new ArrayList<Pair<String, String>>();
        info.add(new Pair<String, String>("Times Used", "" + this.timesUsed));
        info.add(new Pair<String, String>("Players Hit", "" + this.playersHit));
        info.add(new Pair<String, String>("Dismounts", "" + this.numberOfDismounts));
        return info;
    }

    @Override
    protected void updateSpeed(Vector speedVector, int ticksLived) {
        speedVector.multiply(1.0275);
    }

    @Override
    protected String getActivationSound() {
        return "mage.fireball.activation";
    }

    @Override
    protected float getSoundPitch() {
        return 1.0f;
    }

    @Override
    protected float getSoundVolume() {
        return 2.0f;
    }

    @Override
    protected void playEffect(Location currentLocation, int ticksLived) {
        Matrix4d center = new Matrix4d(currentLocation);
        for (float i = 0.0f; i < 4.0f; i += 1.0f) {
            double angle = Math.toRadians(i * 90.0f) + (double)ticksLived * 0.45;
            double width = 0.24;
            ParticleEffect.FLAME.display(0.0f, 0.0f, 0.0f, 0.0f, 2, center.translateVector(currentLocation.getWorld(), 0.0, Math.sin(angle) * width, Math.cos(angle) * width), 500.0);
        }
    }

    @Override
    protected int onHit(@Nonnull AbstractPiercingProjectileBase.InternalProjectile projectile, @Nullable WarlordsPlayer hit) {
        WarlordsPlayer shooter = projectile.getShooter();
        Location startingLocation = projectile.getStartingLocation();
        Location currentLocation = projectile.getCurrentLocation();
        Utils.playGlobalSound(currentLocation, "mage.flameburst.impact", 2.0f, 1.0f);
        ParticleEffect.EXPLOSION_LARGE.display(0.0f, 0.0f, 0.0f, 0.5f, 2, currentLocation, 500.0);
        ParticleEffect.LAVA.display(0.5f, 0.0f, 0.5f, 2.0f, 10, currentLocation, 500.0);
        ParticleEffect.CLOUD.display(0.3f, 0.3f, 0.3f, 1.0f, 3, currentLocation, 500.0);
        int playersHit = 0;
        for (WarlordsPlayer nearEntity : PlayerFilter.entitiesAround(currentLocation, 5.0, 5.0, 5.0).aliveEnemiesOf(shooter)) {
            ++playersHit;
            if (nearEntity.onHorse()) {
                ++this.numberOfDismounts;
            }
            nearEntity.addDamageInstance(shooter, this.name, this.minDamageHeal, this.maxDamageHeal, this.critChance + (int)Math.pow(currentLocation.distanceSquared(startingLocation), 0.5), this.critMultiplier, false);
        }
        return playersHit;
    }
}

