/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.abilties;

import com.ebicep.warlords.abilties.internal.AbstractPiercingProjectileBase;
import com.ebicep.warlords.abilties.internal.AbstractProjectileBase;
import com.ebicep.warlords.effects.ParticleEffect;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.util.java.Pair;
import com.ebicep.warlords.util.warlords.PlayerFilter;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class Fireball
extends AbstractProjectileBase {
    private static final int MAX_FULL_DAMAGE_DISTANCE = 50;
    private static final double DIRECT_HIT_MULTIPLIER = 1.15;
    private static final float HITBOX = 4.0f;

    public Fireball() {
        super("Fireball", 334.4f, 433.4f, 0.0f, 70, 20, 175, 2.0, 300.0, false);
    }

    @Override
    public void updateDescription(Player player) {
        this.description = "\u00a77Shoot a fireball that will explode\n\u00a77for \u00a7c" + this.format(this.minDamageHeal) + " \u00a77- \u00a7c" + this.format(this.maxDamageHeal) + " \u00a77damage. A\n\u00a77direct hit will cause the enemy\n\u00a77to take an additional \u00a7c15% \u00a77extra\n\u00a77damage.\n\n\u00a77Has an optimal range of \u00a7e" + 50 + " \u00a77blocks.";
    }

    @Override
    public List<Pair<String, String>> getAbilityInfo() {
        ArrayList<Pair<String, String>> info = new ArrayList<Pair<String, String>>();
        info.add(new Pair<String, String>("Shots Fired", "" + this.timesUsed));
        info.add(new Pair<String, String>("Direct Hits", "" + this.directHits));
        info.add(new Pair<String, String>("Players Hit", "" + this.playersHit));
        info.add(new Pair<String, String>("Dismounts", "" + this.numberOfDismounts));
        return info;
    }

    @Override
    protected String getActivationSound() {
        return "mage.fireball.activation";
    }

    @Override
    protected float getSoundPitch() {
        return 1.0f;
    }

    @Override
    protected float getSoundVolume() {
        return 2.0f;
    }

    @Override
    protected void playEffect(@Nonnull Location currentLocation, int animationTimer) {
        ParticleEffect.DRIP_LAVA.display(0.0f, 0.0f, 0.0f, 0.35f, 5, currentLocation, 500.0);
        ParticleEffect.SMOKE_NORMAL.display(0.0f, 0.0f, 0.0f, 0.001f, 7, currentLocation, 500.0);
        ParticleEffect.FLAME.display(0.0f, 0.0f, 0.0f, 0.06f, 1, currentLocation, 500.0);
    }

    @Override
    protected void onSpawn(@Nonnull AbstractPiercingProjectileBase.InternalProjectile projectile) {
        super.onSpawn(projectile);
        this.playEffect(projectile);
    }

    @Override
    protected int onHit(@Nonnull AbstractPiercingProjectileBase.InternalProjectile projectile, @Nullable WarlordsPlayer hit) {
        double toReduceBy;
        WarlordsPlayer shooter = projectile.getShooter();
        Location startingLocation = projectile.getStartingLocation();
        Location currentLocation = projectile.getCurrentLocation();
        Utils.playGlobalSound(currentLocation, "mage.fireball.impact", 2.0f, 1.0f);
        ParticleEffect.EXPLOSION_LARGE.display(0.0f, 0.0f, 0.0f, 0.5f, 1, currentLocation, 500.0);
        ParticleEffect.LAVA.display(0.5f, 0.0f, 0.5f, 1.5f, 10, currentLocation, 500.0);
        ParticleEffect.CLOUD.display(0.3f, 0.3f, 0.3f, 1.0f, 3, currentLocation, 500.0);
        double distanceSquared = startingLocation.distanceSquared(currentLocation);
        double d = toReduceBy = 2500.0 > distanceSquared ? 1.0 : 1.0 - (Math.sqrt(distanceSquared) - 50.0) / 75.0;
        if (toReduceBy < 0.2) {
            toReduceBy = 0.2;
        }
        if (hit != null) {
            if (hit.onHorse()) {
                ++this.numberOfDismounts;
            }
            hit.addDamageInstance(shooter, this.name, (float)((double)this.minDamageHeal * 1.15 * toReduceBy), (float)((double)this.maxDamageHeal * 1.15 * toReduceBy), this.critChance, this.critMultiplier, false);
        }
        int playersHit = 0;
        for (WarlordsPlayer nearEntity : PlayerFilter.entitiesAround(currentLocation, 4.0, 4.0, 4.0).excluding(hit).aliveEnemiesOf(shooter)) {
            ++playersHit;
            if (nearEntity.onHorse()) {
                ++this.numberOfDismounts;
            }
            nearEntity.addDamageInstance(shooter, this.name, (float)((double)this.minDamageHeal * toReduceBy), (float)((double)this.maxDamageHeal * toReduceBy), this.critChance, this.critMultiplier, false);
        }
        return playersHit;
    }
}

