/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.abilties;

import com.ebicep.warlords.abilties.Soulbinding;
import com.ebicep.warlords.abilties.internal.AbstractAbility;
import com.ebicep.warlords.effects.ParticleEffect;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.player.cooldowns.CooldownFilter;
import com.ebicep.warlords.player.cooldowns.cooldowns.PersistentCooldown;
import com.ebicep.warlords.util.java.Pair;
import com.ebicep.warlords.util.warlords.GameRunnable;
import com.ebicep.warlords.util.warlords.PlayerFilter;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class FallenSouls
extends AbstractAbility {
    protected int playersHit = 0;
    protected int numberOfDismounts = 0;
    private static final float fallenSoulHitBox = 1.25f;
    private static final float fallenSoulSpeed = 2.0f;

    public FallenSouls() {
        super("Fallen Souls", 164.0f, 212.0f, 0.0f, 55, 20, 180);
    }

    @Override
    public void updateDescription(Player player) {
        this.description = "\u00a77Summon a wave of fallen souls, dealing\n\u00a7c" + this.format(this.minDamageHeal) + " \u00a77- \u00a7c" + this.format(this.maxDamageHeal) + " \u00a77damage to all enemies they\n\u00a77pass through. Each target hit reduces the\n\u00a77cooldown of Spirit Link by \u00a762 \u00a77seconds.";
    }

    @Override
    public List<Pair<String, String>> getAbilityInfo() {
        ArrayList<Pair<String, String>> info = new ArrayList<Pair<String, String>>();
        info.add(new Pair<String, String>("Times Used", "" + this.timesUsed));
        info.add(new Pair<String, String>("Players Hit", "" + this.playersHit));
        info.add(new Pair<String, String>("Dismounts", "" + this.numberOfDismounts));
        return info;
    }

    @Override
    public boolean onActivate(final WarlordsPlayer wp, Player player) {
        wp.subtractEnergy(this.energyCost);
        Utils.playGlobalSound(player.getLocation(), "shaman.lightningbolt.impact", 2.0f, 1.5f);
        Location location = player.getLocation();
        ArmorStand fallenSoulLeft = (ArmorStand)player.getWorld().spawn(location.clone().subtract(0.0, 0.5, 0.0).add(Utils.getLeftDirection(location).multiply(0.5)), ArmorStand.class);
        Location locationLeft = player.getLocation().add(player.getLocation().getDirection().multiply(0.2));
        locationLeft.setYaw(location.getYaw() - 13.0f);
        ArmorStand fallenSoulMiddle = (ArmorStand)player.getWorld().spawn(location.clone().subtract(0.0, 0.5, 0.0), ArmorStand.class);
        Location locationMiddle = player.getLocation().add(player.getLocation().getDirection().multiply(0.2));
        locationMiddle.setYaw(location.getYaw() - 0.0f);
        ArmorStand fallenSoulRight = (ArmorStand)player.getWorld().spawn(location.clone().subtract(0.0, 0.5, 0.0).add(Utils.getRightDirection(location).multiply(0.5)), ArmorStand.class);
        Location locationRight = player.getLocation().add(player.getLocation().getDirection().multiply(0.2));
        locationRight.setYaw(location.getYaw() + 13.0f);
        final FallenSoul fallenSoul = new FallenSoul(wp, fallenSoulLeft, fallenSoulMiddle, fallenSoulRight, player.getLocation(), player.getLocation(), player.getLocation(), locationLeft.getDirection(), locationMiddle.getDirection(), locationRight.getDirection(), this);
        new GameRunnable(wp.getGame()){

            @Override
            public void run() {
                if (fallenSoul.isLeftRemoved() && fallenSoul.isMiddleRemoved() && fallenSoul.isRightRemoved()) {
                    this.cancel();
                }
                ArmorStand leftSoul = fallenSoul.getFallenSoulLeft();
                ArmorStand middleSoul = fallenSoul.getFallenSoulMiddle();
                ArmorStand rightSoul = fallenSoul.getFallenSoulRight();
                leftSoul.teleport(leftSoul.getLocation().add(fallenSoul.getDirectionLeft().clone().multiply(2.0f)));
                middleSoul.teleport(middleSoul.getLocation().add(fallenSoul.getDirectionMiddle().clone().multiply(2.0f)));
                rightSoul.teleport(rightSoul.getLocation().add(fallenSoul.getDirectionRight().clone().multiply(2.0f)));
                List nearLeft = (List)leftSoul.getWorld().getNearbyEntities(leftSoul.getLocation().clone().add(0.0, 2.0, 0.0), 1.25, 1.0, 1.25);
                List nearMiddle = (List)middleSoul.getWorld().getNearbyEntities(middleSoul.getLocation().clone().add(0.0, 2.0, 0.0), 1.25, 1.0, 1.25);
                List nearRight = (List)rightSoul.getWorld().getNearbyEntities(rightSoul.getLocation().clone().add(0.0, 2.0, 0.0), 1.25, 1.0, 1.25);
                FallenSouls.this.damageNearByPlayers(nearLeft, wp, fallenSoul);
                FallenSouls.this.damageNearByPlayers(nearMiddle, wp, fallenSoul);
                FallenSouls.this.damageNearByPlayers(nearRight, wp, fallenSoul);
                ParticleEffect.SPELL_WITCH.display(0.0f, 0.0f, 0.0f, 0.0f, 1, leftSoul.getLocation().add(0.0, 1.5, 0.0), 500.0);
                ParticleEffect.SPELL_WITCH.display(0.0f, 0.0f, 0.0f, 0.0f, 1, middleSoul.getLocation().add(0.0, 1.5, 0.0), 500.0);
                ParticleEffect.SPELL_WITCH.display(0.0f, 0.0f, 0.0f, 0.0f, 1, rightSoul.getLocation().add(0.0, 1.5, 0.0), 500.0);
                if (!fallenSoul.isLeftRemoved() && leftSoul.getLocation().getWorld().getBlockAt(leftSoul.getLocation().clone().add(0.0, 2.0, 0.0)).getType() != Material.AIR || (double)fallenSoul.getFallenSoulLeft().getTicksLived() > 15.0) {
                    ParticleEffect.EXPLOSION_LARGE.display(0.0f, 0.0f, 0.0f, 0.7f, 1, leftSoul.getLocation().add(0.0, 1.0, 0.0), 500.0);
                    fallenSoul.getFallenSoulLeft().remove();
                    fallenSoul.setLeftRemoved(true);
                }
                if (!fallenSoul.isMiddleRemoved() && middleSoul.getLocation().getWorld().getBlockAt(middleSoul.getLocation().clone().add(0.0, 2.0, 0.0)).getType() != Material.AIR || (double)fallenSoul.getFallenSoulMiddle().getTicksLived() > 15.0) {
                    ParticleEffect.EXPLOSION_LARGE.display(0.0f, 0.0f, 0.0f, 0.7f, 1, middleSoul.getLocation().add(0.0, 1.0, 0.0), 500.0);
                    fallenSoul.getFallenSoulMiddle().remove();
                    fallenSoul.setMiddleRemoved(true);
                }
                if (!fallenSoul.isRightRemoved() && rightSoul.getLocation().getWorld().getBlockAt(rightSoul.getLocation().clone().add(0.0, 2.0, 0.0)).getType() != Material.AIR || (double)fallenSoul.getFallenSoulRight().getTicksLived() > 15.0) {
                    ParticleEffect.EXPLOSION_LARGE.display(0.0f, 0.0f, 0.0f, 0.7f, 1, rightSoul.getLocation().add(0.0, 1.0, 0.0), 500.0);
                    fallenSoul.getFallenSoulRight().remove();
                    fallenSoul.setRightRemoved(true);
                }
            }
        }.runTaskTimer(0L, 0L);
        return true;
    }

    public void damageNearByPlayers(List<Entity> near, WarlordsPlayer wp, FallenSoul fallenSoul) {
        for (WarlordsPlayer warlordsPlayer : PlayerFilter.entities(near).filter(p -> !fallenSoul.getPlayersHit().contains(p)).aliveEnemiesOf(wp)) {
            ++this.playersHit;
            if (warlordsPlayer.onHorse()) {
                ++this.numberOfDismounts;
            }
            warlordsPlayer.addDamageInstance(fallenSoul.getShooter(), fallenSoul.getFallenSouls().getName(), fallenSoul.getFallenSouls().getMinDamageHeal(), fallenSoul.getFallenSouls().getMaxDamageHeal(), fallenSoul.getFallenSouls().getCritChance(), fallenSoul.getFallenSouls().getCritMultiplier(), false);
            fallenSoul.getPlayersHit().add(warlordsPlayer);
            fallenSoul.getShooter().getSpec().getRed().subtractCooldown(2.0f);
            fallenSoul.getShooter().updateRedItem();
            new CooldownFilter<PersistentCooldown>(fallenSoul.getShooter(), PersistentCooldown.class).filterCooldownClassAndMapToObjectsOfClass(Soulbinding.class).filter(soulbinding -> soulbinding.hasBoundPlayerSoul(warlordsPlayer)).forEachOrdered(soulbinding -> {
                fallenSoul.getShooter().doOnStaticAbility(Soulbinding.class, Soulbinding::addSoulProcs);
                fallenSoul.getShooter().getSpec().getRed().subtractCooldown(1.5f);
                fallenSoul.getShooter().getSpec().getPurple().subtractCooldown(1.5f);
                fallenSoul.getShooter().getSpec().getBlue().subtractCooldown(1.5f);
                fallenSoul.getShooter().getSpec().getOrange().subtractCooldown(1.5f);
                fallenSoul.getShooter().updateRedItem();
                fallenSoul.getShooter().updatePurpleItem();
                fallenSoul.getShooter().updateBlueItem();
                fallenSoul.getShooter().updateOrangeItem();
                for (WarlordsPlayer warlordsPlayer1 : PlayerFilter.entitiesAround(wp.getLocation(), 8.0, 8.0, 8.0).aliveTeammatesOfExcludingSelf(wp).closestFirst(wp.getLocation()).limit(2L)) {
                    fallenSoul.getShooter().doOnStaticAbility(Soulbinding.class, Soulbinding::addSoulTeammatesCDReductions);
                    warlordsPlayer1.getSpec().getRed().subtractCooldown(1.0f);
                    warlordsPlayer1.getSpec().getPurple().subtractCooldown(1.0f);
                    warlordsPlayer1.getSpec().getBlue().subtractCooldown(1.0f);
                    warlordsPlayer1.getSpec().getOrange().subtractCooldown(1.0f);
                    warlordsPlayer1.updateRedItem();
                    warlordsPlayer1.updatePurpleItem();
                    warlordsPlayer1.updateBlueItem();
                    warlordsPlayer1.updateOrangeItem();
                }
            });
        }
    }

    public static class FallenSoul {
        private WarlordsPlayer shooter;
        private ArmorStand fallenSoulLeft;
        private ArmorStand fallenSoulMiddle;
        private ArmorStand fallenSoulRight;
        private Location locationLeft;
        private Location locationMiddle;
        private Location locationRight;
        private Vector directionLeft;
        private Vector directionMiddle;
        private Vector directionRight;
        private boolean leftRemoved;
        private boolean middleRemoved;
        private boolean rightRemoved;
        private FallenSouls fallenSouls;
        private List<WarlordsPlayer> playersHit;

        public FallenSoul(WarlordsPlayer shooter, ArmorStand fallenSoulLeft, ArmorStand fallenSoulMiddle, ArmorStand fallenSoulRight, Location locationLeft, Location locationMiddle, Location locationRight, Vector directionLeft, Vector directionMiddle, Vector directionRight, FallenSouls fallenSouls) {
            this.shooter = shooter;
            this.fallenSoulLeft = fallenSoulLeft;
            fallenSoulLeft.setHelmet(new ItemStack(Material.ACACIA_FENCE_GATE));
            fallenSoulLeft.setGravity(false);
            fallenSoulLeft.setVisible(false);
            fallenSoulLeft.setMarker(true);
            fallenSoulLeft.setHeadPose(new EulerAngle(directionLeft.getY() * -2.0, -0.2, 0.0));
            this.fallenSoulMiddle = fallenSoulMiddle;
            fallenSoulMiddle.setHelmet(new ItemStack(Material.ACACIA_FENCE_GATE));
            fallenSoulMiddle.setGravity(false);
            fallenSoulMiddle.setVisible(false);
            fallenSoulMiddle.setMarker(true);
            fallenSoulMiddle.setHeadPose(new EulerAngle(directionMiddle.getY() * -2.0, 0.0, 0.0));
            this.fallenSoulRight = fallenSoulRight;
            fallenSoulRight.setHelmet(new ItemStack(Material.ACACIA_FENCE_GATE));
            fallenSoulRight.setGravity(false);
            fallenSoulRight.setVisible(false);
            fallenSoulRight.setMarker(true);
            fallenSoulRight.setHeadPose(new EulerAngle(directionRight.getY() * -2.0, 0.2, 0.0));
            this.locationLeft = locationLeft;
            this.locationMiddle = locationMiddle;
            this.locationRight = locationRight;
            this.directionLeft = directionLeft;
            this.directionMiddle = directionMiddle;
            this.directionRight = directionRight;
            this.fallenSouls = fallenSouls;
            this.leftRemoved = false;
            this.middleRemoved = false;
            this.rightRemoved = false;
            this.playersHit = new ArrayList<WarlordsPlayer>();
            this.playersHit.add(shooter);
        }

        public WarlordsPlayer getShooter() {
            return this.shooter;
        }

        public void setShooter(WarlordsPlayer shooter) {
            this.shooter = shooter;
        }

        public ArmorStand getFallenSoulLeft() {
            return this.fallenSoulLeft;
        }

        public void setFallenSoulLeft(ArmorStand fallenSoulLeft) {
            this.fallenSoulLeft = fallenSoulLeft;
        }

        public ArmorStand getFallenSoulMiddle() {
            return this.fallenSoulMiddle;
        }

        public void setFallenSoulMiddle(ArmorStand fallenSoulMiddle) {
            this.fallenSoulMiddle = fallenSoulMiddle;
        }

        public ArmorStand getFallenSoulRight() {
            return this.fallenSoulRight;
        }

        public void setFallenSoulRight(ArmorStand fallenSoulRight) {
            this.fallenSoulRight = fallenSoulRight;
        }

        public Location getLocationLeft() {
            return this.locationLeft;
        }

        public void setLocationLeft(Location locationLeft) {
            this.locationLeft = locationLeft;
        }

        public Location getLocationMiddle() {
            return this.locationMiddle;
        }

        public void setLocationMiddle(Location locationMiddle) {
            this.locationMiddle = locationMiddle;
        }

        public Location getLocationRight() {
            return this.locationRight;
        }

        public void setLocationRight(Location locationRight) {
            this.locationRight = locationRight;
        }

        public Vector getDirectionLeft() {
            return this.directionLeft;
        }

        public void setDirectionLeft(Vector directionLeft) {
            this.directionLeft = directionLeft;
        }

        public Vector getDirectionMiddle() {
            return this.directionMiddle;
        }

        public void setDirectionMiddle(Vector directionMiddle) {
            this.directionMiddle = directionMiddle;
        }

        public Vector getDirectionRight() {
            return this.directionRight;
        }

        public void setDirectionRight(Vector directionRight) {
            this.directionRight = directionRight;
        }

        public FallenSouls getFallenSouls() {
            return this.fallenSouls;
        }

        public void setFallenSouls(FallenSouls fallenSouls) {
            this.fallenSouls = fallenSouls;
        }

        public boolean isLeftRemoved() {
            return this.leftRemoved;
        }

        public void setLeftRemoved(boolean leftRemoved) {
            this.leftRemoved = leftRemoved;
        }

        public boolean isMiddleRemoved() {
            return this.middleRemoved;
        }

        public void setMiddleRemoved(boolean middleRemoved) {
            this.middleRemoved = middleRemoved;
        }

        public boolean isRightRemoved() {
            return this.rightRemoved;
        }

        public void setRightRemoved(boolean rightRemoved) {
            this.rightRemoved = rightRemoved;
        }

        public List<WarlordsPlayer> getPlayersHit() {
            return this.playersHit;
        }

        public void setPlayersHit(List<WarlordsPlayer> playersHit) {
            this.playersHit = playersHit;
        }
    }
}

