/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.abilties;

import com.ebicep.warlords.abilties.internal.AbstractAbility;
import com.ebicep.warlords.effects.ParticleEffect;
import com.ebicep.warlords.events.WarlordsDamageHealingEvent;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.player.cooldowns.CooldownTypes;
import com.ebicep.warlords.player.cooldowns.cooldowns.RegularCooldown;
import com.ebicep.warlords.util.java.Pair;
import com.ebicep.warlords.util.java.TriConsumer;
import com.ebicep.warlords.util.warlords.PlayerFilter;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;

public class Earthliving
extends AbstractAbility {
    private final int duration = 8;
    protected int timesProcd = 0;
    protected int playersHealed = 0;
    private int procChance = 40;

    public Earthliving() {
        super("Earthliving Weapon", 0.0f, 0.0f, 15.66f, 30, 25, 200);
    }

    @Override
    public void updateDescription(Player player) {
        this.description = "\u00a77Imbue your weapon with the power of the\n\u00a77Earth, causing each of your melee attacks\n\u00a77to have a \u00a7e" + this.procChance + "% \u00a77chance to heal you and \u00a7e2\n\u00a77nearby allies for \u00a7a240% \u00a77weapon damage.\n\u00a77Lasts \u00a76" + 8 + " \u00a77seconds.\n\n\u00a77The first hit is guaranteed to activate Earthliving.";
    }

    @Override
    public List<Pair<String, String>> getAbilityInfo() {
        ArrayList<Pair<String, String>> info = new ArrayList<Pair<String, String>>();
        info.add(new Pair<String, String>("Times Used", "" + this.timesUsed));
        info.add(new Pair<String, String>("Times Proc'd", "" + this.timesProcd));
        info.add(new Pair<String, String>("Players Healed", "" + this.playersHealed));
        return info;
    }

    @Override
    public boolean onActivate(WarlordsPlayer wp, Player player) {
        wp.subtractEnergy(this.energyCost);
        Utils.playGlobalSound(player.getLocation(), "shaman.earthlivingweapon.activation", 2.0f, 1.0f);
        Earthliving tempEarthliving = new Earthliving();
        final boolean[] firstProc = new boolean[]{true};
        wp.getCooldownManager().addCooldown(new RegularCooldown<Earthliving>(this.name, "EARTH", Earthliving.class, tempEarthliving, wp, CooldownTypes.ABILITY, cooldownManager -> {}, 160, new TriConsumer[]{(cooldown, ticksLeft, counter) -> {
            if (counter % 4 == 0) {
                ParticleEffect.VILLAGER_HAPPY.display(0.3f, 0.3f, 0.3f, 0.1f, 2, wp.getLocation().add(0.0, 1.2, 0.0), 500.0);
            }
        }}){

            @Override
            public void onEndFromAttacker(WarlordsDamageHealingEvent event, float currentDamageValue, boolean isCrit) {
                if (event.getAbility().isEmpty()) {
                    WarlordsPlayer victim = event.getPlayer();
                    WarlordsPlayer attacker = event.getAttacker();
                    int earthlivingActivate = (int)(Math.random() * 100.0);
                    if (firstProc[0]) {
                        firstProc[0] = false;
                        earthlivingActivate = 0;
                    }
                    if (earthlivingActivate < Earthliving.this.procChance) {
                        ++Earthliving.this.timesProcd;
                        Utils.playGlobalSound(victim.getLocation(), "shaman.earthlivingweapon.impact", 2.0f, 1.0f);
                        attacker.addHealingInstance(attacker, this.name, 316.80002f, 429.6f, Earthliving.this.critChance, Earthliving.this.critMultiplier, false, false);
                        for (WarlordsPlayer nearPlayer : PlayerFilter.entitiesAround(attacker, 6.0, 6.0, 6.0).aliveTeammatesOfExcludingSelf(attacker).limit(2L)) {
                            ++Earthliving.this.playersHealed;
                            nearPlayer.addHealingInstance(attacker, this.name, 316.80002f, 429.6f, Earthliving.this.critChance, Earthliving.this.critMultiplier, false, false);
                        }
                    }
                }
            }
        });
        return true;
    }

    public int getProcChance() {
        return this.procChance;
    }

    public void setProcChance(int procChance) {
        this.procChance = procChance;
    }
}

