/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.abilties;

import com.ebicep.warlords.Warlords;
import com.ebicep.warlords.abilties.internal.AbstractAbility;
import com.ebicep.warlords.classes.AbstractPlayerClass;
import com.ebicep.warlords.events.WarlordsEvents;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.util.java.Pair;
import com.ebicep.warlords.util.warlords.GameRunnable;
import com.ebicep.warlords.util.warlords.PlayerFilter;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class EarthenSpike
extends AbstractAbility {
    protected int playersSpiked = 0;
    protected int carrierSpiked = 0;
    private final int radius = 10;
    private static final String[] REPEATING_SOUND = new String[]{"shaman.earthenspike.animation.a", "shaman.earthenspike.animation.b", "shaman.earthenspike.animation.c", "shaman.earthenspike.animation.d"};

    public EarthenSpike() {
        super("Earthen Spike", 404.0f, 562.0f, 0.0f, 100, 15, 175);
    }

    @Override
    public void updateDescription(Player player) {
        this.description = "\u00a77Send forth an underground earth spike\n\u00a77that locks onto a targeted enemy player.\n\u00a77When the spike reaches its target it\n\u00a77emerges from the ground, dealing \u00a7c" + this.format(this.minDamageHeal) + " \u00a77-\n\u00a7c" + this.format(this.maxDamageHeal) + " \u00a77damage to any nearby enemies and\n\u00a77launches them up into the air.\n\n\u00a77Has an initial cast range of \u00a7e" + 10 + " \u00a77blocks.";
    }

    @Override
    public List<Pair<String, String>> getAbilityInfo() {
        ArrayList<Pair<String, String>> info = new ArrayList<Pair<String, String>>();
        info.add(new Pair<String, String>("Times Used", "" + this.timesUsed));
        info.add(new Pair<String, String>("Players Spiked", "" + this.playersSpiked));
        info.add(new Pair<String, String>("Times Carrier Spiked", "" + this.carrierSpiked));
        return info;
    }

    @Override
    public boolean onActivate(final @Nonnull WarlordsPlayer wp, @Nonnull Player player) {
        final Location location = player.getLocation();
        for (WarlordsPlayer spikeTarget : PlayerFilter.entitiesAround(wp, 10.0, 10.0, 10.0).aliveEnemiesOf(wp).lookingAtFirst(wp)) {
            if (!Utils.isLookingAt((LivingEntity)player, spikeTarget.getEntity()) || !Utils.hasLineOfSight((LivingEntity)player, spikeTarget.getEntity())) continue;
            this.addTimesUsed();
            AbstractPlayerClass.sendRightClickPacket(player);
            FallingBlock block = this.spawnFallingBlock(location, location);
            final EarthenSpikeBlock earthenSpikeBlock = new EarthenSpikeBlock(new CustomFallingBlock(block, block.getLocation().getY() - 0.2), spikeTarget, wp);
            wp.subtractEnergy(this.energyCost);
            new GameRunnable(wp.getGame()){
                private final float SPEED = 1.0f;
                private final float SPEED_SQUARED = 1.0f;
                private final Location spikeLoc;
                {
                    super(game);
                    this.SPEED = 1.0f;
                    this.SPEED_SQUARED = 1.0f;
                    this.spikeLoc = location;
                    this.spikeLoc.setY((double)this.spikeLoc.getBlockY());
                }

                @Override
                public void run() {
                    earthenSpikeBlock.addDuration();
                    List<CustomFallingBlock> customFallingBlocks = earthenSpikeBlock.getFallingBlocks();
                    WarlordsPlayer target = earthenSpikeBlock.getTarget();
                    WarlordsPlayer user = earthenSpikeBlock.getUser();
                    if (earthenSpikeBlock.getDuration() % 5 == 1) {
                        Utils.playGlobalSound(this.spikeLoc, REPEATING_SOUND[earthenSpikeBlock.getDuration() / 5 % 4], 2.0f, 1.0f);
                    }
                    if (earthenSpikeBlock.getDuration() > 30) {
                        earthenSpikeBlock.setDuration(-1);
                        this.cancel();
                        return;
                    }
                    Vector change = target.getLocation().toVector().subtract(this.spikeLoc.toVector());
                    change.setY(0);
                    double length = change.lengthSquared();
                    if (length > 1.0) {
                        int j;
                        change.multiply(1.0 / (Math.sqrt(length) / 1.0));
                        this.spikeLoc.add(change);
                        if (target.getLocation().getY() < this.spikeLoc.getY()) {
                            for (j = 0; j < 10 && this.spikeLoc.clone().add(0.0, -1.0, 0.0).getBlock().getType() == Material.AIR; ++j) {
                                this.spikeLoc.add(0.0, -1.0, 0.0);
                            }
                        } else {
                            for (j = 0; j < 10 && this.spikeLoc.getBlock().getType() != Material.AIR; ++j) {
                                this.spikeLoc.add(0.0, 1.0, 0.0);
                            }
                        }
                        for (int i = 0; i < 10 && this.spikeLoc.getBlock().getType() != Material.AIR; ++i) {
                            this.spikeLoc.add(0.0, 1.0, 0.0);
                        }
                        FallingBlock newBlock = EarthenSpike.this.spawnFallingBlock(this.spikeLoc, this.spikeLoc);
                        customFallingBlocks.add(new CustomFallingBlock(newBlock, newBlock.getLocation().getY() - 0.2));
                    } else {
                        Location targetLocation = target.getLocation();
                        for (WarlordsPlayer spikeTarget : PlayerFilter.entitiesAround(targetLocation, 2.5, 2.5, 2.5).aliveEnemiesOf(wp)) {
                            ++EarthenSpike.this.playersSpiked;
                            if (spikeTarget.hasFlag()) {
                                ++EarthenSpike.this.carrierSpiked;
                            }
                            spikeTarget.addDamageInstance(user, EarthenSpike.this.name, EarthenSpike.this.minDamageHeal, EarthenSpike.this.maxDamageHeal, EarthenSpike.this.critChance, EarthenSpike.this.critMultiplier, false);
                            if (!(Utils.getDistance((Entity)spikeTarget.getEntity(), 0.1) < 1.82)) continue;
                            spikeTarget.setVelocity(new Vector(0.0, 0.625, 0.0), false);
                        }
                        Utils.playGlobalSound(wp.getLocation(), "shaman.earthenspike.impact", 2.0f, 1.0f);
                        targetLocation.setYaw(0.0f);
                        for (int i = 0; i < 100 && targetLocation.clone().add(0.0, -1.0, 0.0).getBlock().getType() == Material.AIR; ++i) {
                            targetLocation.add(0.0, -1.0, 0.0);
                        }
                        final ArmorStand stand = (ArmorStand)targetLocation.getWorld().spawnEntity(targetLocation.add(0.0, -0.6, 0.0), EntityType.ARMOR_STAND);
                        stand.setHelmet(new ItemStack(Material.BROWN_MUSHROOM));
                        stand.setGravity(false);
                        stand.setVisible(false);
                        stand.setMarker(true);
                        new BukkitRunnable(){

                            public void run() {
                                stand.remove();
                                this.cancel();
                            }
                        }.runTaskTimer((Plugin)Warlords.getInstance(), 10L, 0L);
                        earthenSpikeBlock.setDuration(-1);
                        this.cancel();
                    }
                    if (target.isDead()) {
                        earthenSpikeBlock.setDuration(-1);
                        this.cancel();
                    }
                }
            }.runTaskTimer(0L, 2L);
            new GameRunnable(wp.getGame()){

                @Override
                public void run() {
                    for (CustomFallingBlock fallingBlock : earthenSpikeBlock.getFallingBlocks()) {
                        FallingBlock block = fallingBlock.getBlock();
                        if (!block.isValid() || !(block.getLocation().getY() <= fallingBlock.getyLevelToRemove())) continue;
                        block.remove();
                        earthenSpikeBlock.addRemoved();
                    }
                    if (earthenSpikeBlock.getDuration() == -1 && earthenSpikeBlock.getRemoved() == earthenSpikeBlock.getFallingBlocks().size()) {
                        this.cancel();
                    }
                }
            }.runTaskTimer(0L, 0L);
            break;
        }
        return true;
    }

    private FallingBlock spawnFallingBlock(Location location, Location blockTypeAndData) {
        Location spawnLocation = location.clone();
        for (int i = 0; i < 100 && spawnLocation.getBlock().getType() != Material.AIR; ++i) {
            spawnLocation.add(0.0, 1.0, 0.0);
        }
        FallingBlock newBlock = spawnLocation.getWorld().spawnFallingBlock(spawnLocation, blockTypeAndData.clone().add(0.0, -1.0, 0.0).getBlock().getType(), blockTypeAndData.clone().add(0.0, -1.0, 0.0).getBlock().getData());
        newBlock.setVelocity(new Vector(0.0, 0.25, 0.0));
        newBlock.setDropItem(false);
        WarlordsEvents.addEntityUUID((Entity)newBlock);
        return newBlock;
    }

    public class CustomFallingBlock {
        private FallingBlock block;
        private double yLevelToRemove;

        public CustomFallingBlock(FallingBlock block, double yLevelToRemove) {
            this.block = block;
            this.yLevelToRemove = yLevelToRemove;
        }

        public FallingBlock getBlock() {
            return this.block;
        }

        public void setBlock(FallingBlock block) {
            this.block = block;
        }

        public double getyLevelToRemove() {
            return this.yLevelToRemove;
        }

        public void setyLevelToRemove(double yLevelToRemove) {
            this.yLevelToRemove = yLevelToRemove;
        }
    }

    public class EarthenSpikeBlock {
        private List<CustomFallingBlock> fallingBlocks = new ArrayList<CustomFallingBlock>();
        private final WarlordsPlayer target;
        private final WarlordsPlayer user;
        private int duration;
        private int removed;

        public EarthenSpikeBlock(CustomFallingBlock block, WarlordsPlayer target, WarlordsPlayer user) {
            this.fallingBlocks.add(block);
            this.target = target;
            this.user = user;
            this.duration = 0;
            this.removed = 0;
        }

        public WarlordsPlayer getTarget() {
            return this.target;
        }

        public WarlordsPlayer getUser() {
            return this.user;
        }

        public List<CustomFallingBlock> getFallingBlocks() {
            return this.fallingBlocks;
        }

        public void setFallingBlocks(List<CustomFallingBlock> fallingBlocks) {
            this.fallingBlocks = fallingBlocks;
        }

        public void addDuration() {
            ++this.duration;
        }

        public int getDuration() {
            return this.duration;
        }

        public void addRemoved() {
            ++this.removed;
        }

        public int getRemoved() {
            return this.removed;
        }

        public void setDuration(int duration) {
            this.duration = duration;
        }
    }
}

