/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.abilties;

import com.ebicep.warlords.abilties.ImpalingStrike;
import com.ebicep.warlords.abilties.internal.AbstractAbility;
import com.ebicep.warlords.effects.EffectUtils;
import com.ebicep.warlords.effects.FireWorkEffectPlayer;
import com.ebicep.warlords.effects.ParticleEffect;
import com.ebicep.warlords.events.WarlordsDamageHealingEvent;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.player.cooldowns.CooldownTypes;
import com.ebicep.warlords.player.cooldowns.cooldowns.RegularCooldown;
import com.ebicep.warlords.util.java.Pair;
import com.ebicep.warlords.util.warlords.PlayerFilter;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Sound;
import org.bukkit.entity.Player;

public class DrainingMiasma
extends AbstractAbility {
    private final int duration = 5;
    private final int maxHealthDamage = 4;
    protected int playersHit = 0;
    private int leechDuration = 5;
    private int enemyHitRadius = 8;

    public DrainingMiasma() {
        super("Draining Miasma", 0.0f, 0.0f, 50.0f, 40, -1, 100);
    }

    @Override
    public void updateDescription(Player player) {
        this.description = "\u00a77Summon a toxin-filled cloud around you,\n\u00a77poisoning all enemies inside the area. Poisoned\n\u00a77enemies take \u00a7c50 \u00a77+ \u00a7c4% \u00a77of their max health as\n\u00a77damage per second, for \u00a765 \u00a77seconds. Enemies\n\u00a77poisoned by your Draining Miasma are slowed by\n\u00a7e25% \u00a77for \u00a763 \u00a77seconds on cast.\n\n\u00a77Each enemy hit will be afflicted with \u00a7aLEECH \u00a77for\n\u00a76" + this.leechDuration + " \u00a77seconds.";
    }

    @Override
    public List<Pair<String, String>> getAbilityInfo() {
        ArrayList<Pair<String, String>> info = new ArrayList<Pair<String, String>>();
        info.add(new Pair<String, String>("Times Used", "" + this.timesUsed));
        info.add(new Pair<String, String>("Players Hit", "" + this.playersHit));
        return info;
    }

    @Override
    public boolean onActivate(final @Nonnull WarlordsPlayer wp, @Nonnull Player player) {
        wp.subtractEnergy(this.energyCost);
        Utils.playGlobalSound(player.getLocation(), "rogue.drainingmiasma.activation", 2.0f, 1.7f);
        Utils.playGlobalSound(player.getLocation(), "shaman.earthlivingweapon.activation", 2.0f, 0.65f);
        EffectUtils.playSphereAnimation(player, 6.0, ParticleEffect.SLIME, 1);
        FireWorkEffectPlayer.playFirework(wp.getLocation(), FireworkEffect.builder().withColor(Color.LIME).with(FireworkEffect.Type.BALL_LARGE).build());
        DrainingMiasma tempDrainingMiasma = new DrainingMiasma();
        for (WarlordsPlayer miasmaTarget : PlayerFilter.entitiesAround(wp, (double)this.getEnemyHitRadius(), (double)this.getEnemyHitRadius(), (double)this.getEnemyHitRadius()).aliveEnemiesOf(wp)) {
            Runnable cancelSlowness = miasmaTarget.getSpeed().addSpeedModifier("Draining Miasma Slow", -25, 60, "BASE");
            miasmaTarget.getCooldownManager().addRegularCooldown(this.name, "MIAS", DrainingMiasma.class, tempDrainingMiasma, wp, CooldownTypes.ABILITY, cooldownManager -> cancelSlowness.run(), 100, (cooldown, ticksLeft, counter) -> {
                if (counter % 20 == 0) {
                    Utils.playGlobalSound(miasmaTarget.getLocation(), Sound.DIG_SNOW, 2.0f, 0.4f);
                    for (int i = 0; i < 3; ++i) {
                        ParticleEffect.REDSTONE.display((ParticleEffect.ParticleColor)new ParticleEffect.OrdinaryColor(30, 200, 30), miasmaTarget.getLocation().clone().add(Math.random() * 2.0 - 1.0, 1.2 + Math.random() * 2.0 - 1.0, Math.random() * 2.0 - 1.0), 500.0);
                    }
                    float healthDamage = (float)(miasmaTarget.getMaxHealth() * 4) / 100.0f;
                    miasmaTarget.addDamageInstance(wp, this.name, 50.0f + healthDamage, 50.0f + healthDamage, -1, 100, false);
                }
            });
            miasmaTarget.getCooldownManager().removeCooldown(ImpalingStrike.class);
            miasmaTarget.getCooldownManager().addCooldown(new RegularCooldown<ImpalingStrike>("Leech Debuff", "LCH", ImpalingStrike.class, new ImpalingStrike(), wp, CooldownTypes.DEBUFF, cooldownManager -> {}, this.leechDuration * 20){

                @Override
                public void onDamageFromSelf(WarlordsDamageHealingEvent event, float currentDamageValue, boolean isCrit) {
                    float healingMultiplier = event.getAttacker() == wp ? 0.25f : 0.15f;
                    event.getAttacker().addHealingInstance(wp, "Leech", currentDamageValue * healingMultiplier, currentDamageValue * healingMultiplier, -1, 100, false, false).ifPresent(warlordsDamageHealingFinalEvent -> {
                        if (event.getPlayer().hasFlag()) {
                            ((ImpalingStrike)this.getCooldownObject()).addHealingDoneFromEnemyCarrier(warlordsDamageHealingFinalEvent.getValue());
                        }
                    });
                }
            });
        }
        return true;
    }

    public int getEnemyHitRadius() {
        return this.enemyHitRadius;
    }

    public void setEnemyHitRadius(int enemyHitRadius) {
        this.enemyHitRadius = enemyHitRadius;
    }

    public int getLeechDuration() {
        return this.leechDuration;
    }

    public void setLeechDuration(int leechDuration) {
        this.leechDuration = leechDuration;
    }
}

