/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.abilties;

import com.ebicep.warlords.Warlords;
import com.ebicep.warlords.abilties.Repentance;
import com.ebicep.warlords.abilties.SpiritLink;
import com.ebicep.warlords.abilties.internal.AbstractTotemBase;
import com.ebicep.warlords.effects.EffectPlayer;
import com.ebicep.warlords.effects.ParticleEffect;
import com.ebicep.warlords.effects.circle.CircleEffect;
import com.ebicep.warlords.effects.circle.CircumferenceEffect;
import com.ebicep.warlords.effects.circle.DoubleLineEffect;
import com.ebicep.warlords.events.WarlordsDamageHealingEvent;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.player.cooldowns.CooldownFilter;
import com.ebicep.warlords.player.cooldowns.CooldownTypes;
import com.ebicep.warlords.player.cooldowns.cooldowns.RegularCooldown;
import com.ebicep.warlords.util.java.Pair;
import com.ebicep.warlords.util.java.TriConsumer;
import com.ebicep.warlords.util.warlords.PlayerFilter;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class DeathsDebt
extends AbstractTotemBase {
    protected int playersDamaged = 0;
    protected int playersHealed = 0;
    private int respiteRadius = 10;
    private int debtRadius = 8;
    private float delayedDamage = 0.0f;
    private float selfDamageInPercentPerSecond = 0.1667f;
    private boolean inDebt = false;
    private boolean playerInRadius = true;

    public DeathsDebt() {
        super("Death's Debt", 0.0f, 0.0f, 70.49f, 20, -1, 100);
    }

    public DeathsDebt(ArmorStand totem, WarlordsPlayer owner) {
        super("Death's Debt", 0.0f, 0.0f, 70.49f, 20, -1, 100, totem, owner);
    }

    @Override
    public void updateDescription(Player player) {
        int selfDamagePercent = this.selfDamageInPercentPerSecond == 0.1667f ? 100 : 75;
        this.description = "\u00a72Spirits\u2019 Respite\u00a77: Place down a totem that\n\u00a77delays \u00a7c100% \u00a77of incoming damage towards\n\u00a77yourself. Transforms into \u00a7dDeath\u2019s Debt \u00a77after\n\u00a764 \u00a77- \u00a766 \u00a77seconds (increases with higher health),\n\u00a77or when you exit its \u00a7e" + this.respiteRadius + " \u00a77block radius.\n\n\u00a7dDeath\u2019s Debt\u00a77: Take \u00a7c" + selfDamagePercent + "% \u00a77of the damage delayed\n\u00a77by \u00a72Spirit's Respite \u00a77over \u00a766 \u00a77seconds. The totem\n\u00a77will heal nearby allies for \u00a7a15% \u00a77of all damage\n\u00a77that you take. If you survive, deal \u00a7c15% \u00a77of the\n\n\u00a77Successful Soulbind procs on enemies add \u00a760.5 \u00a77seconds\n\u00a77to your totem duration. (cap of \u00a766 \u00a77seconds)";
    }

    @Override
    public List<Pair<String, String>> getAbilityInfo() {
        ArrayList<Pair<String, String>> info = new ArrayList<Pair<String, String>>();
        info.add(new Pair<String, String>("Times Used", "" + this.timesUsed));
        info.add(new Pair<String, String>("Players Damaged", "" + this.playersDamaged));
        info.add(new Pair<String, String>("Players Healed", "" + this.playersHealed));
        return info;
    }

    @Override
    protected ItemStack getTotemItemStack() {
        return new ItemStack(Material.JUNGLE_FENCE_GATE);
    }

    @Override
    protected void playSound(Player player, Location location) {
        Utils.playGlobalSound(location, "shaman.chainlightning.impact", 2.0f, 2.0f);
    }

    @Override
    protected void onActivation(WarlordsPlayer wp, Player player, ArmorStand totemStand) {
        int duration = (4 + 2 * (int)Math.round((double)wp.getHealth() / (double)wp.getMaxHealth())) * 20;
        CircleEffect circle = new CircleEffect(wp, totemStand.getLocation().clone().add(0.0, 1.25, 0.0), this.respiteRadius, new CircumferenceEffect(ParticleEffect.SPELL), new DoubleLineEffect(ParticleEffect.REDSTONE));
        BukkitTask effectTask = Bukkit.getScheduler().runTaskTimer((Plugin)Warlords.getInstance(), circle::playEffects, 0L, 1L);
        final DeathsDebt tempDeathsDebt = new DeathsDebt(totemStand, wp);
        wp.getCooldownManager().addCooldown(new RegularCooldown<DeathsDebt>("Spirits Respite", "RESP", DeathsDebt.class, tempDeathsDebt, wp, CooldownTypes.ABILITY, cooldownManagerRespite -> {
            if (wp.isDead() || wp.getWorld() != totemStand.getWorld()) {
                totemStand.remove();
                effectTask.cancel();
                return;
            }
            tempDeathsDebt.setInDebt(true);
            if (!tempDeathsDebt.isPlayerInRadius()) {
                wp.sendMessage("\u00a77You walked outside your \u00a7dDeath's Debt \u00a77radius");
            } else {
                wp.sendMessage(WarlordsPlayer.RECEIVE_ARROW_RED + " \u00a72Spirit's Respite \u00a77delayed \u00a7c" + Math.round(tempDeathsDebt.getDelayedDamage()) + " \u00a77damage. \u00a7dYour debt must now be paid.");
            }
            wp.getCooldownManager().addCooldown(new RegularCooldown<DeathsDebt>(this.name, "DEBT", DeathsDebt.class, tempDeathsDebt, wp, CooldownTypes.ABILITY, cooldownManagerDebt -> {
                totemStand.remove();
                effectTask.cancel();
                if (wp.isDead()) {
                    return;
                }
                wp.getWorld().spigot().strikeLightningEffect(totemStand.getLocation(), false);
                for (WarlordsPlayer totemTarget : PlayerFilter.entitiesAround((Entity)totemStand, (double)this.debtRadius, (double)(this.debtRadius - 1), (double)this.debtRadius).aliveEnemiesOf(wp)) {
                    ++this.playersDamaged;
                    totemTarget.addDamageInstance(wp, this.name, tempDeathsDebt.getDelayedDamage() * 0.15f, tempDeathsDebt.getDelayedDamage() * 0.15f, this.critChance, this.critMultiplier, false);
                }
            }, 120, (cooldown, ticksLeft, counter) -> {
                if (counter % 20 == 0) {
                    this.onDebtTick(wp, totemStand, tempDeathsDebt);
                }
            }));
            circle.replaceEffects(e -> e instanceof DoubleLineEffect, new EffectPlayer[]{new DoubleLineEffect(ParticleEffect.SPELL_WITCH)});
            circle.setRadius(this.debtRadius);
            totemStand.setHelmet(new ItemStack(Material.DARK_OAK_FENCE_GATE));
        }, duration, new TriConsumer[]{(cooldown, ticksLeft, counter) -> {
            boolean isPlayerInRadius;
            if (wp.getWorld() != totemStand.getWorld()) {
                cooldown.setTicksLeft(0);
                return;
            }
            boolean bl = isPlayerInRadius = wp.getLocation().distanceSquared(totemStand.getLocation()) < (double)(this.respiteRadius * this.respiteRadius);
            if (!isPlayerInRadius && !tempDeathsDebt.isInDebt()) {
                tempDeathsDebt.setInDebt(true);
                tempDeathsDebt.setPlayerInRadius(false);
                cooldown.setTicksLeft(0);
                return;
            }
            if (counter % 20 == 0) {
                Utils.playGlobalSound(totemStand.getLocation(), "shaman.earthlivingweapon.impact", 2.0f, 1.5f);
                wp.sendMessage(ChatColor.GREEN + WarlordsPlayer.GIVE_ARROW_GREEN + " \u00a72Spirit's Respite \u00a77delayed \u00a7c" + Math.round(tempDeathsDebt.getDelayedDamage()) + " \u00a77damage. \u00a76" + Math.round((float)ticksLeft.intValue() / 20.0f) + " \u00a77seconds left.");
            }
        }}){

            @Override
            public void onDamageFromSelf(WarlordsDamageHealingEvent event, float currentDamageValue, boolean isCrit) {
                tempDeathsDebt.addDelayedDamage(currentDamageValue);
            }
        });
    }

    public void onDebtTick(WarlordsPlayer wp, ArmorStand totemStand, DeathsDebt tempDeathsDebt) {
        Utils.playGlobalSound(totemStand.getLocation(), "shaman.lightningbolt.impact", 2.0f, 1.5f);
        float damage = tempDeathsDebt.getDelayedDamage() * this.getSelfDamageInPercentPerSecond();
        float debtTrueDamage = (float)((double)damage * Math.pow(0.8, (int)new CooldownFilter<RegularCooldown>(wp, RegularCooldown.class).filterCooldownClass(SpiritLink.class).stream().count()));
        wp.addDamageInstance(wp, "", debtTrueDamage, debtTrueDamage, this.critChance, this.critMultiplier, false);
        for (WarlordsPlayer allyTarget : PlayerFilter.entitiesAround((Entity)totemStand, (double)this.debtRadius, (double)(this.debtRadius - 1), (double)this.debtRadius).aliveTeammatesOf(wp)) {
            ++this.playersHealed;
            allyTarget.addHealingInstance(wp, this.name, damage * 0.15f, damage * 0.15f, this.critChance, this.critMultiplier, false, false);
        }
        if (wp.getSpec().getBlue() instanceof Repentance) {
            ((Repentance)wp.getSpec().getBlue()).addToPool(debtTrueDamage);
        }
    }

    public int getRespiteRadius() {
        return this.respiteRadius;
    }

    public void setRespiteRadius(int respiteRadius) {
        this.respiteRadius = respiteRadius;
    }

    public int getDebtRadius() {
        return this.debtRadius;
    }

    public void setDebtRadius(int debtRadius) {
        this.debtRadius = debtRadius;
    }

    public float getDelayedDamage() {
        return this.delayedDamage;
    }

    public void addDelayedDamage(float delayedDamage) {
        this.delayedDamage += delayedDamage;
    }

    public float getSelfDamageInPercentPerSecond() {
        return this.selfDamageInPercentPerSecond;
    }

    public void setSelfDamageInPercentPerSecond(float selfDamageInPercentPerSecond) {
        this.selfDamageInPercentPerSecond = selfDamageInPercentPerSecond;
    }

    public boolean isInDebt() {
        return this.inDebt;
    }

    public void setInDebt(boolean inDebt) {
        this.inDebt = inDebt;
    }

    public boolean isPlayerInRadius() {
        return this.playerInRadius;
    }

    public void setPlayerInRadius(boolean playerInRadius) {
        this.playerInRadius = playerInRadius;
    }
}

