/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.abilties;

import com.ebicep.warlords.abilties.Consecrate;
import com.ebicep.warlords.abilties.HolyRadianceCrusader;
import com.ebicep.warlords.abilties.internal.AbstractStrikeBase;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.util.java.Pair;
import com.ebicep.warlords.util.warlords.PlayerFilter;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import org.bukkit.entity.Player;

public class CrusadersStrike
extends AbstractStrikeBase {
    protected int energyGivenToPlayers = 0;
    private final int energyGiven = 24;
    private final int energyRadius = 10;

    public CrusadersStrike() {
        super("Crusader's Strike", 326.0f, 441.0f, 0.0f, 90, 25, 175);
    }

    @Override
    public void updateDescription(Player player) {
        this.description = "\u00a77Strike the targeted enemy player,\n\u00a77causing \u00a7c" + this.format(this.minDamageHeal) + " \u00a77- \u00a7c" + this.format(this.maxDamageHeal) + " \u00a77damage and\n\u00a77restoring \u00a7e" + 24 + " \u00a77energy to two nearby\n\u00a77allies within \u00a7e" + 10 + " \u00a77blocks.\n\n\u00a77MARKED allies get priority in restoring energy and\n\u00a77increases their speed by \u00a7e40% \u00a77for \u00a761 \u00a77second.";
    }

    @Override
    public List<Pair<String, String>> getAbilityInfo() {
        ArrayList<Pair<String, String>> info = new ArrayList<Pair<String, String>>();
        info.add(new Pair<String, String>("Players Struck", "" + this.timesUsed));
        info.add(new Pair<String, String>("Energy Given", "" + this.energyGivenToPlayers));
        return info;
    }

    @Override
    protected void onHit(@Nonnull WarlordsPlayer wp, @Nonnull Player player, @Nonnull WarlordsPlayer nearPlayer) {
        if (this.standingOnConsecrate(wp, nearPlayer)) {
            wp.doOnStaticAbility(Consecrate.class, Consecrate::addStrikesBoosted);
            nearPlayer.addDamageInstance(wp, this.name, this.minDamageHeal * 1.15f, this.maxDamageHeal * 1.15f, this.critChance, this.critMultiplier, false);
        } else {
            nearPlayer.addDamageInstance(wp, this.name, this.minDamageHeal, this.maxDamageHeal, this.critChance, this.critMultiplier, false);
        }
        for (WarlordsPlayer energyTarget : PlayerFilter.entitiesAround(wp, 10.0, 10.0, 10.0).aliveTeammatesOfExcludingSelf(wp).sorted(Comparator.comparing(p -> p.getCooldownManager().hasCooldown(HolyRadianceCrusader.class) ? 0 : 1).thenComparing(Utils.sortClosestBy(WarlordsPlayer::getLocation, wp.getLocation()))).limit(2L)) {
            if (energyTarget.getCooldownManager().hasCooldown(HolyRadianceCrusader.class)) {
                energyTarget.getSpeed().addSpeedModifier("CRUSADER MARK", 40, 20, "BASE");
            }
            this.energyGivenToPlayers = (int)((float)this.energyGivenToPlayers + energyTarget.addEnergy(wp, this.name, 24.0f));
        }
    }
}

