/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.abilties;

import com.ebicep.warlords.abilties.internal.AbstractStrikeBase;
import com.ebicep.warlords.events.WarlordsDamageHealingEvent;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.player.cooldowns.CooldownFilter;
import com.ebicep.warlords.player.cooldowns.CooldownManager;
import com.ebicep.warlords.player.cooldowns.CooldownTypes;
import com.ebicep.warlords.player.cooldowns.cooldowns.RegularCooldown;
import com.ebicep.warlords.util.java.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class CripplingStrike
extends AbstractStrikeBase {
    private int consecutiveStrikeCounter = 0;
    private final int crippleDuration = 3;

    public CripplingStrike() {
        super("Crippling Strike", 362.25f, 498.0f, 0.0f, 100, 15, 200);
    }

    public CripplingStrike(int consecutiveStrikeCounter) {
        super("Crippling Strike", 362.25f, 498.0f, 0.0f, 100, 15, 200);
        this.consecutiveStrikeCounter = consecutiveStrikeCounter;
    }

    @Override
    public void updateDescription(Player player) {
        this.description = "\u00a77Strike the targeted enemy player,\n\u00a77causing \u00a7c" + this.format(this.minDamageHeal) + " \u00a77- \u00a7c" + this.format(this.maxDamageHeal) + " \u00a77damage\n\u00a77and \u00a7ccrippling \u00a77them for \u00a76" + 3 + " \u00a77seconds.\n\u00a77A \u00a7ccrippled \u00a77player deals \u00a7c10% \u00a77less\n\u00a77damage for the duration of the effect.\n\u00a77Adds \u00a7c5% \u00a77less damage dealt per\n\u00a77additional strike. (max 20%)";
    }

    @Override
    public List<Pair<String, String>> getAbilityInfo() {
        ArrayList<Pair<String, String>> info = new ArrayList<Pair<String, String>>();
        info.add(new Pair<String, String>("Players Struck", "" + this.timesUsed));
        return info;
    }

    @Override
    protected void onHit(@Nonnull WarlordsPlayer wp, @Nonnull Player player, @Nonnull WarlordsPlayer nearPlayer) {
        nearPlayer.addDamageInstance(wp, this.name, this.minDamageHeal, this.maxDamageHeal, this.critChance, this.critMultiplier, false);
        Optional<CripplingStrike> optionalCripplingStrike = new CooldownFilter<RegularCooldown>(nearPlayer, RegularCooldown.class).filterCooldownClassAndMapToObjectsOfClass(CripplingStrike.class).findAny();
        if (optionalCripplingStrike.isPresent()) {
            final CripplingStrike cripplingStrike = optionalCripplingStrike.get();
            nearPlayer.getCooldownManager().removeCooldown(CripplingStrike.class);
            nearPlayer.getCooldownManager().addCooldown(new RegularCooldown<CripplingStrike>(this.name, "CRIP", CripplingStrike.class, new CripplingStrike(Math.min(cripplingStrike.getConsecutiveStrikeCounter() + 1, 2)), wp, CooldownTypes.DEBUFF, cooldownManager -> {
                if (new CooldownFilter<RegularCooldown>((CooldownManager)cooldownManager, RegularCooldown.class).filterNameActionBar("CRIP").stream().count() == 1L) {
                    wp.sendMessage(ChatColor.GRAY + "You are no longer " + ChatColor.RED + "crippled" + ChatColor.GRAY + ".");
                }
            }, 60){

                @Override
                public float modifyDamageBeforeInterveneFromAttacker(WarlordsDamageHealingEvent event, float currentDamageValue) {
                    return (float)((double)currentDamageValue * (0.9 - (double)Math.min(cripplingStrike.getConsecutiveStrikeCounter() + 1, 2) * 0.05));
                }
            });
        } else {
            nearPlayer.sendMessage(ChatColor.GRAY + "You are " + ChatColor.RED + "crippled" + ChatColor.GRAY + ".");
            nearPlayer.getCooldownManager().addCooldown(new RegularCooldown<CripplingStrike>(this.name, "CRIP", CripplingStrike.class, new CripplingStrike(), wp, CooldownTypes.DEBUFF, cooldownManager -> {
                if (new CooldownFilter<RegularCooldown>((CooldownManager)cooldownManager, RegularCooldown.class).filterNameActionBar("CRIP").stream().count() == 1L) {
                    wp.sendMessage(ChatColor.GRAY + "You are no longer " + ChatColor.RED + "crippled" + ChatColor.GRAY + ".");
                }
            }, 60){

                @Override
                public float modifyDamageBeforeInterveneFromAttacker(WarlordsDamageHealingEvent event, float currentDamageValue) {
                    return currentDamageValue * 0.9f;
                }
            });
        }
    }

    public int getConsecutiveStrikeCounter() {
        return this.consecutiveStrikeCounter;
    }
}

