/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.abilties;

import com.ebicep.warlords.Warlords;
import com.ebicep.warlords.abilties.internal.AbstractAbility;
import com.ebicep.warlords.effects.ParticleEffect;
import com.ebicep.warlords.effects.circle.CircleEffect;
import com.ebicep.warlords.effects.circle.CircumferenceEffect;
import com.ebicep.warlords.effects.circle.DoubleLineEffect;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.player.cooldowns.CooldownTypes;
import com.ebicep.warlords.util.java.Pair;
import com.ebicep.warlords.util.warlords.PlayerFilter;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class Consecrate
extends AbstractAbility {
    protected int strikesBoosted = 0;
    protected int playersHit = 0;
    protected int strikeDamageBoost;
    protected float radius;
    protected Location location;

    public Consecrate(float minDamageHeal, float maxDamageHeal, int energyCost, int critChance, int critMultiplier, int strikeDamageBoost, float radius) {
        super("Consecrate", minDamageHeal, maxDamageHeal, 7.83f, energyCost, critChance, critMultiplier);
        this.strikeDamageBoost = strikeDamageBoost;
        this.radius = radius;
    }

    public Consecrate(float minDamageHeal, float maxDamageHeal, int energyCost, int critChance, int critMultiplier, int strikeDamageBoost, float radius, Location location) {
        super("Consecrate", minDamageHeal, maxDamageHeal, 7.83f, energyCost, critChance, critMultiplier);
        this.strikeDamageBoost = strikeDamageBoost;
        this.radius = radius;
        this.location = location;
    }

    @Override
    public void updateDescription(Player player) {
        this.description = "\u00a77Consecrate the ground below your\n\u00a77feet, declaring it sacred. Enemies\n\u00a77standing on it will take \u00a7c" + this.format(this.minDamageHeal) + " \u00a77-\n\u00a7c" + this.format(this.maxDamageHeal) + " \u00a77damage per second and\n\u00a77take \u00a7c" + this.strikeDamageBoost + "% \u00a77increased damage from\n\u00a77your paladin strikes. Lasts \u00a765\n\u00a77seconds.";
    }

    @Override
    public List<Pair<String, String>> getAbilityInfo() {
        ArrayList<Pair<String, String>> info = new ArrayList<Pair<String, String>>();
        info.add(new Pair<String, String>("Times Used", "" + this.timesUsed));
        info.add(new Pair<String, String>("Players Hit", "" + this.playersHit));
        info.add(new Pair<String, String>("Strikes Boosted", "" + this.strikesBoosted));
        return info;
    }

    @Override
    public boolean onActivate(WarlordsPlayer wp, Player player) {
        wp.subtractEnergy(this.energyCost);
        Location location = player.getLocation().clone();
        Utils.playGlobalSound(location, "paladin.consecrate.activation", 2.0f, 1.0f);
        CircleEffect circleEffect = new CircleEffect(wp.getGame(), wp.getTeam(), location, this.radius, new CircumferenceEffect(ParticleEffect.VILLAGER_HAPPY, ParticleEffect.REDSTONE), new DoubleLineEffect(ParticleEffect.SPELL));
        BukkitTask effectTask = Bukkit.getScheduler().runTaskTimer((Plugin)Warlords.getInstance(), circleEffect::playEffects, 0L, 1L);
        wp.getCooldownManager().addRegularCooldown(this.name, "CONS", Consecrate.class, new Consecrate(this.minDamageHeal, this.maxDamageHeal, this.energyCost, this.critChance, this.critMultiplier, this.strikeDamageBoost, this.radius, location), wp, CooldownTypes.ABILITY, cooldownManager -> effectTask.cancel(), 100, (cooldown, ticksLeft, counter) -> {
            if (counter % 20 == 0) {
                PlayerFilter.entitiesAround(location, (double)this.radius, 6.0, (double)this.radius).aliveEnemiesOf(wp).forEach((Consumer<? super WarlordsPlayer>)((Consumer<WarlordsPlayer>)enemy -> {
                    ++this.playersHit;
                    enemy.addDamageInstance(wp, this.name, this.minDamageHeal, this.maxDamageHeal, this.critChance, this.critMultiplier, false);
                }));
            }
        });
        return true;
    }

    public void addStrikesBoosted() {
        ++this.strikesBoosted;
    }

    public float getRadius() {
        return this.radius;
    }

    public void setRadius(float radius) {
        this.radius = radius;
    }

    public Location getLocation() {
        return this.location;
    }
}

