/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.abilties;

import com.ebicep.warlords.abilties.CapacitorTotem;
import com.ebicep.warlords.abilties.internal.AbstractChainBase;
import com.ebicep.warlords.abilties.internal.AbstractTotemBase;
import com.ebicep.warlords.events.WarlordsDamageHealingEvent;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.player.cooldowns.CooldownFilter;
import com.ebicep.warlords.player.cooldowns.CooldownTypes;
import com.ebicep.warlords.player.cooldowns.cooldowns.RegularCooldown;
import com.ebicep.warlords.util.java.Pair;
import com.ebicep.warlords.util.warlords.PlayerFilter;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ChainLightning
extends AbstractChainBase
implements Comparable<ChainLightning> {
    protected int numberOfDismounts = 0;
    private int damageReduction = 0;
    private final int radius = 20;
    private final int bounceRange = 10;
    private final int LIGHTING_MAX_PLAYERS_NO_TOTEM = 3;
    private final int LIGHTING_MAX_PLAYERS_WITH_TOTEM = 3;

    public int getDamageReduction() {
        return this.damageReduction;
    }

    public ChainLightning() {
        super("Chain Lightning", 294.0f, 575.0f, 9.4f, 40, 20, 175);
    }

    public ChainLightning(int damageReduction) {
        super("Chain Lightning", 294.0f, 575.0f, 9.4f, 40, 20, 175);
        this.damageReduction = damageReduction;
    }

    @Override
    public void updateDescription(Player player) {
        this.description = "\u00a77Discharge a bolt of lightning at the\n\u00a77targeted enemy player that deals\n\u00a7c" + this.format(this.minDamageHeal) + " \u00a77- \u00a7c" + this.format(this.maxDamageHeal) + " \u00a77damage and jumps to\n\u00a7e3 \u00a77additional targets within \u00a7e" + 10 + "\n\u00a77blocks. Each time the lightning jumps\n\u00a77the damage is decreased by \u00a7c15%\u00a77.\n\u00a77You gain \u00a7e10% \u00a77damage resistance for\n\u00a77each target hit, up to \u00a7e30% \u00a77damage\n\u00a77resistance. This buff lasts \u00a764.5 \u00a77seconds.\n\n\u00a77Has an initial cast range of \u00a7e" + 20 + " \u00a77blocks.";
    }

    @Override
    public List<Pair<String, String>> getAbilityInfo() {
        ArrayList<Pair<String, String>> info = new ArrayList<Pair<String, String>>();
        info.add(new Pair<String, String>("Times Used", "" + this.timesUsed));
        info.add(new Pair<String, String>("Players Hit", "" + this.playersHit));
        info.add(new Pair<String, String>("Dismounts", "" + this.numberOfDismounts));
        return info;
    }

    @Override
    protected int getHitCounterAndActivate(WarlordsPlayer wp, Player player) {
        return this.partOfChainLightning(wp, new HashSet<WarlordsPlayer>(), (Entity)wp.getEntity(), false);
    }

    @Override
    protected void onHit(WarlordsPlayer wp, Player player, final int hitCounter) {
        Utils.playGlobalSound(player.getLocation(), "shaman.chainlightning.activation", 3.0f, 1.0f);
        player.playSound(player.getLocation(), "shaman.chainlightning.impact", 2.0f, 1.0f);
        wp.getCooldownManager().removeCooldown(ChainLightning.class);
        wp.getCooldownManager().addCooldown(new RegularCooldown<ChainLightning>(this.name, "CHAIN", ChainLightning.class, new ChainLightning(hitCounter), wp, CooldownTypes.BUFF, cooldownManager -> {}, 80){

            @Override
            public float modifyDamageAfterInterveneFromSelf(WarlordsDamageHealingEvent event, float currentDamageValue) {
                float newDamageValue = currentDamageValue * ((float)(10 - hitCounter) / 10.0f);
                event.getPlayer().addAbsorbed(Math.abs(currentDamageValue - newDamageValue));
                return newDamageValue;
            }
        });
        wp.getSpec().getRed().setCurrentCooldown((float)((double)this.cooldown * wp.getCooldownModifier()));
    }

    @Override
    protected ItemStack getChainItem() {
        return new ItemStack(Material.STAINED_GLASS, 1, 7);
    }

    private int partOfChainLightning(WarlordsPlayer wp, Set<WarlordsPlayer> playersHit, Entity checkFrom, boolean hasHitTotem) {
        PlayerFilter filter;
        Optional<WarlordsPlayer> foundPlayer;
        boolean firstCheck;
        int playersSize = playersHit.size();
        if (playersSize >= (hasHitTotem ? 3 : 3)) {
            return playersSize + (hasHitTotem ? 1 : 0);
        }
        boolean bl = firstCheck = checkFrom == wp.getEntity();
        if (!hasHitTotem) {
            if (firstCheck) {
                Optional<CapacitorTotem> optionalTotem = this.getLookingAtTotem(wp);
                if (checkFrom instanceof LivingEntity && optionalTotem.isPresent()) {
                    ArmorStand totem = optionalTotem.get().getTotem();
                    this.chain(checkFrom.getLocation(), totem.getLocation());
                    this.partOfChainLightningPulseDamage(wp, optionalTotem.get());
                    return this.partOfChainLightning(wp, playersHit, (Entity)totem, true);
                }
            } else {
                Optional<CapacitorTotem> capacitorTotem = AbstractTotemBase.getTotemDownAndClose(wp, checkFrom, CapacitorTotem.class);
                if (capacitorTotem.isPresent()) {
                    ArmorStand totem = capacitorTotem.get().getTotem();
                    this.chain(checkFrom.getLocation(), totem.getLocation());
                    this.partOfChainLightningPulseDamage(wp, capacitorTotem.get());
                    return this.partOfChainLightning(wp, playersHit, (Entity)totem, true);
                }
            }
        }
        if ((foundPlayer = (filter = firstCheck ? PlayerFilter.entitiesAround(checkFrom, 20.0, 18.0, 20.0).filter(e -> Utils.isLookingAtChain(wp.getEntity(), e.getEntity()) && Utils.hasLineOfSight(wp.getEntity(), e.getEntity())) : PlayerFilter.entitiesAround(checkFrom, 10.0, 10.0, 10.0).lookingAtFirst(wp)).closestFirst(wp).aliveEnemiesOf(wp).excluding(playersHit).findFirst()).isPresent()) {
            float damageMultiplier;
            WarlordsPlayer hit = foundPlayer.get();
            this.chain(checkFrom.getLocation(), hit.getLocation());
            switch (playersSize) {
                case 0: {
                    damageMultiplier = 1.0f;
                    break;
                }
                case 1: {
                    damageMultiplier = 0.85f;
                    break;
                }
                default: {
                    damageMultiplier = 0.7f;
                }
            }
            playersHit.add(hit);
            if (hit.onHorse()) {
                ++this.numberOfDismounts;
            }
            hit.addDamageInstance(wp, this.name, this.minDamageHeal * damageMultiplier, this.maxDamageHeal * damageMultiplier, this.critChance, this.critMultiplier, false);
            return this.partOfChainLightning(wp, playersHit, (Entity)hit.getEntity(), hasHitTotem);
        }
        return playersSize + (hasHitTotem ? 1 : 0);
    }

    private void partOfChainLightningPulseDamage(WarlordsPlayer wp, CapacitorTotem capacitorTotem) {
        ArmorStand totem = capacitorTotem.getTotem();
        capacitorTotem.pulseDamage();
        Utils.playGlobalSound(totem.getLocation(), "shaman.capacitortotem.pulse", 2.0f, 1.0f);
        wp.playSound(totem.getLocation(), "shaman.chainlightning.impact", 2.0f, 1.0f);
        capacitorTotem.addProc();
    }

    private Optional<CapacitorTotem> getLookingAtTotem(WarlordsPlayer warlordsPlayer) {
        return new CooldownFilter<RegularCooldown>(warlordsPlayer, RegularCooldown.class).filterCooldownClassAndMapToObjectsOfClass(CapacitorTotem.class).filter(abstractTotemBase -> abstractTotemBase.isPlayerLookingAtTotem(warlordsPlayer)).findFirst();
    }

    @Override
    public int compareTo(ChainLightning chainLightning) {
        return Integer.compare(this.damageReduction, chainLightning.damageReduction);
    }
}

