/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.abilties;

import com.ebicep.warlords.abilties.internal.AbstractChainBase;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.util.java.Pair;
import com.ebicep.warlords.util.warlords.PlayerFilter;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ChainHeal
extends AbstractChainBase {
    private final int radius = 15;
    private final int bounceRange = 10;

    public ChainHeal() {
        super("Chain Heal", 533.0f, 719.0f, 7.99f, 40, 20, 175);
    }

    @Override
    public void updateDescription(Player player) {
        this.description = "\u00a77Discharge a beam of energizing lightning\n\u00a77that heals you and a targeted friendly\n\u00a77player for \u00a7a" + this.format(this.minDamageHeal) + " \u00a77- \u00a7a" + this.format(this.maxDamageHeal) + " \u00a77health and\n\u00a77jumps to \u00a7e1 \u00a77additional target within\n\u00a7e" + 10 + " \u00a77blocks. The last jump heals\n\u00a77for \u00a7c20% \u00a77less.\n\n\u00a77Each ally healed reduces the cooldown of\n\u00a77Boulder by \u00a762.5 \u00a77seconds.\n\n\u00a77Has an initial cast range of \u00a7e" + 15 + " \u00a77blocks.";
    }

    @Override
    public List<Pair<String, String>> getAbilityInfo() {
        ArrayList<Pair<String, String>> info = new ArrayList<Pair<String, String>>();
        info.add(new Pair<String, String>("Times Used", "" + this.timesUsed));
        info.add(new Pair<String, String>("Players Healed", "" + this.playersHit));
        return info;
    }

    @Override
    protected int getHitCounterAndActivate(WarlordsPlayer wp, Player p) {
        int hitCounter = 0;
        for (WarlordsPlayer chainTarget : PlayerFilter.entitiesAround((Entity)p, 15.0, 15.0, 15.0).aliveTeammatesOfExcludingSelf(wp).lookingAtFirst(wp)) {
            if (!Utils.isLookingAtChain((LivingEntity)p, chainTarget.getEntity())) continue;
            wp.addHealingInstance(wp, this.name, this.minDamageHeal, this.maxDamageHeal, this.critChance, this.critMultiplier, false, false);
            chainTarget.addHealingInstance(wp, this.name, this.minDamageHeal, this.maxDamageHeal, this.critChance, this.critMultiplier, false, false);
            this.chain(p.getLocation(), chainTarget.getLocation());
            ++hitCounter;
            Iterator<WarlordsPlayer> iterator = PlayerFilter.entitiesAround(chainTarget, 10.0, 10.0, 10.0).aliveTeammatesOf(wp).excluding(wp, chainTarget).iterator();
            if (!iterator.hasNext()) break;
            WarlordsPlayer bounceTarget = iterator.next();
            this.chain(chainTarget.getLocation(), bounceTarget.getLocation());
            bounceTarget.addHealingInstance(wp, this.name, this.minDamageHeal * 0.8f, this.maxDamageHeal * 0.8f, this.critChance, this.critMultiplier, false, false);
            ++hitCounter;
            break;
        }
        return hitCounter;
    }

    @Override
    protected void onHit(WarlordsPlayer warlordsPlayer, Player player, int hitCounter) {
        Utils.playGlobalSound(player.getLocation(), "shaman.chainheal.activation", 2.0f, 1.0f);
        if ((float)(hitCounter + 1) * 2.5f > warlordsPlayer.getSpec().getRed().getCurrentCooldown()) {
            warlordsPlayer.getSpec().getRed().setCurrentCooldown(0.0f);
        } else {
            warlordsPlayer.getSpec().getRed().setCurrentCooldown(warlordsPlayer.getSpec().getRed().getCurrentCooldown() - (float)(hitCounter + 1) * 2.5f);
        }
        warlordsPlayer.updateRedItem(player);
        warlordsPlayer.getSpec().getBlue().setCurrentCooldown((float)((double)this.cooldown * warlordsPlayer.getCooldownModifier()));
        warlordsPlayer.updateBlueItem(player);
    }

    @Override
    protected ItemStack getChainItem() {
        return new ItemStack(Material.RED_ROSE, 1, 1);
    }
}

