/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.abilties;

import com.ebicep.warlords.abilties.internal.AbstractTotemBase;
import com.ebicep.warlords.effects.FallingBlockWaveEffect;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.player.cooldowns.CooldownTypes;
import com.ebicep.warlords.util.java.Pair;
import com.ebicep.warlords.util.warlords.PlayerFilter;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class CapacitorTotem
extends AbstractTotemBase {
    private int duration = 8;
    private int radius = 6;
    private Runnable pulseDamage;
    private int numberOfProcs = 0;
    private int numberOfProcsAfterCarrierPassed = 0;
    private boolean teamCarrierPassedThrough = false;

    public CapacitorTotem() {
        super("Capacitor Totem", 404.0f, 523.0f, 62.64f, 20, 20, 200);
    }

    public CapacitorTotem(ArmorStand totem, WarlordsPlayer owner, Runnable pulseDamage) {
        super("Capacitor Totem", 404.0f, 523.0f, 62.64f, 20, 20, 200, totem, owner);
        this.pulseDamage = pulseDamage;
    }

    @Override
    public void updateDescription(Player player) {
        this.description = "\u00a77Place a highly conductive totem\n\u00a77on the ground. Casting Chain Lightning\n\u00a77or Lightning Rod on the totem will cause\n\u00a77it to pulse, dealing \u00a7c" + this.format(this.minDamageHeal) + " \u00a77- \u00a7c" + this.format(this.maxDamageHeal) + " \u00a77damage\n\u00a77to all enemies nearby. Lasts \u00a76" + this.duration + " \u00a77seconds.";
    }

    @Override
    public List<Pair<String, String>> getAbilityInfo() {
        ArrayList<Pair<String, String>> info = new ArrayList<Pair<String, String>>();
        info.add(new Pair<String, String>("Times Used", "" + this.timesUsed));
        info.add(new Pair<String, String>("Times Proc'd", "" + this.numberOfProcs));
        return info;
    }

    @Override
    protected ItemStack getTotemItemStack() {
        return new ItemStack(Material.RED_ROSE, 1, 4);
    }

    @Override
    protected void playSound(Player player, Location location) {
        Utils.playGlobalSound(location, "shaman.totem.activation", 2.0f, 1.0f);
    }

    @Override
    protected void onActivation(WarlordsPlayer wp, Player player, ArmorStand totemStand) {
        Location totemLocation = wp.getLocation().clone();
        CapacitorTotem tempCapacitorTotem = new CapacitorTotem(totemStand, wp, () -> {
            PlayerFilter.entitiesAround(totemStand.getLocation(), (double)this.radius, (double)this.radius, (double)this.radius).enemiesOf(wp).forEach((Consumer<? super WarlordsPlayer>)((Consumer<WarlordsPlayer>)warlordsPlayer -> warlordsPlayer.addDamageInstance(wp, this.name, this.minDamageHeal, this.maxDamageHeal, this.critChance, this.critMultiplier, false)));
            new FallingBlockWaveEffect(totemStand.getLocation().add(0.0, 1.0, 0.0), this.radius, 1.2, Material.SAPLING, 0).play();
        });
        wp.getCooldownManager().addRegularCooldown(this.name, "TOTEM", CapacitorTotem.class, tempCapacitorTotem, wp, CooldownTypes.ABILITY, cooldownManager -> totemStand.remove(), this.duration * 20, (cooldown, ticksLeft, counter) -> {
            if (!tempCapacitorTotem.isTeamCarrierPassedThrough() && PlayerFilter.playingGame(wp.getGame()).teammatesOfExcludingSelf(wp).stream().filter(WarlordsPlayer::hasFlag).map(WarlordsPlayer::getLocation).anyMatch(location -> location.distanceSquared(totemLocation) <= 1.0)) {
                tempCapacitorTotem.setTeamCarrierPassedThrough(true);
            }
        });
    }

    public void pulseDamage() {
        this.pulseDamage.run();
    }

    public Runnable getPulseDamage() {
        return this.pulseDamage;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public void addProc() {
        this.owner.doOnStaticAbility(CapacitorTotem.class, capacitorTotem -> capacitorTotem.setNumberOfProcs(capacitorTotem.getNumberOfProcs() + 1));
        ++this.numberOfProcs;
        if (this.teamCarrierPassedThrough) {
            ++this.numberOfProcsAfterCarrierPassed;
        }
    }

    public int getNumberOfProcs() {
        return this.numberOfProcs;
    }

    public void setNumberOfProcs(int numberOfProcs) {
        this.numberOfProcs = numberOfProcs;
    }

    public int getNumberOfProcsAfterCarrierPassed() {
        return this.numberOfProcsAfterCarrierPassed;
    }

    public boolean isTeamCarrierPassedThrough() {
        return this.teamCarrierPassedThrough;
    }

    public void setTeamCarrierPassedThrough(boolean teamCarrierPassedThrough) {
        this.teamCarrierPassedThrough = teamCarrierPassedThrough;
    }
}

