/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.abilties;

import com.ebicep.warlords.abilties.TimeWarp;
import com.ebicep.warlords.abilties.internal.AbstractAbility;
import com.ebicep.warlords.effects.ParticleEffect;
import com.ebicep.warlords.events.WarlordsEvents;
import com.ebicep.warlords.game.option.marker.FlagHolder;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.util.java.Pair;
import com.ebicep.warlords.util.warlords.GameRunnable;
import com.ebicep.warlords.util.warlords.PlayerFilter;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class Boulder
extends AbstractAbility {
    protected int playersHit = 0;
    protected int carrierHit = 0;
    protected int warpsKnockbacked = 0;
    private static final double SPEED = 0.29;
    private static final double GRAVITY = -0.0059;

    public Boulder() {
        super("Boulder", 451.0f, 673.0f, 7.05f, 80, 15, 175);
    }

    @Override
    public void updateDescription(Player player) {
        this.description = "\u00a77Launch a giant boulder that shatters\n\u00a77and deals \u00a7c" + this.format(this.minDamageHeal) + " \u00a77- \u00a7c" + this.format(this.maxDamageHeal) + " \u00a77damage\n\u00a77to all enemies near the impact point\n\u00a77and knocks them back slightly.";
    }

    @Override
    public List<Pair<String, String>> getAbilityInfo() {
        ArrayList<Pair<String, String>> info = new ArrayList<Pair<String, String>>();
        info.add(new Pair<String, String>("Times Used", "" + this.timesUsed));
        info.add(new Pair<String, String>("Players Hit", "" + this.playersHit));
        info.add(new Pair<String, String>("Carriers Hit", "" + this.carrierHit));
        info.add(new Pair<String, String>("Warps Knockbacked", "" + this.warpsKnockbacked));
        return info;
    }

    @Override
    public boolean onActivate(final WarlordsPlayer wp, Player player) {
        wp.subtractEnergy(this.energyCost);
        Utils.playGlobalSound(player.getLocation(), "shaman.boulder.activation", 2.0f, 1.0f);
        Location location = player.getLocation();
        final Vector speed = player.getLocation().getDirection().multiply(0.29);
        final ArmorStand stand = (ArmorStand)location.getWorld().spawnEntity(location, EntityType.ARMOR_STAND);
        stand.setHelmet(new ItemStack(Material.LONG_GRASS, 1, 2));
        stand.setCustomName("Boulder");
        stand.setCustomNameVisible(false);
        stand.setGravity(false);
        stand.setVisible(false);
        final Location initialCastLocation = player.getLocation();
        new GameRunnable(wp.getGame()){

            @Override
            public void run() {
                this.quarterStep(false);
                this.quarterStep(false);
                this.quarterStep(false);
                this.quarterStep(false);
                this.quarterStep(false);
                this.quarterStep(false);
                this.quarterStep(true);
            }

            private void quarterStep(boolean last) {
                boolean shouldExplode;
                if (!stand.isValid()) {
                    this.cancel();
                    return;
                }
                speed.add(new Vector(0.0, -0.0017109999999999998, 0.0));
                final Location newLoc = stand.getLocation();
                newLoc.add(speed);
                stand.teleport(newLoc);
                newLoc.add(0.0, 1.75, 0.0);
                stand.setHeadPose(new EulerAngle(-speed.getY() * 3.0, 0.0, 0.0));
                if (last) {
                    ParticleEffect.CRIT.display(0.3f, 0.3f, 0.3f, 0.1f, 4, newLoc.clone().add(0.0, -1.0, 0.0), 500.0);
                }
                WarlordsPlayer directHit = null;
                if (!newLoc.getBlock().isEmpty() && newLoc.getBlock().getType() != Material.GRASS && newLoc.getBlock().getType() != Material.BARRIER && newLoc.getBlock().getType() != Material.VINE) {
                    shouldExplode = true;
                } else {
                    directHit = PlayerFilter.entitiesAroundRectangle(newLoc, 1.0, 2.0, 1.0).aliveEnemiesOf(wp).findFirstOrNull();
                    boolean bl = shouldExplode = directHit != null;
                }
                if (shouldExplode) {
                    stand.remove();
                    Utils.playGlobalSound(newLoc, "shaman.boulder.impact", 2.0f, 1.0f);
                    final WarlordsPlayer directHitFinal = directHit;
                    new GameRunnable(wp.getGame()){

                        @Override
                        public void run() {
                            for (WarlordsPlayer p : PlayerFilter.entitiesAround(newLoc, 5.5, 5.5, 5.5).aliveEnemiesOf(wp)) {
                                ++Boulder.this.playersHit;
                                if (p.hasFlag()) {
                                    ++Boulder.this.carrierHit;
                                }
                                if (p.getCooldownManager().hasCooldown(TimeWarp.class) && FlagHolder.playerTryingToPick(p)) {
                                    ++Boulder.this.warpsKnockbacked;
                                }
                                Vector v = p == directHitFinal ? initialCastLocation.toVector().subtract(p.getLocation().toVector()).normalize().multiply(-1.15).setY(0.2) : p.getLocation().toVector().subtract(newLoc.toVector()).normalize().multiply(1.15).setY(0.2);
                                p.setVelocity(v, false, false);
                                p.addDamageInstance(wp, Boulder.this.name, Boulder.this.minDamageHeal, Boulder.this.maxDamageHeal, Boulder.this.critChance, Boulder.this.critMultiplier, false);
                            }
                            newLoc.setPitch(-12.0f);
                            final Location impactLocation = newLoc.clone().subtract(speed);
                            Boulder.this.spawnFallingBlocks(impactLocation, 3.0, 10);
                            new GameRunnable(wp.getGame()){

                                @Override
                                public void run() {
                                    Boulder.this.spawnFallingBlocks(impactLocation, 3.5, 20);
                                }
                            }.runTaskLater(1L);
                        }
                    }.runTaskLater(1L);
                    this.cancel();
                }
            }
        }.runTaskTimer(0L, 1L);
        return true;
    }

    private void spawnFallingBlocks(Location impactLocation, double initialCircleRadius, int amount) {
        double angle = 0.0;
        for (int i = 0; i < amount; ++i) {
            FallingBlock fallingBlock;
            Location spawnLoc = impactLocation.clone();
            double x = initialCircleRadius * Math.cos(angle);
            double z = initialCircleRadius * Math.sin(angle);
            angle += 360.0 / (double)amount + (double)((int)(Math.random() * 4.0 - 2.0));
            spawnLoc.add(x, 1.0, z);
            if (spawnLoc.getWorld().getBlockAt(spawnLoc).getType() != Material.AIR) continue;
            switch ((int)(Math.random() * 3.0)) {
                case 0: {
                    fallingBlock = impactLocation.getWorld().spawnFallingBlock(spawnLoc, Material.DIRT, (byte)0);
                    break;
                }
                case 1: {
                    fallingBlock = impactLocation.getWorld().spawnFallingBlock(spawnLoc, Material.STONE, (byte)0);
                    break;
                }
                case 2: {
                    fallingBlock = impactLocation.getWorld().spawnFallingBlock(spawnLoc, Material.DIRT, (byte)2);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + (int)(Math.random() * 3.0));
                }
            }
            fallingBlock.setVelocity(impactLocation.toVector().subtract(spawnLoc.toVector()).normalize().multiply(-0.5).setY(0.25));
            fallingBlock.setDropItem(false);
            WarlordsEvents.addEntityUUID((Entity)fallingBlock);
        }
    }
}

