/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.abilties;

import com.ebicep.warlords.abilties.internal.AbstractAbility;
import com.ebicep.warlords.effects.ParticleEffect;
import com.ebicep.warlords.events.WarlordsDamageHealingEvent;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.player.cooldowns.CooldownTypes;
import com.ebicep.warlords.player.cooldowns.cooldowns.RegularCooldown;
import com.ebicep.warlords.util.java.Pair;
import com.ebicep.warlords.util.java.TriConsumer;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;

public class BloodLust
extends AbstractAbility {
    private final int duration = 15;
    private int damageConvertPercent = 65;

    public BloodLust() {
        super("Blood Lust", 0.0f, 0.0f, 31.32f, 20, 0, 0);
    }

    @Override
    public void updateDescription(Player player) {
        this.description = "\u00a77You lust for blood, healing yourself\n\u00a77for \u00a7a" + this.damageConvertPercent + "% \u00a77of all the damage you deal.\n\u00a77Lasts \u00a76" + 15 + " \u00a77seconds.";
    }

    @Override
    public List<Pair<String, String>> getAbilityInfo() {
        ArrayList<Pair<String, String>> info = new ArrayList<Pair<String, String>>();
        info.add(new Pair<String, String>("Times Used", "" + this.timesUsed));
        return info;
    }

    @Override
    public boolean onActivate(WarlordsPlayer wp, Player p) {
        wp.subtractEnergy(this.energyCost);
        Utils.playGlobalSound(p.getLocation(), "warrior.bloodlust.activation", 2.0f, 1.0f);
        BloodLust tempBloodLust = new BloodLust();
        wp.getCooldownManager().addCooldown(new RegularCooldown<BloodLust>(this.name, "LUST", BloodLust.class, tempBloodLust, wp, CooldownTypes.ABILITY, cooldownManager -> {}, 300, new TriConsumer[]{(cooldown, ticksLeft, counter) -> {
            if (counter % 3 == 0) {
                ParticleEffect.REDSTONE.display((ParticleEffect.ParticleColor)new ParticleEffect.OrdinaryColor(255, 0, 0), wp.getLocation().add((Math.random() - 0.5) * 1.0, 1.2, (Math.random() - 0.5) * 1.0), 500.0);
            }
        }}){

            @Override
            public boolean distinct() {
                return true;
            }

            @Override
            public void onDamageFromAttacker(WarlordsDamageHealingEvent event, float currentDamageValue, boolean isCrit) {
                WarlordsPlayer attacker = event.getAttacker();
                BloodLust bloodLust = (BloodLust)attacker.getSpec().getBlue();
                attacker.addHealingInstance(attacker, this.name, currentDamageValue * ((float)bloodLust.getDamageConvertPercent() / 100.0f), currentDamageValue * ((float)bloodLust.getDamageConvertPercent() / 100.0f), -1, 100, false, false);
            }
        });
        return true;
    }

    public int getDamageConvertPercent() {
        return this.damageConvertPercent;
    }

    public void setDamageConvertPercent(int damageConvertPercent) {
        this.damageConvertPercent = damageConvertPercent;
    }
}

