/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.abilties;

import com.ebicep.warlords.abilties.internal.AbstractAbility;
import com.ebicep.warlords.effects.ParticleEffect;
import com.ebicep.warlords.events.WarlordsDamageHealingEvent;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.player.cooldowns.CooldownTypes;
import com.ebicep.warlords.player.cooldowns.cooldowns.RegularCooldown;
import com.ebicep.warlords.util.java.Pair;
import com.ebicep.warlords.util.java.TriConsumer;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;

public class Berserk
extends AbstractAbility {
    protected int hitsDoneAmplified = 0;
    protected int hitsTakenAmplified = 0;
    private final int duration = 18;
    private final int speedBuff = 30;
    private float damageIncrease = 30.0f;
    private float damageTakenIncrease = 10.0f;

    public Berserk() {
        super("Berserk", 0.0f, 0.0f, 46.98f, 30, 0, 0);
    }

    @Override
    public void updateDescription(Player player) {
        this.description = "\u00a77You go into a berserker rage,\n\u00a77increasing your damage by \u00a7c" + this.format(this.damageIncrease) + "% \u00a77and\n\u00a77movement speed by \u00a7e" + 30 + "%\u00a77. While active,\n\u00a77you also take \u00a7c" + this.format(this.damageTakenIncrease) + "% \u00a77more damage.\n\u00a77Lasts \u00a76" + 18 + " \u00a77seconds.";
    }

    @Override
    public List<Pair<String, String>> getAbilityInfo() {
        ArrayList<Pair<String, String>> info = new ArrayList<Pair<String, String>>();
        info.add(new Pair<String, String>("Times Used", "" + this.timesUsed));
        info.add(new Pair<String, String>("Hits Done Amplified", "" + this.hitsDoneAmplified));
        info.add(new Pair<String, String>("Hits Taken Amplified", "" + this.hitsTakenAmplified));
        return info;
    }

    @Override
    public boolean onActivate(WarlordsPlayer wp, Player player) {
        wp.subtractEnergy(this.energyCost);
        Utils.playGlobalSound(player.getLocation(), "warrior.berserk.activation", 2.0f, 1.0f);
        Runnable cancelSpeed = wp.getSpeed().addSpeedModifier(this.name, 30, 360, "BASE");
        Berserk tempBerserk = new Berserk();
        wp.getCooldownManager().addCooldown(new RegularCooldown<Berserk>(this.name, "BERS", Berserk.class, tempBerserk, wp, CooldownTypes.ABILITY, cooldownManager -> cancelSpeed.run(), 360, new TriConsumer[]{(cooldown, ticksLeft, counter) -> {
            if (counter % 3 == 0) {
                ParticleEffect.VILLAGER_ANGRY.display(0.0f, 0.0f, 0.0f, 0.1f, 1, wp.getLocation().add(0.0, 1.75, 0.0), 500.0);
            }
        }}){

            @Override
            public float modifyDamageBeforeInterveneFromSelf(WarlordsDamageHealingEvent event, float currentDamageValue) {
                ++Berserk.this.hitsTakenAmplified;
                return currentDamageValue * (1.0f + Berserk.this.damageTakenIncrease / 100.0f);
            }

            @Override
            public float modifyDamageBeforeInterveneFromAttacker(WarlordsDamageHealingEvent event, float currentDamageValue) {
                ++Berserk.this.hitsDoneAmplified;
                return currentDamageValue * (1.0f + Berserk.this.damageIncrease / 100.0f);
            }
        });
        return true;
    }

    public float getDamageIncrease() {
        return this.damageIncrease;
    }

    public void setDamageIncrease(float damageIncrease) {
        this.damageIncrease = damageIncrease;
    }

    public float getDamageTakenIncrease() {
        return this.damageTakenIncrease;
    }

    public void setDamageTakenIncrease(float damageTakenIncrease) {
        this.damageTakenIncrease = damageTakenIncrease;
    }
}

