/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.abilties;

import com.ebicep.warlords.abilties.internal.AbstractAbility;
import com.ebicep.warlords.effects.ParticleEffect;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.player.cooldowns.CooldownTypes;
import com.ebicep.warlords.util.java.Pair;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.bukkit.entity.Player;

public class AvengersWrath
extends AbstractAbility {
    protected int extraPlayersStruck = 0;
    private int duration = 12;

    public AvengersWrath() {
        super("Avenger's Wrath", 0.0f, 0.0f, 52.85f, 0, 0, 0);
    }

    @Override
    public void updateDescription(Player player) {
        this.description = "\u00a77Burst with incredible holy power,\n\u00a77causing your Avenger's Strikes to\n\u00a77hit up to \u00a7e2 \u00a77additional enemies\n\u00a77that are within \u00a7e5 \u00a77blocks of your\n\u00a77target. Your energy per second is\n\u00a77increased by \u00a7e20 \u00a77for the duration\n\u00a77of the effect. Lasts \u00a76" + this.duration + " \u00a77seconds.";
    }

    @Override
    public List<Pair<String, String>> getAbilityInfo() {
        ArrayList<Pair<String, String>> info = new ArrayList<Pair<String, String>>();
        info.add(new Pair<String, String>("Times Used", "" + this.timesUsed));
        info.add(new Pair<String, String>("Extra Players Struck", "" + this.extraPlayersStruck));
        return info;
    }

    @Override
    public boolean onActivate(@Nonnull WarlordsPlayer wp, @Nonnull Player player) {
        Utils.playGlobalSound(wp.getLocation(), "paladin.avengerswrath.activation", 2.0f, 1.0f);
        AvengersWrath tempAvengersWrath = new AvengersWrath();
        wp.getCooldownManager().addRegularCooldown(this.name, "WRATH", AvengersWrath.class, tempAvengersWrath, wp, CooldownTypes.ABILITY, cooldownManager -> {}, this.duration * 20, (cooldown, ticksLeft, counter) -> {
            if (counter % 4 == 0) {
                ParticleEffect.SPELL.display(0.3f, 0.1f, 0.3f, 0.2f, 6, wp.getLocation().add(0.0, 1.2, 0.0), 500.0);
            }
        });
        return true;
    }

    public void addExtraPlayersStruck() {
        ++this.extraPlayersStruck;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }
}

