/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.abilties;

import com.ebicep.warlords.abilties.AvengersWrath;
import com.ebicep.warlords.abilties.Consecrate;
import com.ebicep.warlords.abilties.internal.AbstractStrikeBase;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.util.java.Pair;
import com.ebicep.warlords.util.warlords.PlayerFilter;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.bukkit.entity.Player;

public class AvengersStrike
extends AbstractStrikeBase {
    protected float energyStole = 0.0f;
    private final int energySteal = 10;

    public AvengersStrike() {
        super("Avenger's Strike", 359.0f, 485.0f, 0.0f, 90, 25, 185);
    }

    @Override
    public void updateDescription(Player player) {
        this.description = "\u00a77Strike the targeted enemy player,\n\u00a77causing \u00a7c" + this.format(this.minDamageHeal) + " \u00a77- \u00a7c" + this.format(this.maxDamageHeal) + " \u00a77damage\n\u00a77and removing \u00a7e" + 10 + " \u00a77energy.";
    }

    @Override
    public List<Pair<String, String>> getAbilityInfo() {
        ArrayList<Pair<String, String>> info = new ArrayList<Pair<String, String>>();
        info.add(new Pair<String, String>("Players Struck", "" + this.timesUsed));
        info.add(new Pair<String, String>("Energy Removed", "" + Math.round(this.energyStole)));
        return info;
    }

    @Override
    protected void onHit(@Nonnull WarlordsPlayer wp, @Nonnull Player p, @Nonnull WarlordsPlayer nearPlayer) {
        if (this.standingOnConsecrate(wp, nearPlayer)) {
            wp.doOnStaticAbility(Consecrate.class, Consecrate::addStrikesBoosted);
            nearPlayer.addDamageInstance(wp, this.name, this.minDamageHeal * 1.2f, this.maxDamageHeal * 1.2f, this.critChance, this.critMultiplier, false);
        } else {
            nearPlayer.addDamageInstance(wp, this.name, this.minDamageHeal, this.maxDamageHeal, this.critChance, this.critMultiplier, false);
        }
        this.energyStole += nearPlayer.subtractEnergy(10);
        if (wp.getCooldownManager().hasCooldown(AvengersWrath.class)) {
            for (WarlordsPlayer wrathTarget : PlayerFilter.entitiesAround(nearPlayer, 5.0, 4.0, 5.0).aliveEnemiesOf(wp).closestFirst(nearPlayer).excluding(nearPlayer).limit(2L)) {
                wp.doOnStaticAbility(AvengersWrath.class, AvengersWrath::addExtraPlayersStruck);
                if (this.standingOnConsecrate(wp, wrathTarget)) {
                    wp.doOnStaticAbility(Consecrate.class, Consecrate::addStrikesBoosted);
                    wrathTarget.addDamageInstance(wp, this.name, this.minDamageHeal * 1.2f, this.maxDamageHeal * 1.2f, this.critChance, this.critMultiplier, false);
                } else {
                    wrathTarget.addDamageInstance(wp, this.name, this.minDamageHeal, this.maxDamageHeal, this.critChance, this.critMultiplier, false);
                }
                this.energyStole += wrathTarget.subtractEnergy(10);
            }
        }
    }
}

