/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.abilties;

import com.ebicep.warlords.abilties.internal.AbstractAbility;
import com.ebicep.warlords.effects.ParticleEffect;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.player.cooldowns.CooldownFilter;
import com.ebicep.warlords.player.cooldowns.CooldownManager;
import com.ebicep.warlords.player.cooldowns.CooldownTypes;
import com.ebicep.warlords.player.cooldowns.cooldowns.RegularCooldown;
import com.ebicep.warlords.util.java.Pair;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftPlayer;
import org.bukkit.entity.Player;

public class ArcaneShield
extends AbstractAbility {
    private int timesBroken = 0;
    private final int duration = 6;
    public int maxShieldHealth;
    public int shieldPercentage = 50;
    private float shieldHealth = 0.0f;

    public ArcaneShield() {
        super("Arcane Shield", 0.0f, 0.0f, 31.32f, 40, 0, 0);
    }

    public ArcaneShield(int shieldHealth) {
        super("Arcane Shield", 0.0f, 0.0f, 31.32f, 40, 0, 0);
        this.shieldHealth = shieldHealth;
    }

    @Override
    public void updateDescription(Player player) {
        this.description = "\u00a77Surround yourself with arcane\n\u00a77energy, creating a shield that will\n\u00a77absorb up to \u00a7e" + this.maxShieldHealth + " \u00a77(\u00a7e" + this.shieldPercentage + "% \u00a77of your maximum\n\u00a77health) incoming damage. Lasts \u00a76" + 6 + " \u00a77seconds.";
    }

    @Override
    public List<Pair<String, String>> getAbilityInfo() {
        ArrayList<Pair<String, String>> info = new ArrayList<Pair<String, String>>();
        info.add(new Pair<String, String>("Times Used", "" + this.timesUsed));
        info.add(new Pair<String, String>("Times Broken", "" + this.timesBroken));
        return info;
    }

    @Override
    public boolean onActivate(WarlordsPlayer wp, Player p) {
        wp.subtractEnergy(this.energyCost);
        Utils.playGlobalSound(wp.getLocation(), "mage.arcaneshield.activation", 2.0f, 1.0f);
        ArcaneShield tempArcaneShield = new ArcaneShield(this.maxShieldHealth);
        wp.getCooldownManager().addRegularCooldown(this.name, "ARCA", ArcaneShield.class, tempArcaneShield, wp, CooldownTypes.ABILITY, cooldownManager -> {
            if (new CooldownFilter<RegularCooldown>((CooldownManager)cooldownManager, RegularCooldown.class).filterCooldownClass(ArcaneShield.class).stream().count() == 1L && wp.getEntity() instanceof Player) {
                ((CraftPlayer)wp.getEntity()).getHandle().setAbsorptionHearts(0.0f);
            }
        }, 120, (cooldown, ticksLeft, counter) -> {
            if (counter % 3 == 0) {
                Location location = wp.getLocation();
                location.add(0.0, 1.5, 0.0);
                ParticleEffect.CLOUD.display(0.15f, 0.3f, 0.15f, 0.01f, 2, location, 500.0);
                ParticleEffect.FIREWORKS_SPARK.display(0.3f, 0.3f, 0.3f, 1.0E-4f, 1, location, 500.0);
                ParticleEffect.SPELL_WITCH.display(0.3f, 0.3f, 0.3f, 0.0f, 1, location, 500.0);
            }
        });
        ((CraftPlayer)p).getHandle().setAbsorptionHearts(20.0f);
        return true;
    }

    public void addTimesBroken() {
        ++this.timesBroken;
    }

    public int getTimesBroken() {
        return this.timesBroken;
    }

    public float getShieldHealth() {
        return this.shieldHealth;
    }

    public void addShieldHealth(float amount) {
        this.shieldHealth += amount;
    }

    public void setMaxShieldHealth(int maxShieldHealth) {
        this.maxShieldHealth = maxShieldHealth;
    }

    public int getShieldPercentage() {
        return this.shieldPercentage;
    }

    public void setShieldPercentage(int shieldPercentage) {
        this.shieldPercentage = shieldPercentage;
    }
}

