/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import co.aikar.taskchain.BukkitTaskChainFactory;
import co.aikar.taskchain.TaskChain;
import co.aikar.taskchain.TaskChainFactory;
import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.ebicep.customentities.npc.NPCManager;
import com.ebicep.jda.BotCommands;
import com.ebicep.jda.BotListener;
import com.ebicep.jda.BotManager;
import com.ebicep.jda.queuesystem.QueueCommand;
import com.ebicep.warlords.abilties.AvengersWrath;
import com.ebicep.warlords.abilties.HolyRadianceAvenger;
import com.ebicep.warlords.abilties.HolyRadianceCrusader;
import com.ebicep.warlords.abilties.InspiringPresence;
import com.ebicep.warlords.abilties.OrbsOfLife;
import com.ebicep.warlords.abilties.RecklessCharge;
import com.ebicep.warlords.abilties.Soulbinding;
import com.ebicep.warlords.abilties.UndyingArmy;
import com.ebicep.warlords.abilties.VitalityLiquor;
import com.ebicep.warlords.abilties.internal.AbstractAbility;
import com.ebicep.warlords.abilties.internal.EnergyPowerup;
import com.ebicep.warlords.abilties.internal.HealingPowerup;
import com.ebicep.warlords.abilties.internal.Overheal;
import com.ebicep.warlords.classes.rogue.specs.Apothecary;
import com.ebicep.warlords.commands.debugcommands.game.GameKillCommand;
import com.ebicep.warlords.commands.debugcommands.game.GameListCommand;
import com.ebicep.warlords.commands.debugcommands.game.GameStartCommand;
import com.ebicep.warlords.commands.debugcommands.game.GameTerminateCommand;
import com.ebicep.warlords.commands.debugcommands.game.PrivateGameTerminateCommand;
import com.ebicep.warlords.commands.debugcommands.ingame.DebugCommand;
import com.ebicep.warlords.commands.debugcommands.ingame.DebugModeCommand;
import com.ebicep.warlords.commands.debugcommands.ingame.ImposterCommand;
import com.ebicep.warlords.commands.debugcommands.ingame.RecordAverageDamageCommand;
import com.ebicep.warlords.commands.debugcommands.ingame.SpawnTestDummyCommand;
import com.ebicep.warlords.commands.debugcommands.ingame.ToggleAFKDetectionCommand;
import com.ebicep.warlords.commands.debugcommands.ingame.UnstuckCommand;
import com.ebicep.warlords.commands.debugcommands.misc.ExperienceCommand;
import com.ebicep.warlords.commands.debugcommands.misc.FindPlayerCommand;
import com.ebicep.warlords.commands.debugcommands.misc.GamesCommand;
import com.ebicep.warlords.commands.debugcommands.misc.GetPlayerLastAbilityStatsCommand;
import com.ebicep.warlords.commands.debugcommands.misc.GetPlayersCommand;
import com.ebicep.warlords.commands.debugcommands.misc.MuteCommand;
import com.ebicep.warlords.commands.debugcommands.misc.MyLocationCommand;
import com.ebicep.warlords.commands.debugcommands.misc.RecordGamesCommand;
import com.ebicep.warlords.commands.debugcommands.misc.ServerStatusCommand;
import com.ebicep.warlords.commands.debugcommands.misc.TestCommand;
import com.ebicep.warlords.commands.miscellaneouscommands.AchievementsCommand;
import com.ebicep.warlords.commands.miscellaneouscommands.ChatChannelCommand;
import com.ebicep.warlords.commands.miscellaneouscommands.ClassCommand;
import com.ebicep.warlords.commands.miscellaneouscommands.DiscordCommand;
import com.ebicep.warlords.commands.miscellaneouscommands.HotkeyModeCommand;
import com.ebicep.warlords.commands.miscellaneouscommands.LobbyCommand;
import com.ebicep.warlords.commands.miscellaneouscommands.MenuCommand;
import com.ebicep.warlords.commands.miscellaneouscommands.MessageCommand;
import com.ebicep.warlords.commands.miscellaneouscommands.ParticleQualityCommand;
import com.ebicep.warlords.commands.miscellaneouscommands.ResourcepackCommand;
import com.ebicep.warlords.commands.miscellaneouscommands.ShoutCommand;
import com.ebicep.warlords.commands.miscellaneouscommands.SpectateCommand;
import com.ebicep.warlords.database.DatabaseManager;
import com.ebicep.warlords.database.FutureMessageManager;
import com.ebicep.warlords.database.configuration.ApplicationConfiguration;
import com.ebicep.warlords.database.leaderboards.LeaderboardCommand;
import com.ebicep.warlords.effects.FireWorkEffectPlayer;
import com.ebicep.warlords.events.WarlordsEvents;
import com.ebicep.warlords.game.Game;
import com.ebicep.warlords.game.GameAddon;
import com.ebicep.warlords.game.GameManager;
import com.ebicep.warlords.game.GameMap;
import com.ebicep.warlords.game.Team;
import com.ebicep.warlords.game.option.marker.FlagHolder;
import com.ebicep.warlords.menu.MenuEventListener;
import com.ebicep.warlords.party.PartyCommand;
import com.ebicep.warlords.party.PartyListener;
import com.ebicep.warlords.party.PartyManager;
import com.ebicep.warlords.party.StreamCommand;
import com.ebicep.warlords.player.CustomScoreboard;
import com.ebicep.warlords.player.PlayerSettings;
import com.ebicep.warlords.player.SkillBoosts;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.player.Weapons;
import com.ebicep.warlords.player.cooldowns.AbstractCooldown;
import com.ebicep.warlords.player.cooldowns.CooldownFilter;
import com.ebicep.warlords.player.cooldowns.CooldownManager;
import com.ebicep.warlords.player.cooldowns.cooldowns.PersistentCooldown;
import com.ebicep.warlords.player.cooldowns.cooldowns.RegularCooldown;
import com.ebicep.warlords.poll.PollCommand;
import com.ebicep.warlords.util.bukkit.LocationBuilder;
import com.ebicep.warlords.util.bukkit.LocationFactory;
import com.ebicep.warlords.util.bukkit.PacketUtils;
import com.ebicep.warlords.util.bukkit.RemoveEntities;
import com.ebicep.warlords.util.bukkit.signgui.SignGUI;
import com.ebicep.warlords.util.chat.ChatChannels;
import com.ebicep.warlords.util.warlords.GameRunnable;
import com.ebicep.warlords.util.warlords.PlayerFilter;
import com.ebicep.warlords.util.warlords.Utils;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.login.LoginException;
import me.filoghost.holographicdisplays.api.beta.HolographicDisplaysAPI;
import me.filoghost.holographicdisplays.api.beta.hologram.Hologram;
import net.minecraft.server.v1_8_R3.PacketPlayInSteerVehicle;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.SkullType;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.craftbukkit.v1_8_R3.CraftServer;
import org.bukkit.craftbukkit.v1_8_R3.inventory.CraftItemStack;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.slf4j.LoggerFactory;

public class Warlords
extends JavaPlugin {
    public static final HashMap<UUID, Location> spawnPoints = new HashMap();
    public static final PartyManager partyManager = new PartyManager();
    private static final HashMap<UUID, WarlordsPlayer> players = new HashMap();
    private static final HashMap<UUID, PlayerSettings> playerSettings = new HashMap();
    private static final HashMap<UUID, net.minecraft.server.v1_8_R3.ItemStack> playerHeads = new HashMap();
    public static String VERSION = "";
    public static String serverIP;
    public static boolean holographicDisplaysEnabled;
    public static boolean citizensEnabled;
    public static HashMap<UUID, ChatChannels> playerChatChannels;
    public static HashMap<UUID, CustomScoreboard> playerScoreboards;
    private static Warlords instance;
    private static TaskChainFactory taskChainFactory;
    public Location npcCTFLocation;
    private GameManager gameManager;
    private int counter = 0;

    public static Warlords getInstance() {
        return instance;
    }

    public static <T> TaskChain<T> newChain() {
        return taskChainFactory.newChain();
    }

    public static <T> TaskChain<T> newSharedChain(String name) {
        return taskChainFactory.newSharedChain(name);
    }

    public static HashMap<UUID, WarlordsPlayer> getPlayers() {
        return players;
    }

    public static void addPlayer(@Nonnull WarlordsPlayer warlordsPlayer) {
        players.put(warlordsPlayer.getUuid(), warlordsPlayer);
        for (GameAddon addon : warlordsPlayer.getGame().getAddons()) {
            addon.warlordsPlayerCreated(warlordsPlayer.getGame(), warlordsPlayer);
        }
    }

    @Nullable
    public static WarlordsPlayer getPlayer(@Nullable Entity entity) {
        Optional<MetadataValue> metadata;
        if (entity != null && (metadata = entity.getMetadata("WARLORDS_PLAYER").stream().filter(e -> e.value() instanceof WarlordsPlayer).findAny()).isPresent()) {
            return (WarlordsPlayer)metadata.get().value();
        }
        return null;
    }

    @Nullable
    public static WarlordsPlayer getPlayer(@Nullable OfflinePlayer player) {
        return player == null ? null : Warlords.getPlayer(player.getUniqueId());
    }

    @Nullable
    public static WarlordsPlayer getPlayer(@Nullable Player player) {
        return Warlords.getPlayer((OfflinePlayer)player);
    }

    @Nullable
    public static WarlordsPlayer getPlayer(@Nonnull UUID player) {
        return players.get(player);
    }

    public static boolean hasPlayer(@Nonnull OfflinePlayer player) {
        return Warlords.hasPlayer(player.getUniqueId());
    }

    public static boolean hasPlayer(@Nonnull UUID player) {
        return players.containsKey(player);
    }

    public static void removePlayer(@Nonnull UUID player) {
        WarlordsPlayer wp = players.remove(player);
        if (wp != null) {
            if (!(wp.getEntity() instanceof Player)) {
                wp.getEntity().remove();
            }
            FlagHolder.dropFlagForPlayer(wp);
            wp.getCooldownManager().clearAllCooldowns();
        }
        Location loc = spawnPoints.remove(player);
        Player p = Bukkit.getPlayer((UUID)player);
        if (p != null) {
            p.removeMetadata("WARLORDS_PLAYER", (Plugin)Warlords.getInstance());
            if (loc != null) {
                p.teleport(Warlords.getRejoinPoint(player));
            }
        }
    }

    @Nonnull
    public static Location getRejoinPoint(@Nonnull UUID key) {
        return spawnPoints.getOrDefault(key, new LocationBuilder(((World)Bukkit.getWorlds().get(0)).getSpawnLocation()).yaw(-90.0f).get());
    }

    public static void setRejoinPoint(@Nonnull UUID key, @Nonnull Location value) {
        spawnPoints.put(key, value);
        Player player = Bukkit.getPlayer((UUID)key);
        if (player != null) {
            player.teleport(value);
        }
    }

    @Nonnull
    public static PlayerSettings getPlayerSettings(@Nonnull UUID key) {
        PlayerSettings settings = playerSettings.computeIfAbsent(key, k -> new PlayerSettings());
        return settings;
    }

    public static HashMap<UUID, net.minecraft.server.v1_8_R3.ItemStack> getPlayerHeads() {
        return playerHeads;
    }

    public static void updateHeads() {
        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
            Warlords.updateHead(onlinePlayer);
        }
        System.out.println("[Warlords] Heads updated");
    }

    public static void updateHead(Player player) {
        ItemStack playerSkull = new ItemStack(Material.SKULL_ITEM, 1, (short)SkullType.PLAYER.ordinal());
        SkullMeta skullMeta = (SkullMeta)playerSkull.getItemMeta();
        skullMeta.setOwner(player.getName());
        playerSkull.setItemMeta((ItemMeta)skullMeta);
        playerHeads.put(player.getUniqueId(), CraftItemStack.asNMSCopy((ItemStack)playerSkull));
    }

    public static ItemStack getHead(Player player) {
        return Warlords.getHead(player.getUniqueId());
    }

    public static ItemStack getHead(UUID uuid) {
        if (playerHeads.containsKey(uuid)) {
            return CraftItemStack.asBukkitCopy((net.minecraft.server.v1_8_R3.ItemStack)playerHeads.get(uuid));
        }
        ItemStack playerSkull = new ItemStack(Material.SKULL_ITEM, 1, (short)SkullType.PLAYER.ordinal());
        SkullMeta skullMeta = (SkullMeta)playerSkull.getItemMeta();
        skullMeta.setOwner(Bukkit.getOfflinePlayer((UUID)uuid).getName());
        playerSkull.setItemMeta((ItemMeta)skullMeta);
        playerHeads.put(uuid, CraftItemStack.asNMSCopy((ItemStack)playerSkull));
        return playerSkull;
    }

    public static GameManager getGameManager() {
        return Warlords.getInstance().gameManager;
    }

    public void readKeysConfig() {
        try {
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)new File(this.getDataFolder(), "keys.yml"));
            ApplicationConfiguration.key = config.getString("database_key");
            BotManager.botToken = config.getString("botToken");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void readWeaponConfig() {
        try {
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)new File(this.getDataFolder(), "weapons.yml"));
            for (String key : config.getKeys(false)) {
                Weapons.getWeapon((String)key).isUnlocked = config.getBoolean(key);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveWeaponConfig() {
        try {
            YamlConfiguration config = new YamlConfiguration();
            for (Weapons weapons : Weapons.values()) {
                config.set(weapons.getName(), (Object)weapons.isUnlocked);
            }
            config.save(new File(this.getDataFolder(), "weapons.yml"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onEnable() {
        instance = this;
        VERSION = this.getDescription().getVersion();
        serverIP = this.getServer().getIp();
        taskChainFactory = BukkitTaskChainFactory.create((Plugin)this);
        this.gameManager = new GameManager();
        this.gameManager.addGameHolder("Rift-0", GameMap.RIFT, new LocationFactory(Bukkit.getWorld((String)"Rift-0")));
        this.gameManager.addGameHolder("Rift-1", GameMap.RIFT, new LocationFactory(Bukkit.getWorld((String)"Rift-1")));
        this.gameManager.addGameHolder("Rift-2", GameMap.RIFT, new LocationFactory(Bukkit.getWorld((String)"Rift-2")));
        this.gameManager.addGameHolder("Crossfire-0", GameMap.CROSSFIRE, new LocationFactory(Bukkit.getWorld((String)"Crossfire-0")));
        this.gameManager.addGameHolder("Crossfire-1", GameMap.CROSSFIRE, new LocationFactory(Bukkit.getWorld((String)"Crossfire-1")));
        this.gameManager.addGameHolder("Crossfire-2", GameMap.CROSSFIRE, new LocationFactory(Bukkit.getWorld((String)"Crossfire-2")));
        this.gameManager.addGameHolder("Valley-0", GameMap.VALLEY, new LocationFactory(Bukkit.getWorld((String)"Atherrough_Valley-0")));
        this.gameManager.addGameHolder("Valley-1", GameMap.VALLEY, new LocationFactory(Bukkit.getWorld((String)"Atherrough_Valley-1")));
        this.gameManager.addGameHolder("Valley-2", GameMap.VALLEY, new LocationFactory(Bukkit.getWorld((String)"Atherrough_Valley-2")));
        this.gameManager.addGameHolder("Warsong-0", GameMap.WARSONG, new LocationFactory(Bukkit.getWorld((String)"Warsong-0")));
        this.gameManager.addGameHolder("Warsong-1", GameMap.WARSONG, new LocationFactory(Bukkit.getWorld((String)"Warsong-1")));
        this.gameManager.addGameHolder("Warsong-2", GameMap.WARSONG, new LocationFactory(Bukkit.getWorld((String)"Warsong-2")));
        this.gameManager.addGameHolder("Aperture-0", GameMap.APERTURE, new LocationFactory(Bukkit.getWorld((String)"Aperture-0")));
        this.gameManager.addGameHolder("Aperture-1", GameMap.APERTURE, new LocationFactory(Bukkit.getWorld((String)"Aperture-1")));
        this.gameManager.addGameHolder("Aperture-2", GameMap.APERTURE, new LocationFactory(Bukkit.getWorld((String)"Aperture-2")));
        this.gameManager.addGameHolder("Arathi-0", GameMap.ARATHI, new LocationFactory(Bukkit.getWorld((String)"Arathi-0")));
        this.gameManager.addGameHolder("Arathi-1", GameMap.ARATHI, new LocationFactory(Bukkit.getWorld((String)"Arathi-1")));
        this.gameManager.addGameHolder("Arathi-2", GameMap.ARATHI, new LocationFactory(Bukkit.getWorld((String)"Arathi-2")));
        Thread.currentThread().setContextClassLoader(this.getClassLoader());
        this.getServer().getPluginManager().registerEvents((Listener)new WarlordsEvents(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new MenuEventListener((Plugin)this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PartyListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new BotListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new RecklessCharge(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new FutureMessageManager(), (Plugin)this);
        this.registerCommands();
        Warlords.updateHeads();
        this.readKeysConfig();
        this.readWeaponConfig();
        this.saveWeaponConfig();
        TimeZone.setDefault(TimeZone.getTimeZone("America/New_York"));
        holographicDisplaysEnabled = Bukkit.getPluginManager().isPluginEnabled("HolographicDisplays");
        citizensEnabled = Bukkit.getPluginManager().isPluginEnabled("Citizens");
        Bukkit.getOnlinePlayers().forEach(player -> playerScoreboards.put(player.getUniqueId(), new CustomScoreboard((Player)player)));
        Warlords.newChain().async(DatabaseManager::init).execute();
        try {
            BotManager.connect();
        }
        catch (LoginException e) {
            e.printStackTrace();
        }
        ProtocolManager protocolManager = ProtocolLibrary.getProtocolManager();
        protocolManager.removePacketListeners((Plugin)this);
        protocolManager.addPacketListener((PacketListener)new PacketAdapter((Plugin)this, ListenerPriority.HIGHEST, new PacketType[]{PacketType.Play.Server.WORLD_PARTICLES}){
            int counter;
            {
                this.counter = 0;
            }

            public void onPacketSending(PacketEvent event) {
                Player player;
                if (event.getPacketType() == PacketType.Play.Server.WORLD_PARTICLES && Warlords.hasPlayer((OfflinePlayer)(player = event.getPlayer())) && this.counter++ % ((PlayerSettings)playerSettings.get((Object)player.getUniqueId())).getParticleQuality().particleReduction == 0) {
                    event.setCancelled(true);
                }
            }
        });
        protocolManager.addPacketListener((PacketListener)new PacketAdapter((Plugin)this, ListenerPriority.LOWEST, new PacketType[]{PacketType.Play.Client.STEER_VEHICLE}){

            public void onPacketReceiving(PacketEvent e) {
                if (e.getPacketType() == PacketType.Play.Client.STEER_VEHICLE && e.getPacket().getHandle() instanceof PacketPlayInSteerVehicle) {
                    boolean dismount = (Boolean)e.getPacket().getBooleans().read(1);
                    try {
                        Field f = PacketPlayInSteerVehicle.class.getDeclaredField("d");
                        f.setAccessible(true);
                        f.set(e.getPacket().getHandle(), false);
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                    if (dismount && e.getPlayer().getVehicle() != null) {
                        e.getPlayer().getVehicle().remove();
                    }
                }
            }
        });
        SignGUI.init(this);
        this.startMainLoop();
        this.getServer().getConsoleSender().sendMessage(ChatColor.GREEN + "[Warlords] Plugin is enabled");
        for (String command : this.getDescription().getCommands().keySet()) {
            if (this.getCommand(command).getExecutor() != this) continue;
            this.getServer().getConsoleSender().sendMessage(ChatColor.GOLD + "[Warlords] Warning, command " + command + " is specified in plugin.yml, but not defined in the plugins");
        }
        Bukkit.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, "Warlords");
    }

    public void onDisable() {
        if (BotManager.task != null) {
            BotManager.task.cancel();
        }
        try {
            for (Player player : Bukkit.getOnlinePlayers()) {
                player.removePotionEffect(PotionEffectType.BLINDNESS);
                player.getActivePotionEffects().clear();
                player.removeMetadata("WARLORDS_PLAYER", (Plugin)this);
                PacketUtils.sendTitle(player, "", "", 0, 0, 0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            CraftServer server = (CraftServer)Bukkit.getServer();
            server.getEntityMetadata().invalidateAll((Plugin)this);
            server.getWorldMetadata().invalidateAll((Plugin)this);
            server.getPlayerMetadata().invalidateAll((Plugin)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.gameManager.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (holographicDisplaysEnabled) {
                HolographicDisplaysAPI.get((Plugin)instance).getHolograms().forEach(Hologram::delete);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            NPCManager.gameStartNPC.destroy();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            Bukkit.getWorld((String)"MainLobby").getEntities().stream().filter(entity -> entity.getName().equals("capture-the-flag")).forEach(Entity::remove);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            BotManager.deleteStatusMessage();
            BotManager.jda.shutdownNow();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            SignGUI.destroy();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.getServer().getConsoleSender().sendMessage(ChatColor.RED + "[Warlords] Plugin is disabled");
    }

    private void startMainLoop() {
        new BukkitRunnable(){

            public void run() {
                Player player;
                for (final WarlordsPlayer wp2 : players.values()) {
                    float newHealth;
                    boolean hasTooMuchHealth;
                    Player player2 = player = wp2.getEntity() instanceof Player ? (Player)wp2.getEntity() : null;
                    if (player != null) {
                        if (player.getInventory().getHeldItemSlot() != 8) {
                            wp2.displayActionBar();
                        } else {
                            wp2.displayFlagActionBar(player);
                        }
                    }
                    if (wp2.getGame().isFrozen()) continue;
                    wp2.getSpeed().updateSpeed();
                    if (wp2.getSpec() instanceof Apothecary) {
                        wp2.getSpeed().addSpeedModifier("Base Speed", 23, 1, "BASE");
                    }
                    CooldownManager cooldownManager = wp2.getCooldownManager();
                    if (player != null && wp2.getCompassTarget() != null) {
                        player.setCompassTarget(wp2.getCompassTarget().getLocation());
                    }
                    if (wp2.isDisableCooldowns()) {
                        wp2.getSpec().getRed().setCurrentCooldown(0.0f);
                        wp2.getSpec().getPurple().setCurrentCooldown(0.0f);
                        wp2.getSpec().getBlue().setCurrentCooldown(0.0f);
                        wp2.getSpec().getOrange().setCurrentCooldown(0.0f);
                        wp2.setHorseCooldown(0.0f);
                        wp2.updateRedItem();
                        wp2.updatePurpleItem();
                        wp2.updateBlueItem();
                        wp2.updateOrangeItem();
                        wp2.updateHorseItem();
                    }
                    if (wp2.getSpec().getRed().getCurrentCooldown() > 0.0f) {
                        wp2.getSpec().getRed().subtractCooldown(0.05f);
                        if (player != null) {
                            wp2.updateRedItem(player);
                        }
                    }
                    if (wp2.getSpec().getPurple().getCurrentCooldown() > 0.0f) {
                        wp2.getSpec().getPurple().subtractCooldown(0.05f);
                        if (player != null) {
                            wp2.updatePurpleItem(player);
                        }
                    }
                    if (wp2.getSpec().getBlue().getCurrentCooldown() > 0.0f) {
                        wp2.getSpec().getBlue().subtractCooldown(0.05f);
                        if (player != null) {
                            wp2.updateBlueItem(player);
                        }
                    }
                    if (wp2.getSpec().getOrange().getCurrentCooldown() > 0.0f) {
                        wp2.getSpec().getOrange().subtractCooldown(0.05f);
                        if (player != null) {
                            wp2.updateOrangeItem(player);
                        }
                    }
                    if (wp2.getHorseCooldown() > 0.0f && !wp2.getEntity().isInsideVehicle()) {
                        wp2.setHorseCooldown(wp2.getHorseCooldown() - 0.05f);
                        if (player != null) {
                            wp2.updateHorseItem(player);
                        }
                    }
                    wp2.getCooldownManager().reduceCooldowns();
                    for (AbstractAbility abstractAbility : wp2.getSpec().getAbilities()) {
                        abstractAbility.checkSecondaryAbilities();
                        if (!wp2.isSneaking() || wp2.isWasSneaking()) continue;
                        abstractAbility.runSecondAbilities();
                    }
                    wp2.setWasSneaking(wp2.isSneaking());
                    boolean hasOverhealCooldown = wp2.getCooldownManager().hasCooldown(Overheal.OVERHEAL_MARKER);
                    boolean bl = hasTooMuchHealth = wp2.getHealth() > wp2.getMaxHealth();
                    if (hasOverhealCooldown && !hasTooMuchHealth) {
                        wp2.getCooldownManager().removeCooldownByObject(Overheal.OVERHEAL_MARKER);
                    }
                    if (!hasOverhealCooldown && hasTooMuchHealth) {
                        wp2.setHealth(wp2.getMaxHealth());
                    }
                    if (wp2.getCooldownManager().hasCooldownFromName("Vindicate Debuff Immunity")) {
                        wp2.getSpeed().removeSlownessModifiers();
                        wp2.getCooldownManager().removeDebuffCooldowns();
                    }
                    if ((newHealth = (float)wp2.getHealth() / (float)wp2.getMaxHealth() * 40.0f) < 0.0f) {
                        newHealth = 0.0f;
                    } else if (newHealth > 40.0f) {
                        newHealth = 40.0f;
                    }
                    if (wp2.getCooldownManager().checkUndyingArmy(false) && newHealth <= 0.0f) {
                        for (Object undyingArmyCooldown : new CooldownFilter<RegularCooldown>(wp2, RegularCooldown.class).filterCooldownClass(UndyingArmy.class).stream().collect(Collectors.toList())) {
                            UndyingArmy undyingArmy = (UndyingArmy)((AbstractCooldown)undyingArmyCooldown).getCooldownObject();
                            if (undyingArmy.isArmyDead(wp2)) continue;
                            undyingArmy.pop(wp2);
                            FlagHolder.dropFlagForPlayer(wp2);
                            if (((AbstractCooldown)undyingArmyCooldown).getFrom() == wp2) {
                                wp2.sendMessage("\u00a7a\u00bb\u00a77 " + ChatColor.LIGHT_PURPLE + "Your Undying Army revived you with temporary health. Fight until your death! Your health will decay by " + ChatColor.RED + wp2.getMaxHealth() / 10 + ChatColor.LIGHT_PURPLE + " every second.");
                            } else {
                                wp2.sendMessage("\u00a7a\u00bb\u00a77 " + ChatColor.LIGHT_PURPLE + ((AbstractCooldown)undyingArmyCooldown).getFrom().getName() + "'s Undying Army revived you with temporary health. Fight until your death! Your health will decay by " + ChatColor.RED + wp2.getMaxHealth() / 10 + ChatColor.LIGHT_PURPLE + " every second.");
                            }
                            FireWorkEffectPlayer.playFirework(wp2.getLocation(), FireworkEffect.builder().withColor(Color.LIME).with(FireworkEffect.Type.BALL).build());
                            wp2.heal();
                            if (player != null) {
                                player.getWorld().spigot().strikeLightningEffect(wp2.getLocation(), false);
                                player.getInventory().setItem(5, UndyingArmy.BONE);
                            }
                            newHealth = 40.0f;
                            if (wp2.getEnergy() < wp2.getMaxEnergy() / 2.0f) {
                                wp2.setEnergy(wp2.getMaxEnergy() / 2.0f);
                            }
                            new GameRunnable(wp2.getGame()){

                                @Override
                                public void run() {
                                    if (wp2.getRespawnTimer() >= 0 || wp2.isDead()) {
                                        this.cancel();
                                    } else {
                                        wp2.addDamageInstance(wp2, "", (float)wp2.getMaxHealth() / 10.0f, (float)wp2.getMaxHealth() / 10.0f, -1, 100, false);
                                    }
                                }
                            }.runTaskTimer(0L, 20L);
                            break;
                        }
                    }
                    if (player != null && newHealth > 0.0f && newHealth <= 40.0f) {
                        player.setHealth((double)newHealth);
                    }
                    if (player != null && wp2.getHealth() <= 0 && player.getGameMode() == GameMode.SPECTATOR) {
                        wp2.heal();
                    }
                    if (wp2.getEnergy() < wp2.getMaxEnergy()) {
                        float newEnergy;
                        Object undyingArmyCooldown;
                        float f = (float)wp2.getSpec().getEnergyPerSec() / 20.0f;
                        for (RegularCooldown regularCooldown : new CooldownFilter<RegularCooldown>(cooldownManager, RegularCooldown.class).filterCooldownClass(AvengersWrath.class).stream().collect(Collectors.toList())) {
                            f += 1.0f;
                        }
                        for (RegularCooldown regularCooldown : new CooldownFilter<RegularCooldown>(cooldownManager, RegularCooldown.class).filterCooldownClass(InspiringPresence.class).stream().collect(Collectors.toList())) {
                            f = (float)((double)f + 0.5);
                        }
                        for (RegularCooldown regularCooldown : new CooldownFilter<RegularCooldown>(cooldownManager, RegularCooldown.class).filterCooldownClass(HolyRadianceAvenger.class).stream().collect(Collectors.toList())) {
                            f = (float)((double)f - 0.4);
                        }
                        for (RegularCooldown regularCooldown : new CooldownFilter<RegularCooldown>(cooldownManager, RegularCooldown.class).filterCooldownClass(HolyRadianceCrusader.class).stream().collect(Collectors.toList())) {
                            f = (float)((double)f + 0.3);
                        }
                        undyingArmyCooldown = new CooldownFilter<RegularCooldown>(cooldownManager, RegularCooldown.class).filterCooldownClass(VitalityLiquor.class).stream().collect(Collectors.toList()).iterator();
                        while (undyingArmyCooldown.hasNext()) {
                            RegularCooldown regularCooldown;
                            regularCooldown = (RegularCooldown)undyingArmyCooldown.next();
                            f = (float)((double)f + 0.75);
                        }
                        if (cooldownManager.hasCooldown(EnergyPowerup.class)) {
                            f = (float)((double)f * 1.4);
                        }
                        if ((newEnergy = wp2.getEnergy() + f) > wp2.getMaxEnergy()) {
                            newEnergy = wp2.getMaxEnergy();
                        }
                        wp2.setEnergy(newEnergy);
                    }
                    if (player != null) {
                        if (wp2.getEnergy() < 0.0f) {
                            wp2.setEnergy(1.0f);
                        }
                        player.setLevel((int)wp2.getEnergy());
                        player.setExp(wp2.getEnergy() / wp2.getMaxEnergy());
                    }
                    if (wp2.getHitCooldown() > 0) {
                        wp2.setHitCooldown(wp2.getHitCooldown() - 1);
                    }
                    Location location = wp2.getLocation();
                    ArrayList orbs = new ArrayList();
                    PlayerFilter.playingGame(wp2.getGame()).teammatesOf(wp2).forEach((Consumer<? super WarlordsPlayer>)((Consumer<WarlordsPlayer>)p -> new CooldownFilter<PersistentCooldown>((WarlordsPlayer)p, PersistentCooldown.class).filterCooldownClassAndMapToObjectsOfClass(OrbsOfLife.class).forEachOrdered(orbsOfLife -> orbs.addAll(orbsOfLife.getSpawnedOrbs()))));
                    Iterator itr = orbs.iterator();
                    while (itr.hasNext()) {
                        OrbsOfLife.Orb orb = (OrbsOfLife.Orb)((Object)itr.next());
                        Location orbPosition = orb.getArmorStand().getLocation();
                        if ((orb.getPlayerToMoveTowards() == null || orb.getPlayerToMoveTowards() != null && orb.getPlayerToMoveTowards() == wp2) && orbPosition.distanceSquared(location) < 1.8225000000000002 && !wp2.isDead()) {
                            orb.remove();
                            itr.remove();
                            float orbHeal = OrbsOfLife.ORB_HEALING;
                            if (Warlords.getPlayerSettings(orb.getOwner().getUuid()).getSkillBoostForClass() == SkillBoosts.ORBS_OF_LIFE) {
                                orbHeal = (float)((double)orbHeal * 1.2);
                            }
                            if (orb.getPlayerToMoveTowards() == null) {
                                orbHeal *= 1.0f + (float)orb.getTicksLived() / 325.0f;
                            }
                            wp2.addHealingInstance(orb.getOwner(), "Orbs of Life", orbHeal, orbHeal, -1, 100, false, false);
                            if (player != null) {
                                Utils.playGlobalSound(player.getLocation(), Sound.ORB_PICKUP, 0.2f, 1.0f);
                            }
                            for (WarlordsPlayer nearPlayer : PlayerFilter.entitiesAround(wp2, 6.0, 6.0, 6.0).aliveTeammatesOfExcludingSelf(wp2).limit(2L)) {
                                nearPlayer.addHealingInstance(orb.getOwner(), "Orbs of Life", orbHeal, orbHeal, -1, 100, false, false);
                                if (player == null) continue;
                                Utils.playGlobalSound(player.getLocation(), Sound.ORB_PICKUP, 0.2f, 1.0f);
                            }
                        }
                        if (orb.getBukkitEntity().getTicksLived() <= 160 && (orb.getPlayerToMoveTowards() == null || !orb.getPlayerToMoveTowards().isDead())) continue;
                        orb.remove();
                        itr.remove();
                    }
                    if (player == null) continue;
                    wp2.setBlocksTravelledCM(Utils.getPlayerMovementStatistics(player));
                }
                if (Warlords.this.counter % 10 == 0) {
                    for (WarlordsPlayer wps : players.values()) {
                        new CooldownFilter<PersistentCooldown>(wps, PersistentCooldown.class).filterCooldownClassAndMapToObjectsOfClass(Soulbinding.class).forEachOrdered(soulbinding -> soulbinding.getSoulBindedPlayers().forEach(Soulbinding.SoulBoundPlayer::decrementTimeLeft));
                        new CooldownFilter<PersistentCooldown>(wps, PersistentCooldown.class).filterCooldownClassAndMapToObjectsOfClass(Soulbinding.class).forEachOrdered(soulbinding -> soulbinding.getSoulBindedPlayers().removeIf(boundPlayer -> boundPlayer.getTimeLeft() == 0.0f || boundPlayer.isHitWithSoul() && boundPlayer.isHitWithLink()));
                    }
                }
                if (Warlords.this.counter % 20 == 0) {
                    RemoveEntities.removeHorsesInGame();
                    for (WarlordsPlayer wps : players.values()) {
                        if (wps.getGame().isFrozen()) continue;
                        wps.runEverySecond();
                        Player player3 = player = wps.getEntity() instanceof Player ? (Player)wps.getEntity() : null;
                        if (wps.getRegenTimer() != 0) {
                            wps.setRegenTimer(wps.getRegenTimer() - 1);
                            if (wps.getRegenTimer() == 0) {
                                wps.getHitBy().clear();
                            }
                        } else {
                            int healthToAdd = (int)((double)wps.getMaxHealth() / 55.3);
                            wps.setHealth(Math.max(wps.getHealth(), Math.min(wps.getHealth() + healthToAdd, wps.getMaxHealth())));
                        }
                        if (wps.getFlagDropCooldown() > 0) {
                            wps.setFlagDropCooldown(wps.getFlagDropCooldown() - 1);
                        }
                        if (wps.getFlagPickCooldown() > 0) {
                            wps.setFlagPickCooldown(wps.getFlagPickCooldown() - 1);
                        }
                        if (wps.getCooldownManager().hasCooldown(HealingPowerup.class)) {
                            int heal = (int)((double)wps.getMaxHealth() * 0.08);
                            if (wps.getHealth() + heal > wps.getMaxHealth()) {
                                heal = wps.getMaxHealth() - wps.getHealth();
                            }
                            if (heal != 0) {
                                wps.setHealth(wps.getHealth() + heal);
                                wps.sendMessage(WarlordsPlayer.GIVE_ARROW_GREEN + " \u00a77Healed \u00a7a" + heal + " \u00a77health.");
                            }
                        }
                        if (wps.getRegenTimer() > 6) {
                            wps.getMinuteStats().addTimeInCombat();
                        }
                        wps.getHitBy().replaceAll((wp, integer) -> integer - 1);
                        wps.getHealedBy().replaceAll((wp, integer) -> integer - 1);
                        wps.getHitBy().entrySet().removeIf(p -> (Integer)p.getValue() <= 0);
                        wps.getHealedBy().entrySet().removeIf(p -> (Integer)p.getValue() <= 0);
                    }
                    WarlordsEvents.entityList.removeIf(e -> !e.isValid());
                }
                if (Warlords.this.counter % 50 == 0) {
                    for (WarlordsPlayer warlordsPlayer : players.values()) {
                        if (warlordsPlayer.getGame().isFrozen()) continue;
                        player = warlordsPlayer.getEntity();
                        List<Location> locations = warlordsPlayer.getLocations();
                        if (warlordsPlayer.isDead() && !locations.isEmpty()) {
                            locations.add(locations.get(locations.size() - 1));
                            continue;
                        }
                        locations.add(player.getLocation());
                    }
                }
                Warlords.this.counter++;
            }
        }.runTaskTimer((Plugin)this, 0L, 0L);
    }

    public int getCounter() {
        return this.counter;
    }

    private void registerCommands() {
        new GameStartCommand().register(this);
        new GameTerminateCommand().register(this);
        new PrivateGameTerminateCommand().register(this);
        new GameKillCommand().register(this);
        new GameListCommand().register(this);
        new MenuCommand().register(this);
        new ShoutCommand().register(this);
        new HotkeyModeCommand().register(this);
        new DebugCommand().register(this);
        new ClassCommand().register(this);
        new GetPlayersCommand().register(this);
        new TestCommand().register(this);
        new ParticleQualityCommand().register(this);
        new SpawnTestDummyCommand().register(this);
        new PartyCommand().register(this);
        new StreamCommand().register(this);
        new RecordAverageDamageCommand().register(this);
        new ChatChannelCommand().register(this);
        new BotCommands().register(this);
        new LeaderboardCommand().register(this);
        new RecordGamesCommand().register(this);
        new GamesCommand().register(this);
        new SpectateCommand().register(this);
        new DebugModeCommand().register(this);
        new MyLocationCommand().register(this);
        new MessageCommand().register(this);
        new ExperienceCommand().register(this);
        new QueueCommand().register(this);
        new ImposterCommand().register(this);
        new LobbyCommand().register(this);
        new DiscordCommand().register(this);
        new PollCommand().register(this);
        new AchievementsCommand().register(this);
        new FindPlayerCommand().register(this);
        new MuteCommand().register(this);
        new ResourcepackCommand().register(this);
        new GetPlayerLastAbilityStatsCommand().register(this);
        new ToggleAFKDetectionCommand().register(this);
        new ServerStatusCommand().register(this);
        new UnstuckCommand().register(this);
    }

    private Map<UUID, Game> getPlayersToGame() {
        HashMap<UUID, Game> players = new HashMap<UUID, Game>();
        for (GameManager.GameHolder holder : this.gameManager.getGames()) {
            Game game = holder.getGame();
            if (game == null) continue;
            for (Map.Entry<UUID, Team> e : Utils.iterable(game.players())) {
                players.put(e.getKey(), game);
            }
        }
        return players;
    }

    public void hideAndUnhidePeople(@Nonnull Player player) {
        Map<UUID, Game> players = this.getPlayersToGame();
        Game game = players.get(player.getUniqueId());
        for (Player p : Bukkit.getOnlinePlayers()) {
            Game game1 = players.get(p.getUniqueId());
            if (p == player) continue;
            if (game1 == game) {
                p.showPlayer(player);
                player.showPlayer(p);
                continue;
            }
            p.hidePlayer(player);
            player.hidePlayer(p);
        }
    }

    public void hideAndUnhidePeople() {
        Map<UUID, Game> players = this.getPlayersToGame();
        ArrayList peeps = new ArrayList(Bukkit.getOnlinePlayers());
        int length = peeps.size();
        for (int i = 0; i < length - 1; ++i) {
            Player player = (Player)peeps.get(i);
            Game game = players.get(player.getUniqueId());
            for (int j = i + 1; j < length; ++j) {
                Player p = (Player)peeps.get(j);
                Game game1 = players.get(p.getUniqueId());
                if (game1 == game) {
                    p.showPlayer(player);
                    player.showPlayer(p);
                    continue;
                }
                p.hidePlayer(player);
                player.hidePlayer(p);
            }
        }
    }

    public static boolean onCustomServer() {
        return !serverIP.equals("51.81.49.127");
    }

    static {
        playerChatChannels = new HashMap();
        playerScoreboards = new HashMap();
        ((Logger)LoggerFactory.getLogger("org.mongodb.driver")).setLevel(Level.ERROR);
        ((Logger)LoggerFactory.getLogger("org.springframework")).setLevel(Level.ERROR);
        ((Logger)LoggerFactory.getLogger("net.dv8tion.jda")).setLevel(Level.ERROR);
    }
}

