/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.jda.queuesystem;

import com.ebicep.jda.queuesystem.QueueManager;
import com.ebicep.warlords.Warlords;
import org.apache.commons.lang.math.NumberUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class QueueCommand
implements CommandExecutor {
    public boolean onCommand(CommandSender sender, Command command, String s2, String[] args) {
        if (args.length == 0) {
            sender.sendMessage(QueueManager.getQueue());
            return true;
        }
        Player player = (Player)sender;
        switch (args[0]) {
            case "join": {
                if (Warlords.partyManager.inAParty(player.getUniqueId())) {
                    sender.sendMessage(ChatColor.RED + "You cannot join the queue if you are in a party!");
                    return true;
                }
                if (QueueManager.queue.contains(player.getUniqueId())) {
                    sender.sendMessage(ChatColor.RED + "You are already in the queue!");
                } else {
                    QueueManager.addPlayerToQueue(sender.getName(), false);
                    QueueManager.removePlayerFromFutureQueue(sender.getName());
                    sender.sendMessage(ChatColor.GREEN + "You are now #" + QueueManager.queue.size() + " in queue!");
                    QueueManager.sendQueue();
                }
                return true;
            }
            case "leave": {
                QueueManager.removePlayerFromQueue(sender.getName());
                sender.sendMessage(ChatColor.RED + "You left the queue!");
                QueueManager.sendQueue();
                return true;
            }
            case "add": {
                if (sender.hasPermission("warlords.queue.clear")) {
                    if (args.length == 1) {
                        sender.sendMessage(ChatColor.RED + "Invalid player!");
                        return true;
                    }
                    String playerToAdd = args[1];
                    OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)playerToAdd);
                    if (offlinePlayer == null) {
                        sender.sendMessage(ChatColor.RED + "Invalid player!");
                        return true;
                    }
                    QueueManager.addPlayerToQueue(playerToAdd, false);
                    sender.sendMessage(QueueManager.getQueue());
                    QueueManager.sendQueue();
                } else {
                    sender.sendMessage(ChatColor.RED + "Insufficient Permissions");
                }
            }
            case "remove": {
                if (sender.hasPermission("warlords.queue.clear")) {
                    if (args.length == 1) {
                        sender.sendMessage(ChatColor.RED + "Invalid queue number!");
                        return true;
                    }
                    if (!NumberUtils.isNumber((String)args[1])) {
                        sender.sendMessage(ChatColor.RED + "Invalid queue number!");
                        return true;
                    }
                    int queuePos = Integer.parseInt(args[1]);
                    if (queuePos > QueueManager.queue.size() || queuePos < 1) {
                        sender.sendMessage(ChatColor.RED + "Invalid queue number!");
                        return true;
                    }
                    QueueManager.queue.remove(queuePos - 1);
                    sender.sendMessage(QueueManager.getQueue());
                    QueueManager.sendQueue();
                } else {
                    sender.sendMessage(ChatColor.RED + "Insufficient Permissions");
                }
                return true;
            }
            case "clear": {
                if (sender.hasPermission("warlords.queue.clear")) {
                    QueueManager.queue.clear();
                    QueueManager.futureQueue.clear();
                    QueueManager.sendQueue();
                    sender.sendMessage(ChatColor.GREEN + "Queue cleared");
                } else {
                    sender.sendMessage(ChatColor.RED + "Insufficient Permissions");
                }
                return true;
            }
        }
        sender.sendMessage(ChatColor.RED + "Invalid Arguments (/queue join/leave)");
        return true;
    }

    public void register(Warlords instance) {
        instance.getCommand("queue").setExecutor((CommandExecutor)this);
    }
}

